/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.ToDoRootNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;

public class CustomChangelistTodoTreeStructure
extends TodoTreeStructure {
    private final PsiTodoSearchHelper mySearchHelper;

    public CustomChangelistTodoTreeStructure(Project project, PsiTodoSearchHelper searchHelper) {
        super(project);
        this.mySearchHelper = searchHelper;
    }

    @Override
    public boolean accept(PsiFile psiFile) {
        if (!psiFile.isValid()) {
            return false;
        }
        return this.mySearchHelper.getTodoItemsCount(psiFile) > 0;
    }

    @Override
    public boolean getIsPackagesShown() {
        return this.myArePackagesShown;
    }

    @Override
    Object getFirstSelectableElement() {
        return ((ToDoRootNode)this.myRootElement).getSummaryNode();
    }

    @Override
    protected AbstractTreeNode createRootElement() {
        return new ToDoRootNode(this.myProject, new Object(), this.myBuilder, this.mySummaryElement);
    }

    @Override
    public PsiTodoSearchHelper getSearchHelper() {
        return this.mySearchHelper;
    }
}

