/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.CustomChangelistTodoTreeStructure;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class CustomChangelistTodosTreeBuilder
extends TodoTreeBuilder {
    public static final TodoItem[] EMPTY_ITEMS = new TodoItem[0];
    private final Project myProject;
    private final String myTitle;
    private final MultiMap<PsiFile, TodoItem> myMap;
    private final Set<PsiFile> myIncludedFiles;
    private PsiTodoSearchHelper myPsiTodoSearchHelper;
    private final ChangeListManager myChangeListManager;

    public CustomChangelistTodosTreeBuilder(JTree tree, Project project, String title, Collection<? extends TodoItem> todoItems) {
        super(tree, project);
        this.myProject = project;
        this.myTitle = title;
        this.myMap = new MultiMap();
        this.myIncludedFiles = new HashSet<PsiFile>();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.initMap(todoItems);
        this.initHelper();
    }

    private void initMap(Collection<? extends TodoItem> todoItems) {
        this.buildMap(todoItems);
        this.myIncludedFiles.addAll(this.myMap.keySet());
    }

    private void buildMap(Collection<? extends TodoItem> todoItems) {
        this.myMap.clear();
        for (TodoItem todoItem : todoItems) {
            this.myMap.putValue((Object)todoItem.getFile(), (Object)todoItem);
        }
    }

    private void initHelper() {
        this.myPsiTodoSearchHelper = new PsiTodoSearchHelper(){

            @NotNull
            public PsiFile[] findFilesWithTodoItems() {
                ArrayList<Change> changes2 = new ArrayList<Change>();
                List changeLists = CustomChangelistTodosTreeBuilder.this.myChangeListManager.getChangeLists();
                HashMap<VirtualFile, Change> allChanges = new HashMap<VirtualFile, Change>();
                for (LocalChangeList changeList : changeLists) {
                    Collection currChanges = changeList.getChanges();
                    for (Change currChange : currChanges) {
                        if (currChange.getAfterRevision() == null || currChange.getAfterRevision().getFile().getVirtualFile() == null) continue;
                        allChanges.put(currChange.getAfterRevision().getFile().getVirtualFile(), currChange);
                    }
                }
                for (PsiFile next : CustomChangelistTodosTreeBuilder.this.myIncludedFiles) {
                    Change change = (Change)allChanges.get(next.getVirtualFile());
                    if (change == null) continue;
                    changes2.add(change);
                }
                TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(CustomChangelistTodosTreeBuilder.this.myProject, changes2, CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter());
                worker.execute();
                CustomChangelistTodosTreeBuilder.this.buildMap(worker.inOneList());
                Set files2 = CustomChangelistTodosTreeBuilder.this.myMap.keySet();
                return files2.toArray(PsiFile.EMPTY_ARRAY);
            }

            @NotNull
            public TodoItem[] findTodoItems(@NotNull PsiFile file2) {
                return CustomChangelistTodosTreeBuilder.this.findPatternedTodoItems(file2, CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter());
            }

            @NotNull
            public TodoItem[] findTodoItemsLight(@NotNull PsiFile file2) {
                return this.findTodoItems(file2);
            }

            @NotNull
            public TodoItem[] findTodoItemsLight(@NotNull PsiFile file2, int startOffset, int endOffset) {
                return this.findTodoItems(file2, startOffset, endOffset);
            }

            @NotNull
            public TodoItem[] findTodoItems(@NotNull PsiFile file2, int startOffset, int endOffset) {
                TodoItem[] todoItems = this.findTodoItems(file2);
                if (todoItems.length == 0) {
                    return todoItems;
                }
                TextRange textRange = new TextRange(startOffset, endOffset);
                ArrayList<TodoItem> result2 = new ArrayList<TodoItem>();
                for (TodoItem todoItem : todoItems) {
                    if (!todoItem.getTextRange().contains(textRange)) continue;
                    result2.add(todoItem);
                }
                return result2.isEmpty() ? EMPTY_ITEMS : result2.toArray(new TodoItem[0]);
            }

            public int getTodoItemsCount(@NotNull PsiFile file2) {
                return this.findTodoItems(file2).length;
            }

            public int getTodoItemsCount(@NotNull PsiFile file2, @NotNull TodoPattern pattern) {
                TodoFilter filter = new TodoFilter();
                filter.addTodoPattern(pattern);
                return CustomChangelistTodosTreeBuilder.this.findPatternedTodoItems(file2, filter).length;
            }
        };
    }

    private TodoItem[] findPatternedTodoItems(PsiFile file2, TodoFilter todoFilter) {
        Collection todoItems;
        if (!this.myIncludedFiles.contains(file2)) {
            return EMPTY_ITEMS;
        }
        if (this.myDirtyFileSet.contains(file2.getVirtualFile())) {
            this.myMap.remove((Object)file2);
            Change change = this.myChangeListManager.getChange(file2.getVirtualFile());
            if (change != null) {
                TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(this.myProject, Collections.singletonList(change), todoFilter);
                worker.execute();
                Set<TodoItem> todoItems2 = worker.inOneList();
                if (todoItems2 != null && !todoItems2.isEmpty()) {
                    for (TodoItem todoItem : todoItems2) {
                        this.myMap.putValue((Object)file2, (Object)todoItem);
                    }
                }
            }
        }
        return (todoItems = this.myMap.get((Object)file2)).isEmpty() ? EMPTY_ITEMS : todoItems.toArray(new TodoItem[0]);
    }

    @Override
    @NotNull
    protected TodoTreeStructure createTreeStructure() {
        return new CustomChangelistTodoTreeStructure(this.myProject, this.myPsiTodoSearchHelper);
    }

    @Override
    void rebuildCache() {
        PsiFile[] psiFiles;
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        TodoTreeStructure treeStructure = this.getTodoTreeStructure();
        for (PsiFile psiFile : psiFiles = this.myPsiTodoSearchHelper.findFilesWithTodoItems()) {
            if (this.myPsiTodoSearchHelper.getTodoItemsCount(psiFile) <= 0 || !treeStructure.accept(psiFile)) continue;
            files2.add(psiFile.getVirtualFile());
        }
        super.rebuildCache(files2);
    }
}

