/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.search.TodoItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SmartTodoItemPointer {
    private final TodoItem myTodoItem;
    private final Document myDocument;
    private final RangeMarker myRangeMarker;
    private final List<RangeMarker> myAdditionalRangeMarkers;

    public SmartTodoItemPointer(@NotNull TodoItem todoItem, @NotNull Document document) {
        this.myTodoItem = todoItem;
        this.myDocument = document;
        TextRange textRange = this.myTodoItem.getTextRange();
        this.myRangeMarker = document.createRangeMarker(textRange);
        this.myAdditionalRangeMarkers = ContainerUtil.map((Collection)todoItem.getAdditionalTextRanges(), arg_0 -> ((Document)document).createRangeMarker(arg_0));
    }

    public TodoItem getTodoItem() {
        return this.myTodoItem;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public RangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }

    @NotNull
    public List<RangeMarker> getAdditionalRangeMarkers() {
        return this.myAdditionalRangeMarkers;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SmartTodoItemPointer)) {
            return false;
        }
        SmartTodoItemPointer pointer = (SmartTodoItemPointer)obj;
        if (!this.myTodoItem.getFile().equals(pointer.myTodoItem.getFile()) || this.myRangeMarker.getStartOffset() != pointer.myRangeMarker.getStartOffset() || this.myRangeMarker.getEndOffset() != pointer.myRangeMarker.getEndOffset() || !this.myTodoItem.getPattern().equals((Object)pointer.myTodoItem.getPattern()) || this.myAdditionalRangeMarkers.size() != pointer.myAdditionalRangeMarkers.size()) {
            return false;
        }
        for (int i = 0; i < this.myAdditionalRangeMarkers.size(); ++i) {
            RangeMarker m1 = this.myAdditionalRangeMarkers.get(i);
            RangeMarker m2 = pointer.myAdditionalRangeMarkers.get(i);
            if (m1.getStartOffset() == m2.getStartOffset() && m1.getEndOffset() == m2.getEndOffset()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myTodoItem.getFile().hashCode();
    }
}

