/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.AllTodosTreeBuilder;
import com.intellij.ide.todo.ChangeListTodosPanel;
import com.intellij.ide.todo.ChangeListTodosTreeBuilder;
import com.intellij.ide.todo.CurrentFileTodosPanel;
import com.intellij.ide.todo.CurrentFileTodosTreeBuilder;
import com.intellij.ide.todo.ScopeBasedTodosPanel;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeBuilderFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="TodoView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class TodoView
implements PersistentStateComponent<State>,
Disposable {
    private final Project myProject;
    private ContentManager myContentManager;
    private TodoPanel myAllTodos;
    private final List<TodoPanel> myPanels = new ArrayList<TodoPanel>();
    private final List<Content> myNotAddedContent = new ArrayList<Content>();
    private State state = new State();
    private Content myChangeListTodosContent;
    private final MyVcsListener myVcsListener = new MyVcsListener();

    public TodoView(@NotNull Project project) {
        this.myProject = project;
        this.state.all.arePackagesShown = true;
        this.state.all.isAutoScrollToSource = true;
        this.state.current.isAutoScrollToSource = true;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(TodoConfiguration.PROPERTY_CHANGE, (Object)new MyPropertyChangeListener());
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this.myVcsListener);
    }

    public void loadState(@NotNull State state) {
        this.state = state;
    }

    public State getState() {
        if (this.myContentManager != null) {
            Content content = this.myContentManager.getSelectedContent();
            this.state.selectedIndex = content == null ? -1 : this.myContentManager.getIndexOfContent(content);
        }
        return this.state;
    }

    public void dispose() {
    }

    public void initToolWindow(@NotNull ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content allTodosContent = contentFactory.createContent(null, IdeUICustomization.getInstance().getProjectDisplayName(), false);
        toolWindow.setHelpId("find.todoList");
        this.myAllTodos = new TodoPanel(this.myProject, this.state.all, false, allTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(JTree tree, Project project) {
                AllTodosTreeBuilder builder2 = TodoView.this.createAllTodoBuilder(tree, project);
                builder2.init();
                return builder2;
            }
        };
        allTodosContent.setComponent((JComponent)((Object)this.myAllTodos));
        Disposer.register((Disposable)this, (Disposable)this.myAllTodos);
        if (toolWindow instanceof ToolWindowEx) {
            DefaultActionGroup group = new DefaultActionGroup(){
                {
                    this.getTemplatePresentation().setText("View Options");
                    this.setPopup(true);
                    this.add(TodoView.this.myAllTodos.createAutoScrollToSourceAction());
                    this.addSeparator();
                    this.addAll((ActionGroup)TodoView.this.myAllTodos.createGroupByActionGroup());
                }
            };
            ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)group);
        }
        Content currentFileTodosContent = contentFactory.createContent(null, IdeBundle.message((String)"title.todo.current.file", (Object[])new Object[0]), false);
        CurrentFileTodosPanel currentFileTodos = new CurrentFileTodosPanel(this.myProject, this.state.current, currentFileTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(JTree tree, Project project) {
                CurrentFileTodosTreeBuilder builder2 = new CurrentFileTodosTreeBuilder(tree, project);
                builder2.init();
                return builder2;
            }
        };
        Disposer.register((Disposable)this, (Disposable)currentFileTodos);
        currentFileTodosContent.setComponent((JComponent)((Object)currentFileTodos));
        String tabName = TodoView.getTabNameForChangeList(ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList().getName());
        this.myChangeListTodosContent = contentFactory.createContent(null, tabName, false);
        ChangeListTodosPanel changeListTodos = new ChangeListTodosPanel(this.myProject, this.state.current, this.myChangeListTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(JTree tree, Project project) {
                ChangeListTodosTreeBuilder builder2 = new ChangeListTodosTreeBuilder(tree, project);
                builder2.init();
                return builder2;
            }
        };
        Disposer.register((Disposable)this, (Disposable)changeListTodos);
        this.myChangeListTodosContent.setComponent((JComponent)((Object)changeListTodos));
        Content scopeBasedTodoContent = contentFactory.createContent(null, "Scope Based", false);
        ScopeBasedTodosPanel scopeBasedTodos = new ScopeBasedTodosPanel(this.myProject, this.state.current, scopeBasedTodoContent);
        Disposer.register((Disposable)this, (Disposable)scopeBasedTodos);
        scopeBasedTodoContent.setComponent((JComponent)((Object)scopeBasedTodos));
        this.myContentManager = toolWindow.getContentManager();
        this.myContentManager.addContent(allTodosContent);
        this.myContentManager.addContent(currentFileTodosContent);
        this.myContentManager.addContent(scopeBasedTodoContent);
        if (ProjectLevelVcsManager.getInstance((Project)this.myProject).hasActiveVcss()) {
            this.myVcsListener.myIsVisible = true;
            this.myContentManager.addContent(this.myChangeListTodosContent);
        }
        for (Content content : this.myNotAddedContent) {
            this.myContentManager.addContent(content);
        }
        this.myChangeListTodosContent.setCloseable(false);
        allTodosContent.setCloseable(false);
        currentFileTodosContent.setCloseable(false);
        scopeBasedTodoContent.setCloseable(false);
        Content content = this.myContentManager.getContent(this.state.selectedIndex);
        this.myContentManager.setSelectedContent(content == null ? allTodosContent : content);
        this.myPanels.add(this.myAllTodos);
        this.myPanels.add(changeListTodos);
        this.myPanels.add(currentFileTodos);
        this.myPanels.add(scopeBasedTodos);
    }

    @NotNull
    static String getTabNameForChangeList(@NotNull String changelistName) {
        String suffix;
        return StringUtil.endsWithIgnoreCase((String)(changelistName = changelistName.trim()), (String)(suffix = "Changelist")) ? changelistName : changelistName + " " + suffix;
    }

    @NotNull
    protected AllTodosTreeBuilder createAllTodoBuilder(JTree tree, Project project) {
        return new AllTodosTreeBuilder(tree, project);
    }

    public void refresh() {
        HashMap files2 = new HashMap();
        ReadAction.nonBlocking(() -> {
            if (this.myAllTodos == null) {
                return;
            }
            for (TodoPanel panel2 : this.myPanels) {
                panel2.myTodoTreeBuilder.collectFiles((Processor<? super VirtualFile>)((Processor)virtualFile -> {
                    files2.computeIfAbsent(panel2, p -> new HashSet()).add(virtualFile);
                    return true;
                }));
            }
        }).finishOnUiThread(ModalityState.NON_MODAL, __ -> {
            for (TodoPanel panel2 : this.myPanels) {
                panel2.rebuildCache((Set)ObjectUtils.notNull(files2.get((Object)panel2), new HashSet()));
                panel2.updateTree();
            }
        }).inSmartMode(this.myProject).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    public void addCustomTodoView(final TodoTreeBuilderFactory factory, String title, TodoPanelSettings settings) {
        Content content = ContentFactory.SERVICE.getInstance().createContent(null, title, true);
        final ChangeListTodosPanel panel2 = new ChangeListTodosPanel(this.myProject, settings, content){

            @Override
            protected TodoTreeBuilder createTreeBuilder(JTree tree, Project project) {
                TodoTreeBuilder todoTreeBuilder = factory.createTreeBuilder(tree, project);
                todoTreeBuilder.init();
                return todoTreeBuilder;
            }
        };
        content.setComponent((JComponent)((Object)panel2));
        Disposer.register((Disposable)this, (Disposable)panel2);
        if (this.myContentManager == null) {
            this.myNotAddedContent.add(content);
        } else {
            this.myContentManager.addContent(content);
        }
        this.myPanels.add(panel2);
        content.setCloseable(true);
        content.setDisposer(new Disposable(){

            public void dispose() {
                TodoView.this.myPanels.remove((Object)panel2);
            }
        });
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent e) {
            TodoView.this.refresh();
        }
    }

    private final class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("todoPatterns".equals(e.getPropertyName()) || "todoFilters".equals(e.getPropertyName())) {
                this._updateFilters();
            }
        }

        private void _updateFilters() {
            try {
                if (!DumbService.isDumb((Project)TodoView.this.myProject)) {
                    this.updateFilters();
                    return;
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            DumbService.getInstance((Project)TodoView.this.myProject).smartInvokeLater(this::_updateFilters);
        }

        private void updateFilters() {
            for (TodoPanel panel2 : TodoView.this.myPanels) {
                panel2.updateTodoFilter();
            }
        }
    }

    private final class MyVcsListener
    implements VcsListener {
        private boolean myIsVisible;

        private MyVcsListener() {
        }

        public void directoryMappingChanged() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (TodoView.this.myContentManager == null || TodoView.this.myProject.isDisposed()) {
                    return;
                }
                boolean hasActiveVcss = ProjectLevelVcsManager.getInstance((Project)TodoView.this.myProject).hasActiveVcss();
                if (this.myIsVisible && !hasActiveVcss) {
                    TodoView.this.myContentManager.removeContent(TodoView.this.myChangeListTodosContent, false);
                    this.myIsVisible = false;
                } else if (!this.myIsVisible && hasActiveVcss) {
                    TodoView.this.myContentManager.addContent(TodoView.this.myChangeListTodosContent);
                    this.myIsVisible = true;
                }
            }, ModalityState.NON_MODAL);
        }
    }

    static class State {
        @Attribute(value="selected-index")
        public int selectedIndex;
        @OptionTag(value="selected-file", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings current = new TodoPanelSettings();
        @OptionTag(value="all", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings all = new TodoPanelSettings();
        @OptionTag(value="default-changelist", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings changeList = new TodoPanelSettings();

        State() {
        }
    }
}

