/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.BaseToDoNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ModuleToDoNode
extends BaseToDoNode<Module> {
    public ModuleToDoNode(Project project, @NotNull Module value, TodoTreeBuilder builder2) {
        super(project, value, builder2);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        if (this.myToDoSettings.getIsPackagesShown()) {
            TodoTreeHelper.getInstance(this.getProject()).addPackagesToChildren(children2, (Module)this.getValue(), this.myBuilder);
        } else {
            Iterator<PsiFile> i = this.myBuilder.getAllFiles();
            while (i.hasNext()) {
                PsiFile psiFile = i.next();
                if (psiFile == null) continue;
                VirtualFile virtualFile = psiFile.getVirtualFile();
                boolean isInContent = ModuleRootManager.getInstance((Module)((Module)this.getValue())).getFileIndex().isInContent(virtualFile);
                if (!isInContent) continue;
                TodoFileNode fileNode = new TodoFileNode(this.getProject(), psiFile, this.myBuilder, false);
                if (!this.getTreeStructure().accept(psiFile) || children2.contains((Object)fileNode)) continue;
                children2.add((AbstractTreeNode)fileNode);
            }
        }
        return children2;
    }

    @Override
    public boolean contains(Object element) {
        if (element instanceof TodoItem) {
            Module module = ModuleUtilCore.findModuleForFile((PsiFile)((TodoItem)element).getFile());
            return super.canRepresent((Object)module);
        }
        if (element instanceof PsiElement) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)element));
            return super.canRepresent((Object)module);
        }
        return super.canRepresent(element);
    }

    private TodoTreeStructure getStructure() {
        return this.myBuilder.getTodoTreeStructure();
    }

    public void update(@NotNull PresentationData presentation) {
        if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            return;
        }
        String newName = ((Module)this.getValue()).getName();
        int todoItemCount = this.getTodoItemCount((Module)this.getValue());
        presentation.setLocationString(IdeBundle.message((String)"node.todo.group", (Object[])new Object[]{todoItemCount}));
        presentation.setIcon(ModuleType.get((Module)((Module)this.getValue())).getIcon());
        presentation.setPresentableText(newName);
    }

    public String getTestPresentation() {
        return "Module";
    }

    @Override
    public int getFileCount(Module module) {
        Iterator<PsiFile> iterator = this.myBuilder.getFiles(module);
        int count = 0;
        while (iterator.hasNext()) {
            PsiFile psiFile = iterator.next();
            if (!this.getStructure().accept(psiFile)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getTodoItemCount(Module val) {
        Iterator<PsiFile> iterator = this.myBuilder.getFiles(val);
        int count = 0;
        while (iterator.hasNext()) {
            PsiFile psiFile = iterator.next();
            count += ((Integer)ReadAction.compute(() -> this.getTreeStructure().getTodoItemCount(psiFile))).intValue();
        }
        return count;
    }

    public int getWeight() {
        return 1;
    }
}

