/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.troubleshooting;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.troubleshooting.GeneralTroubleInfoCollector;
import com.intellij.util.text.DateFormatUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class AboutTroubleInfoCollector
implements GeneralTroubleInfoCollector {
    @Override
    @NotNull
    public String getTitle() {
        return "About";
    }

    @Override
    @NotNull
    public String collectInfo(@NotNull Project project) {
        ApplicationInfoImpl appInfo = (ApplicationInfoImpl)ApplicationInfoEx.getInstanceEx();
        Calendar cal = appInfo.getBuildDate();
        String output = "Build version: ";
        output = output + appInfo.getFullApplicationName();
        String buildInfo = IdeBundle.message((String)"about.box.build.number", (Object[])new Object[]{appInfo.getBuild().asString()});
        String buildDate = "";
        if (appInfo.getBuild().isSnapshot()) {
            buildDate = new SimpleDateFormat("HH:mm, ").format(cal.getTime());
        }
        buildDate = buildDate + DateFormatUtil.formatAboutDialogDate((Date)cal.getTime());
        output = output + ' ' + buildInfo + ' ' + buildDate;
        output = output + '\n';
        output = output + "Java version: ";
        Properties properties = System.getProperties();
        output = output + properties.getProperty("java.runtime.version", properties.getProperty("java.version", "unknown"));
        output = output + properties.getProperty("os.arch", "");
        output = output + '\n';
        output = output + "Operating System: ";
        output = output + SystemInfoRt.OS_NAME + " (" + SystemInfoRt.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")";
        output = output + '\n';
        output = output + "JVM version: ";
        output = output + properties.getProperty("java.vm.name", "unknown");
        output = output + ' ' + properties.getProperty("java.vendor", "unknown");
        return output;
    }
}

