/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.troubleshooting;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.project.Project;
import com.intellij.troubleshooting.GeneralTroubleInfoCollector;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PluginTroubleInfoCollector
implements GeneralTroubleInfoCollector {
    @Override
    @NotNull
    public String getTitle() {
        return "Plugins";
    }

    @Override
    @NotNull
    public String collectInfo(@NotNull Project project) {
        PluginManagerCore.getDisabledPlugins();
        IdeaPluginDescriptor[] ourPlugins = PluginManagerCore.getPlugins();
        ArrayList<String> loadedCustom = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        String SPECIAL_IDEA_PLUGIN = "IDEA CORE";
        for (IdeaPluginDescriptor descriptor : ourPlugins) {
            String version2 = descriptor.getVersion();
            String s = descriptor.getName() + (version2 != null ? " (" + version2 + ")" : "");
            if (descriptor.isEnabled()) {
                if (descriptor.isBundled() || SPECIAL_IDEA_PLUGIN.equals(descriptor.getName())) continue;
                loadedCustom.add(s);
                continue;
            }
            disabled.add(s);
        }
        return "Custom plugins: " + loadedCustom + '\n' + "Disabled plugins:" + disabled + '\n';
    }
}

