/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.ConfigurableOptionsTopHitProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionsTopHitProvider
implements SearchTopHitProvider {
    private static final Logger LOG = Logger.getInstance(OptionsTopHitProvider.class);

    @NotNull
    public abstract Collection<OptionDescription> getOptions(@Nullable Project var1);

    @NotNull
    private Collection<OptionDescription> getCachedOptions(@Nullable Project project) {
        Project manager;
        Object object = manager = project != null ? project : ApplicationManager.getApplication();
        if (manager == null || manager.isDisposed()) {
            return Collections.emptyList();
        }
        CachedOptions cache = (CachedOptions)manager.getUserData(CachedOptions.KEY);
        if (cache == null) {
            cache = new CachedOptions((ComponentManager)manager);
        }
        return cache.map.computeIfAbsent(this.getClass(), type -> this.getOptions(project));
    }

    public final void consumeTopHits(@NonNls String pattern, Consumer<Object> collector, Project project) {
        if (!pattern.startsWith(SearchTopHitProvider.getTopHitAccelerator())) {
            return;
        }
        List parts = StringUtil.split((String)(pattern = pattern.substring(1)), (String)" ");
        if (parts.isEmpty()) {
            return;
        }
        String id = (String)parts.get(0);
        if (this.getId().startsWith(id) || pattern.startsWith(" ")) {
            pattern = pattern.startsWith(" ") ? pattern.trim() : pattern.substring(id.length()).trim().toLowerCase();
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
            for (OptionDescription option2 : this.getCachedOptions(project)) {
                if (!matcher.matches(option2.getOption())) continue;
                collector.consume((Object)option2);
            }
        }
    }

    public abstract String getId();

    public boolean isEnabled(@Nullable Project project) {
        return true;
    }

    public static String messageApp(String property) {
        return StringUtil.stripHtml((String)ApplicationBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    static String messageIde(String property) {
        return StringUtil.stripHtml((String)IdeBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    static String messageKeyMap(String property) {
        return StringUtil.stripHtml((String)KeyMapBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    public static final class Activity
    extends PreloadingActivity
    implements StartupActivity {
        @Override
        public void preload(@NotNull ProgressIndicator indicator) {
            Activity.cacheAll(indicator, null);
        }

        public void runActivity(@NotNull Project project) {
            Activity.cacheAll(null, project);
        }

        private static void cacheAll(@Nullable ProgressIndicator indicator, @Nullable Project project) {
            Application application = ApplicationManager.getApplication();
            if (application == null || application.isUnitTestMode()) {
                return;
            }
            long millis = System.currentTimeMillis();
            String name = project == null ? "application" : "project";
            List providers = SearchTopHitProvider.EP_NAME.getExtensionList();
            for (SearchTopHitProvider provider : providers) {
                if (!(provider instanceof OptionsTopHitProvider) || provider instanceof ConfigurableOptionsTopHitProvider) continue;
                Activity.cache((OptionsTopHitProvider)provider, indicator, project);
            }
            application.invokeLater(() -> {
                long start2 = System.currentTimeMillis();
                for (SearchTopHitProvider provider : providers) {
                    if (!(provider instanceof ConfigurableOptionsTopHitProvider)) continue;
                    Activity.cache((ConfigurableOptionsTopHitProvider)provider, indicator, project);
                }
                LOG.info(System.currentTimeMillis() - start2 + " ms spent on EDT to cache options in " + name);
            });
            long delta = System.currentTimeMillis() - millis;
            LOG.info(delta + " ms spent to cache options in " + name);
        }

        private static void cache(@NotNull OptionsTopHitProvider provider, @Nullable ProgressIndicator indicator, @Nullable Project project) {
            if (indicator != null && indicator.isCanceled()) {
                return;
            }
            if (project != null && project.isDisposed()) {
                return;
            }
            if (provider.isEnabled(project)) {
                provider.getCachedOptions(project);
            }
        }
    }

    private static final class CachedOptions
    implements Disposable {
        private static final Key<CachedOptions> KEY = Key.create((String)"cached top hits");
        private final Map<Class<?>, Collection<OptionDescription>> map = new ConcurrentHashMap();
        private final ComponentManager manager;

        private CachedOptions(ComponentManager manager) {
            this.manager = manager;
            Disposer.register((Disposable)manager, (Disposable)this);
            manager.putUserData(KEY, (Object)this);
        }

        public void dispose() {
            this.manager.putUserData(KEY, null);
            this.map.values().forEach(CachedOptions::dispose);
        }

        private static void dispose(Collection<OptionDescription> options) {
            if (options != null) {
                options.forEach(CachedOptions::dispose);
            }
        }

        private static void dispose(OptionDescription option2) {
            if (option2 instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)option2));
            }
        }
    }

    @Deprecated
    public static interface CoveredByToggleActions {
    }
}

