/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UITheme {
    public static final String FILE_EXT_ENDING = ".theme.json";
    private String name;
    private boolean dark;
    private String author;
    private String id;
    private String editorScheme;
    private Map<String, Object> ui;
    private Map<String, Object> icons;
    private IconPathPatcher patcher;
    private Map<String, Object> background;
    private Map<String, Object> colors;
    private ClassLoader providerClassLoader = this.getClass().getClassLoader();
    private String editorSchemeName;
    private SVGLoader.SvgColorPatcher colorPatcher;
    private static final Logger LOG = Logger.getInstance(UITheme.class);
    private static final Map<String, String> colorPalette = new HashMap<String, String>();

    private UITheme() {
    }

    public String getName() {
        return this.name;
    }

    public boolean isDark() {
        return this.dark;
    }

    public String getAuthor() {
        return this.author;
    }

    public static UITheme loadFromJson(InputStream stream, @NotNull String themeId, @Nullable ClassLoader provider) throws IOException {
        final UITheme theme = (UITheme)new ObjectMapper().readValue(stream, UITheme.class);
        theme.id = themeId;
        if (provider != null) {
            theme.providerClassLoader = provider;
        }
        if (theme.icons != null && !theme.icons.isEmpty()) {
            theme.patcher = new IconPathPatcher(){

                @Nullable
                public String patchPath(String path, ClassLoader classLoader) {
                    Object value;
                    if (classLoader instanceof PluginClassLoader) {
                        Object pluginIconPath;
                        String pluginId = ((PluginClassLoader)((Object)classLoader)).getPluginId().getIdString();
                        Object icons = theme.icons.get(pluginId);
                        if (icons instanceof Map && (pluginIconPath = ((Map)icons).get(path)) instanceof String) {
                            return (String)pluginIconPath;
                        }
                    }
                    return (value = theme.icons.get(path)) instanceof String ? (String)value : null;
                }

                @Nullable
                public ClassLoader getContextClassLoader(String path, ClassLoader originalClassLoader) {
                    return theme.providerClassLoader;
                }
            };
            Object palette = theme.icons.get("ColorPalette");
            if (palette instanceof Map) {
                Map colors = (Map)palette;
                final PaletteScopeManager paletteScopeManager = new PaletteScopeManager();
                for (Object o : colors.keySet()) {
                    String colorKey = o.toString();
                    PaletteScope scope = paletteScopeManager.getScope(colorKey);
                    if (scope == null) continue;
                    String key = UITheme.toColorString(colorKey, theme.isDark());
                    Object v = colors.get(colorKey);
                    if (!(v instanceof String)) continue;
                    String value = (String)v;
                    String alpha = null;
                    if (value.length() == 9) {
                        alpha = value.substring(7);
                        value = value.substring(0, 7);
                    }
                    if (ColorUtil.fromHex((String)key, null) == null || ColorUtil.fromHex((String)value, null) == null) continue;
                    scope.newPalette.put(key, value);
                    int fillTransparency = -1;
                    if (alpha != null) {
                        try {
                            fillTransparency = Integer.parseInt(alpha, 16);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (fillTransparency == -1) continue;
                    scope.alphas.put(value, fillTransparency);
                }
                theme.colorPatcher = new SVGLoader.SvgColorPatcher(){

                    public void patchColors(URL url, Element svg) {
                        String newFill;
                        PaletteScope scope = paletteScopeManager.getScopeByURL(url);
                        if (scope == null) {
                            return;
                        }
                        String fill = svg.getAttribute("fill");
                        if (fill != null && (newFill = scope.newPalette.get(StringUtil.toLowerCase((String)fill))) != null) {
                            svg.setAttribute("fill", newFill);
                            if (scope.alphas.get(newFill) != null) {
                                svg.setAttribute("fill-opacity", String.valueOf(Float.valueOf(scope.alphas.get(newFill).intValue()).floatValue() / 255.0f));
                            }
                        }
                        NodeList nodes = svg.getChildNodes();
                        int length = nodes.getLength();
                        for (int i = 0; i < length; ++i) {
                            Node item = nodes.item(i);
                            if (!(item instanceof Element)) continue;
                            this.patchColors(url, (Element)item);
                        }
                    }
                };
            }
        }
        return theme;
    }

    private static String toColorString(String fillValue, boolean darkTheme) {
        String color;
        if (darkTheme && fillValue.startsWith("Actions.") && !fillValue.endsWith(".Dark")) {
            fillValue = fillValue + ".Dark";
        }
        if ((color = colorPalette.get(fillValue)) != null) {
            return StringUtil.toLowerCase((String)color);
        }
        return StringUtil.toLowerCase((String)fillValue);
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getEditorScheme() {
        return this.editorScheme;
    }

    public Map<String, Object> getBackground() {
        return this.background;
    }

    public void applyProperties(UIDefaults defaults) {
        if (this.ui == null) {
            return;
        }
        this.loadColorPalette(defaults);
        for (Map.Entry<String, Object> entry : this.ui.entrySet()) {
            UITheme.apply(this, entry.getKey(), entry.getValue(), defaults);
        }
    }

    private void loadColorPalette(UIDefaults defaults) {
        if (this.colors != null) {
            for (Map.Entry<String, Object> entry : this.colors.entrySet()) {
                Color color;
                Object value = entry.getValue();
                if (!(value instanceof String) || (color = UITheme.parseColor((String)value)) == null) continue;
                defaults.put("ColorPalette." + entry.getKey(), color);
            }
        }
    }

    public IconPathPatcher getPatcher() {
        return this.patcher;
    }

    public SVGLoader.SvgColorPatcher getColorPatcher() {
        return this.colorPatcher;
    }

    @NotNull
    public ClassLoader getProviderClassLoader() {
        return this.providerClassLoader;
    }

    private static void apply(UITheme theme, String key, Object value, UIDefaults defaults) {
        if (value instanceof HashMap) {
            for (Map.Entry o : ((HashMap)value).entrySet()) {
                UITheme.apply(theme, key + "." + (String)o.getKey(), o.getValue(), defaults);
            }
        } else {
            Color color;
            String valueStr = value.toString();
            if (theme.colors != null && theme.colors.containsKey(valueStr) && (color = UITheme.parseColor(String.valueOf(theme.colors.get(valueStr)))) != null) {
                defaults.put(key, color);
                return;
            }
            value = UITheme.parseValue(key, valueStr);
            if (key.startsWith("*.")) {
                String tail = key.substring(1);
                Object finalValue = value;
                UITheme.addPattern(key, value, defaults);
                ((UIDefaults)defaults.clone()).keySet().stream().filter(k -> k instanceof String && ((String)k).endsWith(tail)).forEach(k -> defaults.put(k, finalValue));
            } else {
                defaults.put(key, value);
            }
        }
    }

    private static void addPattern(String key, Object value, UIDefaults defaults) {
        HashMap o = defaults.get("*");
        if (!(o instanceof Map)) {
            o = new HashMap();
            defaults.put("*", o);
        }
        Map map2 = o;
        if (key != null && key.startsWith("*.")) {
            map2.put(key.substring(2), value);
        }
    }

    public static Object parseValue(String key, @NotNull String value) {
        if ("null".equals(value)) {
            return null;
        }
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        if (key.endsWith("Insets") || key.endsWith("padding")) {
            return UITheme.parseInsets(value);
        }
        if (key.endsWith("Border") || key.endsWith("border")) {
            try {
                List ints = StringUtil.split((String)value, (String)",");
                if (ints.size() == 4) {
                    return new BorderUIResource.EmptyBorderUIResource(UITheme.parseInsets(value));
                }
                if (ints.size() == 5) {
                    return JBUI.asUIResource((Border)JBUI.Borders.customLine((Color)ColorUtil.fromHex((String)((String)ints.get(4))), (int)Integer.parseInt((String)ints.get(0)), (int)Integer.parseInt((String)ints.get(1)), (int)Integer.parseInt((String)ints.get(2)), (int)Integer.parseInt((String)ints.get(3))));
                }
                if (ColorUtil.fromHex((String)value, null) != null) {
                    return JBUI.asUIResource((Border)JBUI.Borders.customLine((Color)ColorUtil.fromHex((String)value), (int)1));
                }
                return Class.forName(value).newInstance();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        } else {
            Icon icon;
            if (key.endsWith("Size")) {
                return UITheme.parseSize(value);
            }
            if (key.endsWith("Width")) {
                return UITheme.getInteger(value);
            }
            if (key.endsWith("grayFilter")) {
                return UITheme.parseGrayFilter(value);
            }
            Color color = UITheme.parseColor(value);
            Integer invVal = UITheme.getInteger(value);
            Icon icon2 = icon = value.startsWith("AllIcons.") ? IconLoader.getIcon((String)value) : null;
            if (color != null) {
                return new ColorUIResource(color);
            }
            if (invVal != null) {
                return invVal;
            }
            if (icon != null) {
                return new IconUIResource(icon);
            }
        }
        return value;
    }

    private static Insets parseInsets(String value) {
        List numbers = StringUtil.split((String)value, (String)",");
        return new JBInsets(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1)), Integer.parseInt((String)numbers.get(2)), Integer.parseInt((String)numbers.get(3))).asUIResource();
    }

    private static UIUtil.GrayFilter parseGrayFilter(String value) {
        List numbers = StringUtil.split((String)value, (String)",");
        return new UIUtil.GrayFilter(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1)), Integer.parseInt((String)numbers.get(2))).asUIResource();
    }

    private static Color parseColor(String value) {
        if (value != null && (value = StringUtil.trimStart((String)value, (String)"#")).length() == 8) {
            Color color = ColorUtil.fromHex((String)value.substring(0, 6));
            try {
                int alpha = Integer.parseInt(value.substring(6, 8), 16);
                return new ColorUIResource(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return ColorUtil.fromHex((String)value, null);
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Dimension parseSize(String value) {
        List numbers = StringUtil.split((String)value, (String)",");
        return new JBDimension(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1))).asUIResource();
    }

    public String getEditorSchemeName() {
        return this.editorSchemeName;
    }

    public void setEditorSchemeName(String editorSchemeName) {
        this.editorSchemeName = editorSchemeName;
    }

    @Contract(value="null -> false")
    public static boolean isThemeFile(@Nullable VirtualFile file2) {
        return file2 != null && StringUtil.endsWithIgnoreCase((String)file2.getName(), (String)FILE_EXT_ENDING);
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setDark(boolean dark) {
        this.dark = dark;
    }

    private void setAuthor(String author) {
        this.author = author;
    }

    private void setUi(Map<String, Object> ui) {
        this.ui = ui;
    }

    private void setIcons(Map<String, Object> icons) {
        this.icons = icons;
    }

    public void setEditorScheme(String editorScheme) {
        this.editorScheme = editorScheme;
    }

    public void setBackground(Map<String, Object> background) {
        this.background = background;
    }

    public Map<String, Object> getColors() {
        return this.colors;
    }

    public void setColors(Map<String, Object> colors) {
        this.colors = colors;
    }

    static {
        colorPalette.put("Actions.Red", "#DB5860");
        colorPalette.put("Actions.Red.Dark", "#C75450");
        colorPalette.put("Actions.Yellow", "#EDA200");
        colorPalette.put("Actions.Yellow.Dark", "#F0A732");
        colorPalette.put("Actions.Green", "#59A869");
        colorPalette.put("Actions.Green.Dark", "#499C54");
        colorPalette.put("Actions.Blue", "#389FD6");
        colorPalette.put("Actions.Blue.Dark", "#3592C4");
        colorPalette.put("Actions.Grey", "#6E6E6E");
        colorPalette.put("Actions.Grey.Dark", "#AFB1B3");
        colorPalette.put("Actions.GreyInline", "#7F8B91");
        colorPalette.put("Actions.GreyInline.Dark", "#7F8B91");
        colorPalette.put("Objects.Grey", "#9AA7B0");
        colorPalette.put("Objects.Blue", "#40B6E0");
        colorPalette.put("Objects.Green", "#62B543");
        colorPalette.put("Objects.Yellow", "#F4AF3D");
        colorPalette.put("Objects.YellowDark", "#D9A343");
        colorPalette.put("Objects.Purple", "#B99BF8");
        colorPalette.put("Objects.Pink", "#F98B9E");
        colorPalette.put("Objects.Red", "#F26522");
        colorPalette.put("Objects.RedStatus", "#E05555");
        colorPalette.put("Objects.GreenAndroid", "#A4C639");
        colorPalette.put("Objects.BlackText", "#231F20");
        colorPalette.put("Checkbox.Background.Default", "#FFFFFF");
        colorPalette.put("Checkbox.Background.Default.Dark", "#43494A");
        colorPalette.put("Checkbox.Background.Disabled", "#F2F2F2");
        colorPalette.put("Checkbox.Background.Disabled.Dark", "#3C3F41");
        colorPalette.put("Checkbox.Border.Default", "#878787");
        colorPalette.put("Checkbox.Border.Default.Dark", "#6B6B6B");
        colorPalette.put("Checkbox.Border.Disabled", "#BDBDBD");
        colorPalette.put("Checkbox.Border.Disabled.Dark", "#545556");
        colorPalette.put("Checkbox.Focus.Thin.Default", "#7B9FC7");
        colorPalette.put("Checkbox.Focus.Thin.Default.Dark", "#466D94");
        colorPalette.put("Checkbox.Focus.Wide", "#97C3F3");
        colorPalette.put("Checkbox.Focus.Wide.Dark", "#3D6185");
        colorPalette.put("Checkbox.Foreground.Disabled", "#ABABAB");
        colorPalette.put("Checkbox.Foreground.Disabled.Dark", "#606060");
        colorPalette.put("Checkbox.Background.Selected", "#4D89C9");
        colorPalette.put("Checkbox.Background.Selected.Dark", "#43494A");
        colorPalette.put("Checkbox.Border.Selected", "#4982CC");
        colorPalette.put("Checkbox.Border.Selected.Dark", "#6B6B6B");
        colorPalette.put("Checkbox.Foreground.Selected", "#FFFFFF");
        colorPalette.put("Checkbox.Foreground.Selected.Dark", "#A7A7A7");
        colorPalette.put("Checkbox.Focus.Thin.Selected", "#ACCFF7");
        colorPalette.put("Checkbox.Focus.Thin.Selected.Dark", "#466D94");
    }

    static class PaletteScopeManager {
        PaletteScope ui = new PaletteScope();
        PaletteScope checkBoxes = new PaletteScope();
        PaletteScope radioButtons = new PaletteScope();

        PaletteScopeManager() {
        }

        PaletteScope getScope(String colorKey) {
            if (colorKey.startsWith("Checkbox.")) {
                return this.checkBoxes;
            }
            if (colorKey.startsWith("Radio.")) {
                return this.radioButtons;
            }
            if (colorKey.startsWith("Objects.")) {
                return this.ui;
            }
            if (colorKey.startsWith("Actions.")) {
                return this.ui;
            }
            if (colorKey.startsWith("#")) {
                return this.ui;
            }
            LOG.warn("No color scope defined for key: " + colorKey);
            return null;
        }

        PaletteScope getScopeByURL(URL url) {
            if (url != null) {
                String path = url.toString();
                String file2 = path.substring(path.lastIndexOf(47) + 1);
                if (path.contains("/com/intellij/ide/ui/laf/icons/")) {
                    if (file2.startsWith("check")) {
                        return this.checkBoxes;
                    }
                    if (file2.startsWith("radio")) {
                        return this.checkBoxes;
                    }
                    return null;
                }
            }
            return this.ui;
        }
    }

    static class PaletteScope {
        Map<String, String> newPalette = new HashMap<String, String>();
        Map<String, Integer> alphas = new HashMap<String, Integer>();

        PaletteScope() {
        }
    }
}

