/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.extensions.PluginId;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UIThemeMetadata {
    private String name;
    private String pluginId;
    private boolean fixed;
    private List<UIKeyMetadata> ui;

    static UIThemeMetadata loadFromJson(InputStream stream, PluginId pluginId) throws IOException {
        UIThemeMetadata metadata = (UIThemeMetadata)new ObjectMapper().readValue(stream, UIThemeMetadata.class);
        metadata.pluginId = pluginId.getIdString();
        return metadata;
    }

    public String getName() {
        return this.name;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public List<UIKeyMetadata> getUiKeyMetadata() {
        return this.ui;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    private void setUi(List<UIKeyMetadata> ui) {
        this.ui = ui;
    }

    public static class UIKeyMetadata {
        private String key;
        private String description;
        private String source;
        private boolean deprecated;

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public String getKey() {
            return this.key;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Nullable
        public String getSource() {
            return this.source;
        }

        private void setKey(String key) {
            this.key = key;
        }

        private void setDescription(String description) {
            this.description = description;
        }

        private void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }

        private void setSource(String source) {
            this.source = source;
        }

        public String toString() {
            return "UIKeyMetadata{key='" + this.key + '\'' + ", description='" + this.description + '\'' + ", source='" + this.source + '\'' + ", deprecated=" + this.deprecated + '}';
        }
    }
}

