/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.DefaultMetalTheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntelliJLaf
extends DarculaLaf {
    @Override
    public String getName() {
        return "IntelliJ";
    }

    @Override
    @NotNull
    protected String getPrefix() {
        return UIUtil.isUnderWin10LookAndFeel() ? "intellijlaf_native" : "intellijlaf";
    }

    @Override
    @Nullable
    protected String getSystemPrefix() {
        if (SystemInfo.isLinux) {
            return super.getSystemPrefix();
        }
        if (SystemInfo.isWindows) {
            return UIUtil.isUnderWin10LookAndFeel() ? null : this.getPrefix() + "_windows";
        }
        if (SystemInfo.isMac) {
            return UIUtil.isUnderDefaultMacTheme() ? this.getPrefix() + "_mac" : null;
        }
        return null;
    }

    @Override
    protected BasicLookAndFeel createBaseLookAndFeel() {
        Registry.get((String)"ide.intellij.laf.win10.ui").addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                try {
                    UIManager.setLookAndFeel(UIManager.getLookAndFeel());
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
            }
        }, this.myDisposable);
        return super.createBaseLookAndFeel();
    }

    @Override
    protected DefaultMetalTheme createMetalTheme() {
        return new IdeaBlueMetalTheme();
    }

    public static Color getSelectedControlColor() {
        return MacUtil.colorFromNative((ID)Foundation.invoke((String)"NSColor", (String)"alternateSelectedControlColor", (Object[])new Object[0]));
    }
}

