/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.ide.ui.laf.IdeaLookAndFeelInfo;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.IntelliJLookAndFeelInfo;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.BasicOptionButtonUI;
import com.intellij.ui.mac.MacPopupMenuUI;
import com.intellij.ui.popup.OurHeavyWeightPopup;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LafManager", storages={@Storage(value="laf.xml", roamingType=RoamingType.PER_OS)})
public final class LafManagerImpl
extends LafManager
implements PersistentStateComponent<Element>,
Disposable,
BaseComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.LafManager");
    @NonNls
    private static final String ELEMENT_LAF = "laf";
    @NonNls
    private static final String ATTRIBUTE_CLASS_NAME = "class-name";
    @NonNls
    private static final String ATTRIBUTE_THEME_NAME = "themeId";
    private static final String DARCULA_EDITOR_THEME_KEY = "Darcula.SavedEditorTheme";
    private static final String DEFAULT_EDITOR_THEME_KEY = "Default.SavedEditorTheme";
    @NonNls
    private static final String[] ourPatchableFontResources = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "MenuItem.acceleratorFont", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "FormattedTextField.font", "Spinner.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};
    @NonNls
    private static final String[] ourFileChooserTextKeys = new String[]{"FileChooser.viewMenuLabelText", "FileChooser.newFolderActionLabelText", "FileChooser.listViewActionLabelText", "FileChooser.detailsViewActionLabelText", "FileChooser.refreshActionLabelText"};
    private final EventDispatcher<LafManagerListener> myEventDispatcher = EventDispatcher.create(LafManagerListener.class);
    private final UIManager.LookAndFeelInfo[] myLaFs;
    private final UIDefaults ourDefaults;
    private UIManager.LookAndFeelInfo myCurrentLaf;
    private final Map<UIManager.LookAndFeelInfo, HashMap<String, Object>> myStoredDefaults = ContainerUtil.newHashMap();
    public static final String WINDOW_ALPHA = "Window.alpha";
    private static final Map<String, String> ourLafClassesAliases = ContainerUtil.newHashMap();
    private boolean myFirstSetup = true;
    private static LafManagerImpl ourTestInstance;

    LafManagerImpl() {
        ArrayList lafList = ContainerUtil.newArrayList();
        this.ourDefaults = (UIDefaults)UIManager.getDefaults().clone();
        if (SystemInfo.isMac) {
            lafList.add(new UIManager.LookAndFeelInfo("Light", IntelliJLaf.class.getName()));
        } else {
            if (LafManagerImpl.isIntelliJLafEnabled()) {
                lafList.add(new IntelliJLookAndFeelInfo());
            } else {
                lafList.add(new IdeaLookAndFeelInfo());
            }
            for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                String name = laf.getName();
                if ("Metal".equalsIgnoreCase(name) || "CDE/Motif".equalsIgnoreCase(name) || "Nimbus".equalsIgnoreCase(name) || name.startsWith("Windows") || "GTK+".equalsIgnoreCase(name) || name.startsWith("JGoodies")) continue;
                lafList.add(laf);
            }
        }
        lafList.add(new DarculaLookAndFeelInfo());
        lafList.addAll(UIThemeProvider.EP_NAME.getExtensionList().stream().map(UIThemeProvider::createTheme).filter(x -> x != null).map(UIThemeBasedLookAndFeelInfo::new).collect(Collectors.toList()));
        this.myLaFs = lafList.toArray(new UIManager.LookAndFeelInfo[0]);
        if (!SystemInfo.isMac) {
            Arrays.sort(this.myLaFs, (obj1, obj2) -> {
                String name1 = obj1.getName();
                String name2 = obj2.getName();
                return name1.compareToIgnoreCase(name2);
            });
        }
        this.myCurrentLaf = this.getDefaultLaf();
    }

    private static boolean isIntelliJLafEnabled() {
        return !Registry.is((String)"idea.4.5.laf.enabled");
    }

    public void addLafManagerListener(@NotNull LafManagerListener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void addLafManagerListener(@NotNull LafManagerListener listener2, @NotNull Disposable disposable) {
        this.myEventDispatcher.addListener((EventListener)listener2, disposable);
    }

    public void removeLafManagerListener(@NotNull LafManagerListener listener2) {
        this.myEventDispatcher.removeListener((EventListener)listener2);
    }

    public void initComponent() {
        UIManager.LookAndFeelInfo laf;
        if (this.myCurrentLaf != null && !(this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo) && (laf = this.findLaf(this.myCurrentLaf.getClassName())) != null) {
            boolean needUninstall = UIUtil.isUnderDarcula();
            this.setCurrentLookAndFeel(laf);
            this.updateWizardLAF(needUninstall);
        }
        if (this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo && !((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).isInitialised()) {
            this.setCurrentLookAndFeel(this.myCurrentLaf);
        }
        this.updateUI();
    }

    public void updateWizardLAF(boolean wasUnderDarcula) {
        if (WelcomeWizardUtil.getWizardLAF() != null) {
            if (UIUtil.isUnderDarcula()) {
                DarculaInstaller.install();
            } else if (wasUnderDarcula) {
                DarculaInstaller.uninstall();
            }
            WelcomeWizardUtil.setWizardLAF(null);
        }
    }

    public void dispose() {
    }

    public void loadState(@NotNull Element element) {
        String className = null;
        UIManager.LookAndFeelInfo laf = null;
        Element lafElement = element.getChild(ELEMENT_LAF);
        if (lafElement != null) {
            String themeId;
            className = lafElement.getAttributeValue(ATTRIBUTE_CLASS_NAME);
            if (className != null && ourLafClassesAliases.containsKey(className)) {
                className = ourLafClassesAliases.get(className);
            }
            if ((themeId = lafElement.getAttributeValue(ATTRIBUTE_THEME_NAME)) != null) {
                laf = Arrays.stream(this.myLaFs).filter(l -> l instanceof UIThemeBasedLookAndFeelInfo && ((UIThemeBasedLookAndFeelInfo)l).getTheme().getId().equals(themeId)).findFirst().orElse(null);
            }
        }
        if (laf == null) {
            laf = this.findLaf(className);
        }
        if (laf == null) {
            laf = this.getDefaultLaf();
        }
        this.myCurrentLaf = laf;
    }

    public Element getState() {
        String className;
        Element element = new Element("state");
        UIManager.LookAndFeelInfo laf = this.myCurrentLaf;
        if (laf instanceof TempUIThemeBasedLookAndFeelInfo) {
            laf = ((TempUIThemeBasedLookAndFeelInfo)laf).getPreviousLaf();
        }
        if (laf != null && (className = laf.getClassName()) != null) {
            Element child2 = new Element(ELEMENT_LAF);
            child2.setAttribute(ATTRIBUTE_CLASS_NAME, className);
            if (laf instanceof UIThemeBasedLookAndFeelInfo) {
                child2.setAttribute(ATTRIBUTE_THEME_NAME, ((UIThemeBasedLookAndFeelInfo)laf).getTheme().getId());
            }
            element.addContent(child2);
        }
        return element;
    }

    @NotNull
    public UIManager.LookAndFeelInfo[] getInstalledLookAndFeels() {
        return (UIManager.LookAndFeelInfo[])this.myLaFs.clone();
    }

    public UIManager.LookAndFeelInfo getCurrentLookAndFeel() {
        return this.myCurrentLaf;
    }

    public UIManager.LookAndFeelInfo getDefaultLaf() {
        String defaultLafName;
        UIManager.LookAndFeelInfo laf;
        String appLafName;
        UIManager.LookAndFeelInfo laf2;
        String wizardLafName = WelcomeWizardUtil.getWizardLAF();
        if (wizardLafName != null) {
            UIManager.LookAndFeelInfo laf3 = this.findLaf(wizardLafName);
            if (laf3 != null) {
                return laf3;
            }
            LOG.error("Could not find wizard L&F: " + wizardLafName);
        }
        if (SystemInfo.isMac) {
            String className = IntelliJLaf.class.getName();
            laf2 = this.findLaf(className);
            if (laf2 != null) {
                return laf2;
            }
            LOG.error("Could not find OS X L&F: " + className);
        }
        if ((appLafName = WelcomeWizardUtil.getDefaultLAF()) != null) {
            laf2 = this.findLaf(appLafName);
            if (laf2 != null) {
                return laf2;
            }
            LOG.error("Could not find app L&F: " + appLafName);
        }
        if ((laf = this.findLaf(defaultLafName = LafManagerImpl.isIntelliJLafEnabled() ? IntelliJLaf.class.getName() : "idea.laf.classname")) != null) {
            return laf;
        }
        throw new IllegalStateException("No default L&F found: " + defaultLafName);
    }

    @Nullable
    private UIManager.LookAndFeelInfo findLaf(@Nullable String className) {
        return Arrays.stream(this.myLaFs).filter(l -> !(l instanceof UIThemeBasedLookAndFeelInfo) && Comparing.equal((String)l.getClassName(), (String)className)).findFirst().orElse(null);
    }

    public void setCurrentLookAndFeel(@NotNull UIManager.LookAndFeelInfo lookAndFeelInfo) {
        LookAndFeel laf;
        UIManager.LookAndFeelInfo oldLaf = this.myCurrentLaf;
        if (this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo) {
            ((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).dispose();
        }
        if (this.findLaf(lookAndFeelInfo.getClassName()) == null) {
            LOG.error("unknown LookAndFeel : " + lookAndFeelInfo);
            return;
        }
        UIManager.getDefaults().clear();
        UIManager.getDefaults().putAll(this.ourDefaults);
        if ("idea.laf.classname".equals(lookAndFeelInfo.getClassName())) {
            laf = new IdeaLaf();
            MetalLookAndFeel.setCurrentTheme(new IdeaBlueMetalTheme());
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        if (DarculaLookAndFeelInfo.CLASS_NAME.equals(lookAndFeelInfo.getClassName())) {
            laf = new DarculaLaf();
            try {
                UIManager.setLookAndFeel(laf);
                LafManagerImpl.updateForDarcula(true);
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        try {
            laf = (LookAndFeel)Class.forName(lookAndFeelInfo.getClassName()).newInstance();
            if (laf instanceof MetalLookAndFeel) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            if (laf instanceof UserDataHolder && lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo) {
                ((UserDataHolder)laf).putUserData(UIUtil.LAF_WITH_THEME_KEY, (Object)Boolean.TRUE);
            }
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo) {
            try {
                ((UIThemeBasedLookAndFeelInfo)lookAndFeelInfo).installTheme(UIManager.getLookAndFeelDefaults());
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        if (SystemInfo.isMacOSYosemite) {
            LafManagerImpl.installMacOSXFonts(UIManager.getLookAndFeelDefaults());
        }
        this.myCurrentLaf = (UIManager.LookAndFeelInfo)ObjectUtils.chooseNotNull((Object)lookAndFeelInfo, (Object)this.findLaf(lookAndFeelInfo.getClassName()));
        if (!this.myFirstSetup) {
            ApplicationManager.getApplication().invokeLater(() -> this.updateEditorSchemeIfNecessary(oldLaf));
        }
        this.myFirstSetup = false;
    }

    private void updateEditorSchemeIfNecessary(UIManager.LookAndFeelInfo oldLaf) {
        if (oldLaf instanceof TempUIThemeBasedLookAndFeelInfo || this.myCurrentLaf instanceof TempUIThemeBasedLookAndFeelInfo) {
            return;
        }
        if (this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo && ((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).getTheme().getEditorSchemeName() != null) {
            return;
        }
        boolean dark = UIUtil.isUnderDarcula();
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme current = colorsManager.getGlobalScheme();
        boolean wasUITheme = oldLaf instanceof UIThemeBasedLookAndFeelInfo;
        if (dark != ColorUtil.isDark((Color)current.getDefaultBackground()) || wasUITheme) {
            EditorColorsScheme scheme2;
            String targetScheme = dark ? "Darcula" : "Default";
            PropertiesComponent properties = PropertiesComponent.getInstance();
            String savedEditorThemeKey = dark ? DARCULA_EDITOR_THEME_KEY : DEFAULT_EDITOR_THEME_KEY;
            String toSavedEditorThemeKey = dark ? DEFAULT_EDITOR_THEME_KEY : DARCULA_EDITOR_THEME_KEY;
            String themeName = properties.getValue(savedEditorThemeKey);
            if (themeName != null && colorsManager.getScheme(themeName) != null) {
                targetScheme = themeName;
            }
            if (!wasUITheme) {
                properties.setValue(toSavedEditorThemeKey, current.getName(), dark ? "Default" : "Darcula");
            }
            if ((scheme2 = colorsManager.getScheme(targetScheme)) != null) {
                colorsManager.setGlobalScheme(scheme2);
            }
        }
        UISettings.getShadowInstance().fireUISettingsChanged();
        ActionToolbarImpl.updateAllToolbarsImmediately();
    }

    public static void updateForDarcula(boolean isDarcula) {
        JBColor.setDark((boolean)isDarcula);
        IconLoader.setUseDarkIcons((boolean)isDarcula);
    }

    @Nullable
    private static Icon getAquaMenuDisabledIcon() {
        Icon arrowIcon = (Icon)UIManager.get("Menu.arrowIcon");
        if (arrowIcon != null) {
            return IconLoader.getDisabledIcon((Icon)arrowIcon);
        }
        return null;
    }

    @Nullable
    private static Icon getAquaMenuInvertedIcon() {
        if (UIUtil.isUnderAquaLookAndFeel() || SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            return AllIcons.Mac.Tree_white_right_arrow;
        }
        return null;
    }

    public void updateUI() {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        LafManagerImpl.fixPopupWeight();
        LafManagerImpl.fixMenuIssues(uiDefaults);
        if (UIUtil.isUnderAquaLookAndFeel()) {
            uiDefaults.put("Panel.opaque", Boolean.TRUE);
        }
        LafManagerImpl.initInputMapDefaults(uiDefaults);
        uiDefaults.put("Button.defaultButtonFollowsFocus", Boolean.FALSE);
        uiDefaults.put("Balloon.error.textInsets", new JBInsets(3, 8, 3, 8).asUIResource());
        LafManagerImpl.patchFileChooserStrings(uiDefaults);
        this.patchLafFonts(uiDefaults);
        LafManagerImpl.patchHiDPI(uiDefaults);
        LafManagerImpl.fixSeparatorColor(uiDefaults);
        LafManagerImpl.fixProgressBar(uiDefaults);
        LafManagerImpl.fixOptionButton(uiDefaults);
        for (Frame frame : Frame.getFrames()) {
            LafManagerImpl.updateUI(frame);
        }
        ((LafManagerListener)this.myEventDispatcher.getMulticaster()).lookAndFeelChanged((LafManager)this);
    }

    @NotNull
    private static FontUIResource getFont(String yosemite, int size, @JdkConstants.FontStyle int style) {
        Font font;
        if (SystemInfo.isMacOSElCapitan && !UIUtil.isDialogFont((Font)(font = new Font(".SF NS Text", style, size)))) {
            return new FontUIResource(font);
        }
        return new FontUIResource(yosemite, style, size);
    }

    public static void installMacOSXFonts(UIDefaults defaults) {
        String face = "HelveticaNeue-Regular";
        FontUIResource uiFont = LafManagerImpl.getFont("HelveticaNeue-Regular", 13, 0);
        LafManagerImpl.initFontDefaults(defaults, uiFont);
        for (Object key : new HashSet(defaults.keySet())) {
            FontUIResource font;
            Object value = defaults.get(key);
            if (!(value instanceof FontUIResource) || !(font = (FontUIResource)value).getFamily().equals("Lucida Grande") && !font.getFamily().equals("Serif") || key.toString().contains("Menu")) continue;
            defaults.put(key, LafManagerImpl.getFont("HelveticaNeue-Regular", font.getSize(), font.getStyle()));
        }
        FontUIResource uiFont11 = LafManagerImpl.getFont("HelveticaNeue-Regular", 11, 0);
        defaults.put("TableHeader.font", uiFont11);
        FontUIResource buttonFont = LafManagerImpl.getFont("HelveticaNeue-Medium", 13, 0);
        defaults.put("Button.font", buttonFont);
        FontUIResource menuFont = LafManagerImpl.getFont("Lucida Grande", 14, 0);
        defaults.put("Menu.font", menuFont);
        defaults.put("MenuItem.font", menuFont);
        defaults.put("MenuItem.acceleratorFont", menuFont);
        defaults.put("PasswordField.font", defaults.getFont("TextField.font"));
    }

    private static void patchHiDPI(UIDefaults defaults) {
        float prevScale;
        Object prevScaleVal = defaults.get("hidpi.scaleFactor");
        float f = prevScale = prevScaleVal != null ? ((Float)prevScaleVal).floatValue() : 1.0f;
        if (prevScale == JBUI.scale((float)1.0f) && prevScaleVal != null) {
            return;
        }
        List<String> myIntKeys = Arrays.asList("Tree.leftChildIndent", "Tree.rightChildIndent", "Tree.rowHeight");
        List<String> myDimensionKeys = Arrays.asList("Slider.horizontalSize", "Slider.verticalSize", "Slider.minimumHorizontalSize", "Slider.minimumVerticalSize");
        for (Map.Entry entry : defaults.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey().toString();
            if (value instanceof Dimension) {
                if (!(value instanceof UIResource) && !myDimensionKeys.contains(key)) continue;
                entry.setValue(JBUI.size((Dimension)((Dimension)value)).asUIResource());
                continue;
            }
            if (value instanceof Insets) {
                if (!(value instanceof UIResource)) continue;
                entry.setValue(JBUI.insets((Insets)((Insets)value)).asUIResource());
                continue;
            }
            if (!(value instanceof Integer) || !key.endsWith(".maxGutterIconWidth") && !myIntKeys.contains(key)) continue;
            int normValue = (int)((float)((Integer)value).intValue() / prevScale);
            entry.setValue(JBUI.scale((int)normValue));
        }
        defaults.put("hidpi.scaleFactor", Float.valueOf(JBUI.scale((float)1.0f)));
    }

    private static void fixMenuIssues(UIDefaults uiDefaults) {
        if (UIUtil.isUnderAquaLookAndFeel() || SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            uiDefaults.put("PopupMenuUI", MacPopupMenuUI.class.getCanonicalName());
            uiDefaults.put("Menu.invertedArrowIcon", LafManagerImpl.getAquaMenuInvertedIcon());
            uiDefaults.put("Menu.disabledArrowIcon", LafManagerImpl.getAquaMenuDisabledIcon());
        }
        if (UIUtil.isUnderWin10LookAndFeel()) {
            uiDefaults.put("Menu.arrowIcon", new Win10MenuArrowIcon());
        } else if ((SystemInfo.isLinux || SystemInfo.isWindows) && (UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderDarcula())) {
            uiDefaults.put("Menu.arrowIcon", new DefaultMenuArrowIcon(AllIcons.General.ArrowRight));
        }
        uiDefaults.put("MenuItem.background", UIManager.getColor("Menu.background"));
    }

    private static void fixSeparatorColor(UIDefaults uiDefaults) {
        if (UIUtil.isUnderAquaLookAndFeel()) {
            uiDefaults.put("Separator.background", UIUtil.AQUA_SEPARATOR_BACKGROUND_COLOR);
            uiDefaults.put("Separator.separatorColor", UIUtil.AQUA_SEPARATOR_FOREGROUND_COLOR);
        }
    }

    private static void fixProgressBar(UIDefaults uiDefaults) {
        if (!UIUtil.isUnderIntelliJLaF() && !UIUtil.isUnderDarcula()) {
            uiDefaults.put("ProgressBarUI", "com.intellij.ide.ui.laf.darcula.ui.DarculaProgressBarUI");
            uiDefaults.put("ProgressBar.border", "com.intellij.ide.ui.laf.darcula.ui.DarculaProgressBarBorder");
        }
    }

    private static void fixOptionButton(UIDefaults uiDefaults) {
        if (!UIUtil.isUnderIntelliJLaF() && !UIUtil.isUnderDarcula()) {
            uiDefaults.put("OptionButtonUI", BasicOptionButtonUI.class.getCanonicalName());
        }
    }

    private static void fixPopupWeight() {
        int popupWeight = 1;
        String property = System.getProperty("idea.popup.weight");
        if (property != null) {
            property = property.toLowerCase(Locale.ENGLISH).trim();
        }
        if (SystemInfo.isMacOSLeopard) {
            popupWeight = 2;
        } else if (property == null) {
            if (SystemInfo.isWindows) {
                popupWeight = 2;
            }
        } else if ("light".equals(property)) {
            popupWeight = 0;
        } else if ("heavy".equals(property)) {
            popupWeight = 2;
        } else if (!"medium".equals(property)) {
            LOG.error("Illegal value of property \"idea.popup.weight\": " + property);
        }
        PopupFactory factory = PopupFactory.getSharedInstance();
        if (!(factory instanceof OurPopupFactory)) {
            factory = new OurPopupFactory(factory);
            PopupFactory.setSharedInstance(factory);
        }
        PopupUtil.setPopupType((PopupFactory)factory, (int)popupWeight);
    }

    private static void patchFileChooserStrings(UIDefaults defaults) {
        if (!defaults.containsKey(ourFileChooserTextKeys[0])) {
            for (String key : ourFileChooserTextKeys) {
                defaults.put(key, IdeBundle.message((String)key, (Object[])new Object[0]));
            }
        }
    }

    private void patchLafFonts(UIDefaults uiDefaults) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            this.storeOriginalFontDefaults(uiDefaults);
            LafManagerImpl.initFontDefaults(uiDefaults, UIUtil.getFontWithFallback((String)uiSettings.getFontFace(), (int)0, (int)uiSettings.getFontSize()));
            JBUI.setUserScaleFactor((float)JBUI.getFontScale((float)uiSettings.getFontSize()));
        } else {
            this.restoreOriginalFontDefaults(uiDefaults);
        }
    }

    private void restoreOriginalFontDefaults(UIDefaults defaults) {
        UIManager.LookAndFeelInfo lf = this.getCurrentLookAndFeel();
        HashMap<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults != null) {
            for (String resource : ourPatchableFontResources) {
                defaults.put(resource, lfDefaults.get(resource));
            }
        }
        JBUI.setUserScaleFactor((float)JBUI.getFontScale((float)JBUI.Fonts.label().getSize()));
    }

    private void storeOriginalFontDefaults(UIDefaults defaults) {
        UIManager.LookAndFeelInfo lf = this.getCurrentLookAndFeel();
        HashMap<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults == null) {
            lfDefaults = new HashMap();
            for (String resource : ourPatchableFontResources) {
                lfDefaults.put(resource, defaults.get(resource));
            }
            this.myStoredDefaults.put(lf, lfDefaults);
        }
    }

    private static void updateUI(Window window) {
        Window[] children2;
        IJSwingUtilities.updateComponentTreeUI(window);
        for (Window w : children2 = window.getOwnedWindows()) {
            IJSwingUtilities.updateComponentTreeUI(w);
        }
    }

    public void repaintUI() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            LafManagerImpl.repaintUI(frame);
        }
    }

    private static void repaintUI(Window window) {
        Window[] children2;
        if (!window.isDisplayable()) {
            return;
        }
        window.repaint();
        for (Window aChildren : children2 = window.getOwnedWindows()) {
            LafManagerImpl.repaintUI(aChildren);
        }
    }

    private static void installCutCopyPasteShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String copyActionKey = useSimpleActionKeys ? "copy" : "copy-to-clipboard";
        String pasteActionKey = useSimpleActionKeys ? "paste" : "paste-from-clipboard";
        String cutActionKey = useSimpleActionKeys ? "cut" : "cut-to-clipboard";
        inputMap.put(KeyStroke.getKeyStroke(155, 130), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(155, 65), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(127, 65), cutActionKey);
        inputMap.put(KeyStroke.getKeyStroke(67, 130), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(86, 130), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(88, 130), "cut-to-clipboard");
    }

    public static void initInputMapDefaults(UIDefaults defaults) {
        InputMap tableInputMap;
        InputMap passwordFieldInputMap;
        InputMap textFieldInputMap;
        InputMap textAreaInputMap;
        InputMap treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (treeInputMap != null) {
            treeInputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        if ((textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textAreaInputMap, false);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textFieldInputMap, false);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(passwordFieldInputMap, false);
        }
        if ((tableInputMap = (InputMap)defaults.get("Table.ancestorInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(tableInputMap, true);
        }
    }

    public static void initFontDefaults(@NotNull UIDefaults defaults, @NotNull FontUIResource uiFont) {
        defaults.put("Tree.ancestorInputMap", (Object)null);
        FontUIResource textFont = new FontUIResource(uiFont);
        FontUIResource monoFont = new FontUIResource("Monospaced", 0, uiFont.getSize());
        for (String fontResource : ourPatchableFontResources) {
            defaults.put(fontResource, uiFont);
        }
        if (!SystemInfo.isMac) {
            defaults.put("PasswordField.font", monoFont);
        }
        defaults.put("TextArea.font", monoFont);
        defaults.put("TextPane.font", textFont);
        defaults.put("EditorPane.font", textFont);
    }

    public static LafManagerImpl getTestInstance() {
        if (ourTestInstance == null) {
            ourTestInstance = new LafManagerImpl();
        }
        return ourTestInstance;
    }

    static {
        ourLafClassesAliases.put("idea.dark.laf.classname", DarculaLookAndFeelInfo.CLASS_NAME);
    }

    private static class Win10MenuArrowIcon
    extends MenuArrowIcon {
        private static final String NAME = "menuTriangle";

        private Win10MenuArrowIcon() {
            super(LafIconLookup.getIcon((String)NAME), LafIconLookup.getSelectedIcon((String)NAME), LafIconLookup.getDisabledIcon((String)NAME));
        }
    }

    private static class DefaultMenuArrowIcon
    extends MenuArrowIcon {
        private static final boolean invert = UIUtil.isUnderDarcula();

        private DefaultMenuArrowIcon(@NotNull Icon icon) {
            super(invert ? IconUtil.brighter((Icon)icon, (int)2) : IconUtil.darker((Icon)icon, (int)2), IconUtil.brighter((Icon)icon, (int)8), invert ? IconUtil.darker((Icon)icon, (int)2) : IconUtil.brighter((Icon)icon, (int)2));
        }
    }

    private static abstract class MenuArrowIcon
    implements Icon,
    UIResource {
        private final Icon icon;
        private final Icon selectedIcon;
        private final Icon disabledIcon;

        private MenuArrowIcon(Icon icon, Icon selectedIcon, Icon disabledIcon) {
            this.icon = icon;
            this.selectedIcon = selectedIcon;
            this.disabledIcon = disabledIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            if (!model.isEnabled()) {
                this.disabledIcon.paintIcon(c, g, x, y);
            } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                this.selectedIcon.paintIcon(c, g, x, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    private static class OurPopupFactory
    extends PopupFactory {
        public static final int WEIGHT_LIGHT = 0;
        public static final int WEIGHT_MEDIUM = 1;
        public static final int WEIGHT_HEAVY = 2;
        private final PopupFactory myDelegate;

        OurPopupFactory(PopupFactory delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Popup getPopup(Component owner, Component contents, int x, int y) {
            boolean isHeavyWeightPopup;
            Point point = OurPopupFactory.fixPopupLocation(contents, x, y);
            int popupType = PopupUtil.getPopupType((PopupFactory)this);
            if (popupType == 2 && OurHeavyWeightPopup.isEnabled()) {
                return new OurHeavyWeightPopup(owner, contents, point.x, point.y);
            }
            if (popupType >= 0) {
                PopupUtil.setPopupType((PopupFactory)this.myDelegate, (int)popupType);
            }
            Popup popup2 = this.myDelegate.getPopup(owner, contents, point.x, point.y);
            final Window window = UIUtil.getWindow((Component)contents);
            final String cleanupKey = "LafManagerImpl.rootPaneCleanup";
            boolean bl = isHeavyWeightPopup = window instanceof RootPaneContainer && window != UIUtil.getWindow((Component)owner);
            if (isHeavyWeightPopup) {
                UIUtil.markAsTypeAheadAware((Window)window);
            }
            if (isHeavyWeightPopup && ((RootPaneContainer)((Object)window)).getRootPane().getClientProperty(cleanupKey) == null) {
                final JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                rootPane.putClientProperty(LafManagerImpl.WINDOW_ALPHA, Float.valueOf(1.0f));
                rootPane.putClientProperty(cleanupKey, cleanupKey);
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        if (PopupUtil.getPopupContainerFor((Component)rootPane) != null) {
                            window.removeWindowListener(this);
                            rootPane.putClientProperty(cleanupKey, null);
                        }
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        window.removeWindowListener(this);
                        rootPane.putClientProperty(cleanupKey, null);
                        DialogWrapper.cleanupRootPane((JRootPane)rootPane);
                        DialogWrapper.cleanupWindowListeners((Window)window);
                    }
                });
            }
            return popup2;
        }

        private static Point fixPopupLocation(Component contents, int x, int y) {
            PointerInfo info;
            if (!(contents instanceof JToolTip)) {
                return new Point(x, y);
            }
            try {
                info = MouseInfo.getPointerInfo();
            }
            catch (InternalError e) {
                return new Point(x, y);
            }
            int deltaY = 0;
            if (info != null) {
                Point mouse = info.getLocation();
                deltaY = mouse.y - y;
            }
            Dimension size = contents.getPreferredSize();
            Rectangle rec = new Rectangle(new Point(x, y), size);
            ScreenUtil.moveRectangleToFitTheScreen((Rectangle)rec);
            if (rec.y < y) {
                rec.y += deltaY;
            }
            return rec.getLocation();
        }
    }
}

