/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;

public class WinIntelliJButtonBorder
implements Border,
UIResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof AbstractButton) || UIUtil.isHelpButton((Component)c)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        AbstractButton b = (AbstractButton)c;
        Rectangle outerRect = new Rectangle(x, y, width, height);
        try {
            JBInsets.removeFrom((Rectangle)outerRect, (Insets)b.getInsets());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Path2D.Float border = new Path2D.Float(0);
            border.append(outerRect, false);
            Rectangle innerRect = new Rectangle(outerRect);
            JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)this.getBorderWidth(b)));
            border.append(innerRect, false);
            g2.setColor(WinIntelliJButtonBorder.getBorderColor(b));
            if (!c.isEnabled()) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
            }
            g2.fill(border);
        }
        finally {
            g2.dispose();
        }
    }

    private static Color getBorderColor(AbstractButton b) {
        ButtonModel bm = b.getModel();
        Color focusedBorderColor = (Color)b.getClientProperty("JButton.focusedBorderColor");
        if (bm.isPressed()) {
            return focusedBorderColor != null ? focusedBorderColor : UIManager.getColor("Button.intellij.native.pressedBorderColor");
        }
        if (b.hasFocus() || bm.isRollover() || DarculaButtonUI.isDefaultButton(b)) {
            return focusedBorderColor != null ? focusedBorderColor : UIManager.getColor("Button.intellij.native.focusedBorderColor");
        }
        Color borderColor = (Color)b.getClientProperty("JButton.borderColor");
        return borderColor != null ? borderColor : UIManager.getColor("Button.intellij.native.borderColor");
    }

    protected boolean isWideBorder(@NotNull AbstractButton b) {
        ButtonModel bm = b.getModel();
        return b.isEnabled() && !bm.isPressed() && !b.hasFocus() && !bm.isRollover() && DarculaButtonUI.isDefaultButton(b);
    }

    protected int getBorderWidth(@NotNull AbstractButton b) {
        return this.isWideBorder(b) ? 2 : 1;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return JBUI.insets((int)1);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

