/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.annotations.NotNull;

class IndexedCharsInterner {
    private int[] idToIndex = new int[10];
    private final OpenTHashSet<CharSequence> mySet = new OpenTHashSet<CharSequence>(10, 0.9f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_SENSITIVE){

        protected void rehash(int newCapacity) {
            Object[] oldSet = this._set;
            int oldSize = IndexedCharsInterner.this.mySet.size();
            super.rehash(newCapacity);
            for (int i = 0; i < oldSize - 1; ++i) {
                int oldIndex = IndexedCharsInterner.this.idToIndex[i];
                CharSequence oldString = (CharSequence)oldSet[oldIndex];
                int newIndex = this.index(oldString);
                assert (newIndex != -1);
                ((IndexedCharsInterner)IndexedCharsInterner.this).idToIndex[i] = newIndex;
            }
        }
    };

    IndexedCharsInterner() {
    }

    public int toId(@NotNull String name) {
        int id;
        CharSequence seq = ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)name);
        int index = this.mySet.index((Object)seq);
        if (index == -1) {
            id = this.mySet.size();
            this.mySet.add((Object)seq);
            index = this.mySet.index((Object)seq);
            assert (index != -1);
            if (id >= this.idToIndex.length) {
                this.idToIndex = ArrayUtil.realloc((int[])this.idToIndex, (int)(this.idToIndex.length * 3 / 2));
            }
            this.idToIndex[id] = index;
            assert (ArrayUtil.indexOf((int[])this.idToIndex, (int)index) == id);
            assert (this.toId(name) == id);
        } else {
            id = ArrayUtil.indexOf((int[])this.idToIndex, (int)index);
        }
        assert (StringUtil.equals((CharSequence)this.fromId(id), (CharSequence)name));
        return id;
    }

    @NotNull
    public CharSequence fromId(int id) {
        assert (id >= 0 && id < this.mySet.size());
        return (CharSequence)this.mySet.get(this.idToIndex[id]);
    }
}

