/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurableProxy;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.TraverseUIHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class TraverseUIStarter
extends ApplicationStarterEx {
    private static final String OPTIONS = "options";
    private static final String CONFIGURABLE = "configurable";
    private static final String ID = "id";
    private static final String CONFIGURABLE_NAME = "configurable_name";
    private static final String OPTION = "option";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String HIT = "hit";
    private static final String ROOT_ACTION_MODULE = "intellij.platform.ide";
    private String OUTPUT_PATH;
    private boolean SPLIT_BY_RESOURCE_PATH;

    public boolean isHeadless() {
        return true;
    }

    public String getCommandName() {
        return "traverseUI";
    }

    public void premain(String[] args) {
        this.OUTPUT_PATH = args[1];
        this.SPLIT_BY_RESOURCE_PATH = args.length > 2 && Boolean.valueOf(args[2]) != false;
    }

    public void main(String[] args) {
        System.out.println("Starting searchable options index builder");
        try {
            TraverseUIStarter.startup(this.OUTPUT_PATH, this.SPLIT_BY_RESOURCE_PATH);
            ((ApplicationEx)ApplicationManager.getApplication()).exit(true, true);
        }
        catch (Throwable e) {
            System.out.println("Searchable options index builder failed");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void startup(@NotNull String outputPath, boolean splitByResourcePath) throws IOException {
        LinkedHashMap<SearchableConfigurable, Set<OptionDescription>> options = new LinkedHashMap<SearchableConfigurable, Set<OptionDescription>>();
        try {
            void var5_9;
            void var5_7;
            Object object = (TraverseUIHelper[])TraverseUIHelper.helperExtensionPoint.getExtensions();
            int n = ((TraverseUIHelper[])object).length;
            boolean bl = false;
            while (var5_7 < n) {
                TraverseUIHelper extension = object[var5_7];
                extension.beforeStart();
                ++var5_7;
            }
            SearchUtil.processProjectConfigurables(ProjectManager.getInstance().getDefaultProject(), options);
            object = (TraverseUIHelper[])TraverseUIHelper.helperExtensionPoint.getExtensions();
            n = ((TraverseUIHelper[])object).length;
            boolean bl2 = false;
            while (var5_9 < n) {
                TraverseUIHelper extension1 = object[var5_9];
                extension1.afterTraversal(options);
                ++var5_9;
            }
            HashMap roots = ContainerUtil.newHashMap();
            Iterator<Object> iterator = options.keySet().iterator();
            while (iterator.hasNext()) {
                Element entryElement;
                Map.Entry entry;
                Object wrapped;
                SearchableConfigurable searchableConfigurable;
                SearchableConfigurable configurable = searchableConfigurable = (SearchableConfigurable)iterator.next();
                Element element = TraverseUIStarter.createConfigurableElement(configurable);
                Set sortedOptions = (Set)options.get(configurable);
                TraverseUIStarter.writeOptions(element, sortedOptions);
                if (configurable instanceof ConfigurableWrapper && (wrapped = ((ConfigurableWrapper)configurable).getConfigurable()) instanceof SearchableConfigurable) {
                    configurable = (SearchableConfigurable)wrapped;
                }
                if (configurable instanceof KeymapPanel) {
                    wrapped = TraverseUIStarter.processKeymap(splitByResourcePath).entrySet().iterator();
                    while (wrapped.hasNext()) {
                        entry = (Map.Entry)wrapped.next();
                        entryElement = TraverseUIStarter.createConfigurableElement(configurable);
                        TraverseUIStarter.writeOptions(entryElement, (Set)entry.getValue());
                        TraverseUIStarter.addElement(roots, entryElement, (String)entry.getKey());
                    }
                } else if (configurable instanceof OptionsContainingConfigurable) {
                    TraverseUIStarter.processOptionsContainingConfigurable((OptionsContainingConfigurable)configurable, element);
                } else if (configurable instanceof PluginManagerConfigurableProxy) {
                    wrapped = TraverseUIStarter.wordsToOptionDescriptors(Collections.singleton("Manage repositories...")).iterator();
                    while (wrapped.hasNext()) {
                        OptionDescription description = (OptionDescription)wrapped.next();
                        TraverseUIStarter.append(null, "Manage repositories...", description.getOption(), element);
                    }
                } else if (configurable instanceof AllFileTemplatesConfigurable) {
                    wrapped = TraverseUIStarter.processFileTemplates(splitByResourcePath).entrySet().iterator();
                    while (wrapped.hasNext()) {
                        entry = (Map.Entry)wrapped.next();
                        entryElement = TraverseUIStarter.createConfigurableElement(configurable);
                        TraverseUIStarter.writeOptions(entryElement, (Set)entry.getValue());
                        TraverseUIStarter.addElement(roots, entryElement, (String)entry.getKey());
                    }
                }
                String module = splitByResourcePath ? TraverseUIStarter.getModuleByClass(configurable.getOriginalClass()) : "";
                TraverseUIStarter.addElement(roots, element, module);
            }
            for (Map.Entry entry : roots.entrySet()) {
                String module = (String)entry.getKey();
                String string = module.isEmpty() ? "" : module + "/search/";
                String filePrefix = module.isEmpty() ? "" : module + ".";
                File output = new File(outputPath, string + filePrefix + "searchableOptions.xml");
                FileUtil.ensureCanCreateFile((File)output);
                JDOMUtil.writeDocument((Document)new Document((Element)entry.getValue()), (File)output, (String)"\n");
            }
            for (Iterator<Object> iterator2 : (TraverseUIHelper[])TraverseUIHelper.helperExtensionPoint.getExtensions()) {
                iterator2.afterResultsAreSaved();
            }
            System.out.println("Searchable options index builder completed");
        }
        finally {
            for (SearchableConfigurable configurable : options.keySet()) {
                configurable.disposeUIResources();
            }
        }
    }

    @NotNull
    private static Element createConfigurableElement(@NotNull SearchableConfigurable configurable) {
        Element configurableElement = new Element(CONFIGURABLE);
        String id = configurable.getId();
        configurableElement.setAttribute(ID, id);
        configurableElement.setAttribute(CONFIGURABLE_NAME, configurable.getDisplayName());
        return configurableElement;
    }

    private static void addElement(@NotNull Map<String, Element> roots, @NotNull Element element, @NotNull String module) {
        roots.computeIfAbsent(module, __ -> new Element(OPTIONS)).addContent(element);
    }

    private static Map<String, Set<OptionDescription>> processFileTemplates(boolean splitByResourcePath) {
        SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        HashMap options = ContainerUtil.newHashMap();
        FileTemplateManager fileTemplateManager = FileTemplateManager.getDefaultInstance();
        TraverseUIStarter.processTemplates(optionsRegistrar, options, fileTemplateManager.getAllTemplates(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options, fileTemplateManager.getAllPatterns(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options, fileTemplateManager.getAllCodeTemplates(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options, fileTemplateManager.getAllJ2eeTemplates(), splitByResourcePath);
        return options;
    }

    private static void processTemplates(SearchableOptionsRegistrar registrar, Map<String, Set<OptionDescription>> options, FileTemplate[] templates, boolean splitByResourcePath) {
        for (FileTemplate template : templates) {
            String module = splitByResourcePath && template instanceof BundledFileTemplate ? TraverseUIStarter.getModuleByTemplate((BundledFileTemplate)template) : "";
            TraverseUIStarter.collectOptions(registrar, options.computeIfAbsent(module, __ -> new TreeSet()), template.getName(), null);
        }
    }

    @NotNull
    private static String getModuleByTemplate(@NotNull BundledFileTemplate template) {
        String url = template.toString();
        String path = StringUtil.substringBefore((String)url, (String)"fileTemplates");
        assert (path != null) : "Template URL doesn't contain 'fileTemplates' directory.";
        if (path.startsWith("jar")) {
            path = StringUtil.trimEnd((String)path, (String)"!/");
        }
        return PathUtil.getFileName((String)path);
    }

    private static void collectOptions(SearchableOptionsRegistrar registrar, Set<? super OptionDescription> options, @NotNull String text, String path) {
        for (String word : registrar.getProcessedWordsWithoutStemming(text)) {
            options.add((OptionDescription)new OptionDescription(word, text, path));
        }
    }

    private static void processOptionsContainingConfigurable(OptionsContainingConfigurable configurable, Element configurableElement) {
        Set<String> optionsPath = configurable.processListOptions();
        Set<OptionDescription> result2 = TraverseUIStarter.wordsToOptionDescriptors(optionsPath);
        TraverseUIStarter.writeOptions(configurableElement, result2);
    }

    private static Set<OptionDescription> wordsToOptionDescriptors(@NotNull Set<String> optionsPath) {
        SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        TreeSet<OptionDescription> result2 = new TreeSet<OptionDescription>();
        for (String opt : optionsPath) {
            for (String word : registrar.getProcessedWordsWithoutStemming(opt)) {
                if (word == null) continue;
                result2.add(new OptionDescription(word, opt, null));
            }
        }
        return result2;
    }

    private static Map<String, Set<OptionDescription>> processKeymap(boolean splitByResourcePath) {
        HashMap map2 = ContainerUtil.newHashMap();
        ActionManager actionManager = ActionManager.getInstance();
        Map<String, Object> actionToPluginId = splitByResourcePath ? TraverseUIStarter.getActionToPluginId() : Collections.emptyMap();
        String componentName = "ActionManager";
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set<String> ids = ((ActionManagerImpl)actionManager).getActionIds();
        for (String id : ids) {
            String description;
            AnAction anAction = (AnAction)ObjectUtils.notNull((Object)actionManager.getAction(id));
            String module = splitByResourcePath ? TraverseUIStarter.getModuleByAction(anAction, actionToPluginId) : "";
            Set options = map2.computeIfAbsent(module, __ -> new TreeSet());
            String text = anAction.getTemplatePresentation().getText();
            if (text != null) {
                TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options, text, "ActionManager");
            }
            if ((description = anAction.getTemplatePresentation().getDescription()) == null) continue;
            TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options, description, "ActionManager");
        }
        return map2;
    }

    @NotNull
    private static Map<String, PluginId> getActionToPluginId() {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        HashMap actionToPluginId = ContainerUtil.newHashMap();
        for (PluginId id : PluginId.getRegisteredIds().values()) {
            for (String action : actionManager.getPluginActions(id)) {
                actionToPluginId.put(action, id);
            }
        }
        return actionToPluginId;
    }

    @NotNull
    private static String getModuleByAction(@NotNull AnAction rootAction, @NotNull Map<String, PluginId> actionToPluginId) {
        IdeaPluginDescriptor plugin;
        ArrayDeque<AnAction> actions = new ArrayDeque<AnAction>();
        actions.add(rootAction);
        while (!actions.isEmpty()) {
            AnAction action = (AnAction)actions.remove();
            String module = TraverseUIStarter.getModuleByClass(action.getClass());
            if (!ROOT_ACTION_MODULE.equals(module)) {
                return module;
            }
            if (!(action instanceof ActionGroup)) continue;
            Collections.addAll(actions, ((ActionGroup)action).getChildren(null));
        }
        ActionManager actionManager = ActionManager.getInstance();
        PluginId id = actionToPluginId.get(actionManager.getId(rootAction));
        if (id != null && (plugin = PluginManager.getPlugin(id)) != null && !plugin.getName().equals("IDEA CORE")) {
            return PathUtil.getFileName((String)plugin.getPath().getPath());
        }
        return ROOT_ACTION_MODULE;
    }

    @NotNull
    private static String getModuleByClass(@NotNull Class<?> aClass) {
        return PathUtil.getFileName((String)PathUtil.getJarPathForClass(aClass));
    }

    private static void writeOptions(Element configurableElement, Set<? extends OptionDescription> options) {
        for (OptionDescription optionDescription : options) {
            TraverseUIStarter.append(optionDescription.getPath(), optionDescription.getHit(), optionDescription.getOption(), configurableElement);
        }
    }

    private static void append(String path, String hit, String word, Element configurableElement) {
        Element optionElement = new Element(OPTION);
        optionElement.setAttribute(NAME, word);
        if (path != null) {
            optionElement.setAttribute(PATH, path);
        }
        optionElement.setAttribute(HIT, hit);
        configurableElement.addContent(optionElement);
    }
}

