/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteHandler {
    private DeleteHandler() {
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, Project project) {
        DeleteHandler.deletePsiElement(elementsToDelete, project, true);
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, final Project project, boolean needConfirmation) {
        if (elementsToDelete == null || elementsToDelete.length == 0) {
            return;
        }
        final PsiElement[] elements = PsiTreeUtil.filterAncestors((PsiElement[])elementsToDelete);
        boolean safeDeleteApplicable = Arrays.stream(elements).allMatch(SafeDeleteProcessor::validElement);
        boolean dumb = DumbService.getInstance((Project)project).isDumb();
        if (safeDeleteApplicable && !dumb) {
            final Ref exit = Ref.create((Object)false);
            SafeDeleteDialog dialog2 = new SafeDeleteDialog(project, elements, new SafeDeleteDialog.Callback(){

                @Override
                public void run(SafeDeleteDialog dialog2) {
                    if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(elements), (boolean)true)) {
                        return;
                    }
                    SafeDeleteProcessor processor2 = SafeDeleteProcessor.createInstance(project, () -> {
                        exit.set((Object)true);
                        dialog2.close(0);
                    }, elements, dialog2.isSearchInComments(), dialog2.isSearchForTextOccurences(), true);
                    processor2.run();
                }
            }){

                @Override
                protected boolean isDelete() {
                    return true;
                }
            };
            if (needConfirmation) {
                dialog2.setTitle(RefactoringBundle.message((String)"delete.title"));
                if (!dialog2.showAndGet() || ((Boolean)exit.get()).booleanValue()) {
                    return;
                }
            }
        } else {
            int result2;
            String warningMessage = DeleteUtil.generateWarningMessage(IdeBundle.message((String)"prompt.delete.elements", (Object[])new Object[0]), elements);
            boolean anyDirectories = false;
            String directoryName = null;
            for (PsiElement psiElement : elementsToDelete) {
                if (!(psiElement instanceof PsiDirectory) || PsiUtilBase.isSymLink((PsiFileSystemItem)((PsiDirectory)psiElement))) continue;
                anyDirectories = true;
                directoryName = ((PsiDirectory)psiElement).getName();
                break;
            }
            if (anyDirectories) {
                warningMessage = elements.length == 1 ? warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories", (Object[])new Object[]{directoryName}) : warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories.in.the.selected.directory", (Object[])new Object[0]);
            }
            if (safeDeleteApplicable) {
                warningMessage = warningMessage + "\n\nWarning:\n  Safe delete is not available while " + ApplicationNamesInfo.getInstance().getFullProductName() + " updates indices,\n  no usages will be checked.";
            }
            if (needConfirmation && (result2 = Messages.showOkCancelDialog((Project)project, (String)warningMessage, (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) != 0) {
                return;
            }
        }
        DeleteHandler.deleteInCommand(project, elements);
    }

    private static boolean makeWritable(Project project, PsiElement[] elements) {
        List directories = ContainerUtil.newSmartList();
        for (PsiElement e : elements) {
            if (!(e instanceof PsiFileSystemItem) || e.getParent() == null) continue;
            directories.add(e.getParent());
        }
        return CommonRefactoringUtil.checkReadOnlyStatus((Project)project, Arrays.asList(elements), (Collection)directories, (boolean)false);
    }

    private static void deleteInCommand(Project project, PsiElement[] elements) {
        CommandProcessor.getInstance().executeCommand(project, () -> NonProjectFileWritingAccessProvider.disableChecksDuring(() -> {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
            List pointers = ContainerUtil.map((Object[])elements, arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0));
            if (!DeleteHandler.makeWritable(project, elements)) {
                return;
            }
            if (CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext()) == null) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            }
            for (SmartPsiElementPointer pointer : pointers) {
                PsiElement elementToDelete = pointer.getElement();
                if (elementToDelete == null) continue;
                DeleteHandler.doDelete(project, elementToDelete);
            }
        }), RefactoringBundle.message((String)"safe.delete.command", (Object[])new Object[]{RefactoringUIUtil.calculatePsiElementDescriptionList(elements)}), null);
    }

    private static boolean clearFileReadOnlyFlags(Project project, PsiElement elementToDelete) {
        VirtualFile virtualFile;
        PsiFile file2;
        if (elementToDelete instanceof PsiDirectory) {
            VirtualFile virtualFile2 = ((PsiDirectory)elementToDelete).getVirtualFile();
            if (virtualFile2.isInLocalFileSystem() && !virtualFile2.is(VFileProperty.SYMLINK)) {
                ArrayList readOnlyFiles = new ArrayList();
                CommonRefactoringUtil.collectReadOnlyFiles((VirtualFile)virtualFile2, readOnlyFiles);
                if (!readOnlyFiles.isEmpty()) {
                    VirtualFile file3;
                    String message = IdeBundle.message((String)"prompt.directory.contains.read.only.files", (Object[])new Object[]{virtualFile2.getPresentableUrl()});
                    int _result = Messages.showYesNoDialog((Project)project, (String)message, (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (_result != 0) {
                        return false;
                    }
                    boolean success2 = true;
                    Iterator iterator = readOnlyFiles.iterator();
                    while (iterator.hasNext() && (success2 = DeleteHandler.clearReadOnlyFlag(file3 = (VirtualFile)iterator.next(), project))) {
                    }
                    if (!success2) {
                        return false;
                    }
                }
            }
        } else if (!(elementToDelete.isWritable() || elementToDelete instanceof PsiFileSystemItem && PsiUtilBase.isSymLink((PsiFileSystemItem)((PsiFileSystemItem)elementToDelete)) || (file2 = elementToDelete.getContainingFile()) == null || !(virtualFile = file2.getVirtualFile()).isInLocalFileSystem())) {
            int _result = ((MessagesEx.MessageInfo)((MessagesEx.MessageInfo)MessagesEx.fileIsReadOnly(project, virtualFile).setTitle(IdeBundle.message((String)"title.delete", (Object[])new Object[0]))).appendMessage(" " + IdeBundle.message((String)"prompt.delete.it.anyway", (Object[])new Object[0]))).askYesNo();
            if (_result != 0) {
                return false;
            }
            boolean success3 = DeleteHandler.clearReadOnlyFlag(virtualFile, project);
            if (!success3) {
                return false;
            }
        }
        return true;
    }

    private static void doDelete(Project project, PsiElement element) {
        if (!DeleteHandler.clearFileReadOnlyFlags(project, element)) {
            return;
        }
        try {
            element.checkDelete();
        }
        catch (IncorrectOperationException ex) {
            Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                element.delete();
            }
            catch (IncorrectOperationException ex) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon()));
            }
        });
    }

    private static boolean clearReadOnlyFlag(VirtualFile virtualFile, Project project) {
        boolean[] success2 = new boolean[1];
        CommandProcessor.getInstance().executeCommand(project, () -> {
            Runnable action = () -> {
                try {
                    ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)virtualFile, (boolean)false);
                    success2[0] = true;
                }
                catch (IOException e1) {
                    Messages.showMessageDialog((Project)project, (String)e1.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                }
            };
            ApplicationManager.getApplication().runWriteAction(action);
        }, "", null);
        return success2[0];
    }

    public static boolean shouldEnableDeleteAction(PsiElement[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (PsiElement element : elements) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (virtualFile == null || virtualFile instanceof LightVirtualFile) {
                return false;
            }
            if (WritingAccessProvider.isPotentiallyWritable((VirtualFile)virtualFile, (Project)element.getProject())) continue;
            return false;
        }
        return true;
    }

    public static class DefaultDeleteProvider
    implements DeleteProvider {
        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (CommonDataKeys.PROJECT.getData(dataContext) == null) {
                return false;
            }
            PsiElement[] elements = DefaultDeleteProvider.getPsiElements(dataContext);
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        @Nullable
        private static PsiElement[] getPsiElements(DataContext dataContext) {
            PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
            if (elements == null) {
                PsiElement data = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
                if (data != null) {
                    elements = new PsiElement[]{data};
                } else {
                    PsiFile data1 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
                    if (data1 != null) {
                        elements = new PsiElement[]{data1};
                    }
                }
            }
            return elements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            PsiElement[] elements = DefaultDeleteProvider.getPsiElements(dataContext);
            if (elements == null) {
                return;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return;
            }
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, project);
            }
            finally {
                a.finish();
            }
        }
    }
}

