/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ViewStructureAction;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.structureView.newStructureView.TreeActionWrapper;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.util.ActionShortcutProvider;
import com.intellij.ide.util.FileStructureFilter;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.StructureViewCompositeModel;
import com.intellij.ide.util.TreeStructureActionsOwner;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PlaceProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.SpeedSearchObjectWithWeight;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.TextRangeUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class FileStructurePopup
implements Disposable,
TreeActionsOwner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.FileStructurePopup");
    private static final String NARROW_DOWN_PROPERTY_KEY = "FileStructurePopup.narrowDown";
    private final Project myProject;
    private final FileEditor myFileEditor;
    private final StructureViewModel myTreeModelWrapper;
    private final StructureViewModel myTreeModel;
    private final TreeStructureActionsOwner myTreeActionsOwner;
    private JBPopup myPopup;
    private String myTitle;
    private final Tree myTree;
    private final SmartTreeStructure myTreeStructure;
    private final FilteringTreeStructure myFilteringStructure;
    private final AsyncTreeModel myAsyncTreeModel;
    private final StructureTreeModel myStructureTreeModel;
    private final TreeSpeedSearch mySpeedSearch;
    private final Object myInitialElement;
    private final Map<Class, JBCheckBox> myCheckBoxes = new HashMap<Class, JBCheckBox>();
    private final List<JBCheckBox> myAutoClicked = new ArrayList<JBCheckBox>();
    private String myTestSearchFilter;
    private final ActionCallback myTreeHasBuilt = new ActionCallback();
    private final List<Pair<String, JBCheckBox>> myTriggeredCheckboxes = new ArrayList<Pair<String, JBCheckBox>>();
    private final TreeExpander myTreeExpander;
    private final CopyPasteDelegator myCopyPasteDelegator;
    private boolean myCanClose = true;
    private boolean myDisposed;

    @Deprecated
    public FileStructurePopup(@NotNull Project project, @NotNull FileEditor fileEditor, @NotNull StructureView structureView, boolean applySortAndFilter) {
        this(project, fileEditor, ViewStructureAction.createStructureViewModel(project, fileEditor, structureView));
        Disposer.register((Disposable)this, (Disposable)structureView);
    }

    public FileStructurePopup(@NotNull Project project, @NotNull FileEditor fileEditor, @NotNull StructureViewModel treeModel) {
        this.myProject = project;
        this.myFileEditor = fileEditor;
        this.myTreeModel = treeModel;
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)this);
        IdeFocusManager.getInstance((Project)this.myProject).typeAheadUntil(this.myTreeHasBuilt, "FileStructurePopup");
        this.myTreeActionsOwner = new TreeStructureActionsOwner(this.myTreeModel);
        this.myTreeActionsOwner.setActionIncluded((TreeAction)Sorter.ALPHA_SORTER, true);
        this.myTreeModelWrapper = new TreeModelWrapper(this.myTreeModel, this.myTreeActionsOwner);
        this.myTreeStructure = new SmartTreeStructure(project, (TreeModel)this.myTreeModelWrapper){

            @Override
            public void rebuildTree() {
                if (!ApplicationManager.getApplication().isUnitTestMode() && FileStructurePopup.this.myPopup.isDisposed()) {
                    return;
                }
                super.rebuildTree();
                FileStructurePopup.this.myFilteringStructure.rebuild();
            }

            public boolean isToBuildChildrenInBackground(@NotNull Object element) {
                return this.getRootElement() == element;
            }

            @Override
            @NotNull
            protected TreeElementWrapper createTree() {
                return StructureViewComponent.createWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
            }

            @NonNls
            public String toString() {
                return "structure view tree structure(model=" + FileStructurePopup.this.myTreeModelWrapper + ")";
            }
        };
        FileStructurePopupFilter filter = new FileStructurePopupFilter();
        this.myFilteringStructure = new FilteringTreeStructure((ElementFilter)filter, (AbstractTreeStructure)this.myTreeStructure, false);
        this.myStructureTreeModel = new StructureTreeModel<FilteringTreeStructure>(this.myFilteringStructure);
        this.myAsyncTreeModel = new AsyncTreeModel((javax.swing.tree.TreeModel)((Object)this.myStructureTreeModel), this);
        this.myAsyncTreeModel.setRootImmediately(this.myStructureTreeModel.getRootImmediately());
        this.myTree = new MyTree((javax.swing.tree.TreeModel)((Object)this.myAsyncTreeModel));
        StructureViewComponent.registerAutoExpandListener((JTree)this.myTree, this.myTreeModel);
        Disposer.register((Disposable)this, (Disposable)this.myTreeModelWrapper);
        ModelListener modelListener = () -> this.rebuild(false);
        this.myTreeModel.addModelListener(modelListener);
        Disposer.register((Disposable)this, () -> this.myTreeModel.removeModelListener(modelListener));
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myTree.setTransferHandler(new TransferHandler(){

            @Override
            public boolean importData(@NotNull TransferHandler.TransferSupport support) {
                String s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
                if (s != null && !FileStructurePopup.this.mySpeedSearch.isPopupActive()) {
                    FileStructurePopup.this.mySpeedSearch.showPopup(s);
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent component) {
                JBIterable pairs = JBIterable.of((Object[])FileStructurePopup.this.myTree.getSelectionPaths()).filterMap(TreeUtil::getLastUserObject).filter(FilteringTreeStructure.FilteringNode.class).filterMap(o -> o.getDelegate() instanceof PsiElement ? Pair.create((Object)o, (Object)((PsiElement)o.getDelegate())) : null).collect();
                if (pairs.isEmpty()) {
                    return null;
                }
                Set psiSelection = pairs.map(Functions.pairSecond()).toSet();
                String text = StringUtil.join((Iterable)pairs, pair -> {
                    PsiElement psi = (PsiElement)pair.second;
                    String defaultPresentation = ((FilteringTreeStructure.FilteringNode)pair.first).getPresentation().getPresentableText();
                    if (psi == null) {
                        return defaultPresentation;
                    }
                    for (PsiElement p = psi.getParent(); p != null; p = p.getParent()) {
                        if (!psiSelection.contains(p)) continue;
                        return null;
                    }
                    return (String)ObjectUtils.chooseNotNull((Object)psi.getText(), (Object)defaultPresentation);
                }, (String)"\n");
                String htmlText = "<body>\n" + text + "\n</body>";
                return new TextTransferable(XmlStringUtil.wrapInHtml((CharSequence)htmlText), text);
            }

            @Override
            public int getSourceActions(JComponent component) {
                return 1;
            }
        });
        this.mySpeedSearch = new MyTreeSpeedSearch();
        this.mySpeedSearch.setComparator(new SpeedSearchComparator(false, true){

            @Override
            @NotNull
            protected MinusculeMatcher createMatcher(@NotNull String pattern) {
                return NameUtil.buildMatcher((String)pattern).withSeparators(" ()").build();
            }
        });
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, (JComponent)this.myTree);
        this.myInitialElement = this.myTreeModel.getCurrentEditorElement();
        TreeUtil.installActions((JTree)this.myTree);
    }

    public void show() {
        JComponent panel2 = this.createCenterPanel();
        MnemonicHelper.init((Component)panel2);
        this.myTree.addTreeSelectionListener(__ -> {
            PopupUpdateProcessor updateProcessor;
            if (this.myPopup.isVisible() && (updateProcessor = (PopupUpdateProcessor)((Object)((Object)this.myPopup.getUserData(PopupUpdateProcessor.class)))) != null) {
                AbstractTreeNode node = this.getSelectedNode();
                updateProcessor.updatePopup(node);
            }
        });
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(panel2, (JComponent)this.myTree).setTitle(this.myTitle).setResizable(true).setModalContext(false).setFocusable(true).setRequestFocus(true).setMovable(true).setBelongsToGlobalPopupStack(true).setCancelKeyEnabled(false).setDimensionServiceKey(null, FileStructurePopup.getDimensionServiceKey(), true).setCancelCallback(() -> this.myCanClose).createPopup();
        Disposer.register((Disposable)this.myPopup, (Disposable)this);
        Disposer.register((Disposable)this.myPopup, () -> {
            if (!this.myTreeHasBuilt.isDone()) {
                this.myTreeHasBuilt.setRejected();
            }
        });
        this.myTree.getEmptyText().setText("Loading...");
        this.myPopup.showCenteredInCurrentWindow(this.myProject);
        ((AbstractPopup)this.myPopup).setShowHints(true);
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTree, true);
        this.rebuildAndSelect(false, this.myInitialElement).onProcessed(path -> UIUtil.invokeLaterIfNeeded(() -> {
            TreeUtil.ensureSelection((JTree)this.myTree);
            this.myTreeHasBuilt.setDone();
            this.installUpdater();
        }));
    }

    private void installUpdater() {
        if (ApplicationManager.getApplication().isUnitTestMode() || this.myPopup.isDisposed()) {
            return;
        }
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myPopup);
        alarm.addRequest(new Runnable(){
            String filter = "";

            @Override
            public void run() {
                alarm.cancelAllRequests();
                String prefix = FileStructurePopup.this.mySpeedSearch.getEnteredPrefix();
                FileStructurePopup.this.myTree.getEmptyText().setText(StringUtil.isEmpty((String)prefix) ? "Structure is empty" : "'" + prefix + "' not found");
                if (prefix == null) {
                    prefix = "";
                }
                if (!this.filter.equals(prefix)) {
                    boolean isBackspace = prefix.length() < this.filter.length();
                    this.filter = prefix;
                    FileStructurePopup.this.rebuild(true).onProcessed(ignore -> UIUtil.invokeLaterIfNeeded(() -> {
                        if (FileStructurePopup.this.isDisposed()) {
                            return;
                        }
                        TreeUtil.promiseExpandAll((JTree)FileStructurePopup.this.myTree);
                        if (isBackspace && FileStructurePopup.this.handleBackspace(this.filter)) {
                            return;
                        }
                        if (FileStructurePopup.this.myFilteringStructure.getRootElement().getChildren().length == 0) {
                            for (JBCheckBox box : FileStructurePopup.this.myCheckBoxes.values()) {
                                if (box.isSelected()) continue;
                                FileStructurePopup.this.myAutoClicked.add(box);
                                FileStructurePopup.this.myTriggeredCheckboxes.add(0, Pair.create((Object)this.filter, (Object)box));
                                box.doClick();
                                this.filter = "";
                                break;
                            }
                        }
                    }));
                }
                if (!alarm.isDisposed()) {
                    alarm.addRequest((Runnable)this, 300);
                }
            }
        }, 300);
    }

    private boolean handleBackspace(String filter) {
        Pair<String, JBCheckBox> next;
        boolean clicked = false;
        Iterator<Pair<String, JBCheckBox>> iterator = this.myTriggeredCheckboxes.iterator();
        while (iterator.hasNext() && ((String)(next = iterator.next()).getFirst()).length() >= filter.length()) {
            iterator.remove();
            ((JBCheckBox)next.getSecond()).doClick();
            clicked = true;
        }
        return clicked;
    }

    @NotNull
    public Promise<TreePath> select(final Object element) {
        final int[] stage = new int[]{1, 0};
        final TreePath[] deepestPath = new TreePath[]{null};
        final TreeVisitor visitor = path -> {
            Object last = path.getLastPathComponent();
            Object userObject = StructureViewComponent.unwrapNavigatable(last);
            Object value = StructureViewComponent.unwrapValue(last);
            if (Comparing.equal((Object)value, (Object)element) || userObject instanceof AbstractTreeNode && ((AbstractTreeNode)userObject).canRepresent(element)) {
                return TreeVisitor.Action.INTERRUPT;
            }
            if (value instanceof PsiElement && element instanceof PsiElement) {
                if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)value), (PsiElement)((PsiElement)element), (boolean)true)) {
                    int count = path.getPathCount();
                    if (stage[1] == 0 || stage[1] < count) {
                        stage[1] = count;
                        deepestPath[0] = path;
                    }
                } else if (stage[0] != 3) {
                    stage[0] = 2;
                    return TreeVisitor.Action.SKIP_CHILDREN;
                }
            }
            return TreeVisitor.Action.CONTINUE;
        };
        final Function action = path -> {
            this.myTree.expandPath(path);
            TreeUtil.selectPath((JTree)this.myTree, (TreePath)path);
            TreeUtil.ensureSelection((JTree)this.myTree);
            return Promises.resolvedPromise((Object)path);
        };
        Function<TreePath, Promise<TreePath>> fallback = new Function<TreePath, Promise<TreePath>>(){

            public Promise<TreePath> fun(TreePath path) {
                Object minChild;
                TreePath adjusted;
                if (path == null && stage[0] == 2) {
                    stage[0] = 3;
                    return FileStructurePopup.this.myAsyncTreeModel.accept(visitor).thenAsync((Function)this);
                }
                TreePath treePath = adjusted = path == null ? deepestPath[0] : path;
                if (path == null && adjusted != null && element instanceof PsiElement && (minChild = FileStructurePopup.findClosestPsiElement((PsiElement)element, adjusted, (javax.swing.tree.TreeModel)((Object)FileStructurePopup.this.myAsyncTreeModel))) != null) {
                    adjusted = adjusted.pathByAddingChild(minChild);
                }
                return adjusted == null ? Promises.rejectedPromise() : (Promise)action.fun((Object)adjusted);
            }
        };
        return this.myAsyncTreeModel.accept(visitor).thenAsync((Function)fallback);
    }

    public AsyncPromise<Void> rebuildAndUpdate() {
        AsyncPromise result2 = new AsyncPromise();
        TreeVisitor visitor = path -> {
            AbstractTreeNode node = (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)path);
            if (node != null) {
                node.update();
            }
            return TreeVisitor.Action.CONTINUE;
        };
        this.rebuild(false).onProcessed(ignore1 -> this.myAsyncTreeModel.accept(visitor).onProcessed(ignore2 -> result2.setResult(null)));
        return result2;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    private static boolean isShouldNarrowDown() {
        return PropertiesComponent.getInstance().getBoolean(NARROW_DOWN_PROPERTY_KEY, true);
    }

    @NonNls
    protected static String getDimensionServiceKey() {
        return "StructurePopup";
    }

    @Nullable
    public PsiElement getCurrentElement(@Nullable PsiFile psiFile) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        Object elementAtCursor = this.myTreeModelWrapper.getCurrentEditorElement();
        if (elementAtCursor instanceof PsiElement) {
            return (PsiElement)elementAtCursor;
        }
        if (psiFile != null && this.myFileEditor instanceof TextEditor) {
            return psiFile.getViewProvider().findElementAt(((TextEditor)this.myFileEditor).getEditor().getCaretModel().getOffset());
        }
        return null;
    }

    public JComponent createCenterPanel() {
        ArrayList<FileStructureFilter> fileStructureFilters = new ArrayList<FileStructureFilter>();
        ArrayList<FileStructureNodeProvider> fileStructureNodeProviders = new ArrayList<FileStructureNodeProvider>();
        if (this.myTreeActionsOwner != null) {
            for (Filter filter : this.myTreeModel.getFilters()) {
                if (!(filter instanceof FileStructureFilter)) continue;
                FileStructureFilter fsFilter = (FileStructureFilter)filter;
                this.myTreeActionsOwner.setActionIncluded((TreeAction)fsFilter, true);
                fileStructureFilters.add(fsFilter);
            }
            if (this.myTreeModel instanceof ProvidingTreeModel) {
                for (NodeProvider provider : ((ProvidingTreeModel)this.myTreeModel).getNodeProviders()) {
                    if (!(provider instanceof FileStructureNodeProvider)) continue;
                    fileStructureNodeProviders.add((FileStructureNodeProvider)provider);
                }
            }
        }
        int checkBoxCount = fileStructureNodeProviders.size() + fileStructureFilters.size();
        final JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setPreferredSize((Dimension)JBUI.size((int)540, (int)500));
        JPanel chkPanel = new JPanel(new GridLayout(0, checkBoxCount > 0 && checkBoxCount % 4 == 0 ? checkBoxCount / 2 : 3, JBUI.scale((int)10), 0));
        chkPanel.setOpaque(false);
        Object[] F4 = ActionManager.getInstance().getAction("EditSource").getShortcutSet().getShortcuts();
        Object[] ENTER = CustomShortcutSet.fromString((String[])new String[]{"ENTER"}).getShortcuts();
        CustomShortcutSet shortcutSet = new CustomShortcutSet((Shortcut[])ArrayUtil.mergeArrays((Object[])F4, (Object[])ENTER));
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                boolean succeeded = FileStructurePopup.this.navigateSelectedElement();
                if (succeeded) {
                    this.unregisterCustomShortcutSet(panel2);
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)shortcutSet, (JComponent)panel2);
        DumbAwareAction.create(e -> {
            if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive()) {
                this.mySpeedSearch.hidePopup();
            } else {
                this.myPopup.cancel();
            }
        }).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ESCAPE"}), (JComponent)this.myTree);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                Rectangle bounds2;
                TreePath path = FileStructurePopup.this.myTree.getClosestPathForLocation(e.getX(), e.getY());
                Rectangle rectangle = bounds2 = path == null ? null : FileStructurePopup.this.myTree.getPathBounds(path);
                if (bounds2 == null || bounds2.x > e.getX() || bounds2.y > e.getY() || bounds2.y + bounds2.height < e.getY()) {
                    return false;
                }
                FileStructurePopup.this.navigateSelectedElement();
                return true;
            }
        }.installOn((Component)this.myTree);
        for (FileStructureFilter filter : fileStructureFilters) {
            this.addCheckbox(chkPanel, (TreeAction)filter);
        }
        for (FileStructureNodeProvider provider : fileStructureNodeProviders) {
            this.addCheckbox(chkPanel, (TreeAction)provider);
        }
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)chkPanel, "West");
        topPanel.add((Component)this.createSettingsButton(), "East");
        topPanel.setBackground(JBUI.CurrentTheme.Popup.toolbarPanelColor());
        Dimension prefSize = topPanel.getPreferredSize();
        prefSize.height = JBUI.CurrentTheme.Popup.toolbarHeight();
        topPanel.setPreferredSize(prefSize);
        topPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        panel2.add((Component)topPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setBorder(IdeBorderFactory.createBorder((Color)JBUI.CurrentTheme.Popup.toolbarBorderColor(), (int)10));
        panel2.add((Component)scrollPane, "Center");
        DataManager.registerDataProvider((JComponent)panel2, dataId -> {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                return this.myFileEditor;
            }
            if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId) && this.myFileEditor instanceof TextEditor) {
                return ((TextEditor)this.myFileEditor).getEditor();
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return this.getSelectedElements().filter(PsiElement.class).first();
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                return PsiUtilCore.toPsiElementArray((Collection)this.getSelectedElements().filter(PsiElement.class).toList());
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return this.getSelectedElements().filter(Navigatable.class).first();
            }
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                List result2 = this.getSelectedElements().filter(Navigatable.class).toList();
                return result2.isEmpty() ? null : result2.toArray(new Navigatable[0]);
            }
            if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
                return this.myPopup;
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return this.myCopyPasteDelegator.getCopyProvider();
            }
            if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
                return this.myTreeExpander;
            }
            return null;
        });
        panel2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FileStructurePopup.this.myPopup.cancel();
            }
        });
        return panel2;
    }

    @NotNull
    private JBIterable<Object> getSelectedElements() {
        return JBIterable.of((Object[])this.myTree.getSelectionPaths()).filterMap(o -> StructureViewComponent.unwrapValue(o.getLastPathComponent()));
    }

    @NotNull
    private JComponent createSettingsButton() {
        final JLabel label2 = new JLabel(AllIcons.General.GearPlain);
        label2.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        label2.setHorizontalAlignment(4);
        label2.setVerticalAlignment(0);
        final List<AnAction> sorters = this.createSorters();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                DefaultActionGroup group = new DefaultActionGroup();
                if (!sorters.isEmpty()) {
                    group.addAll((Collection)sorters);
                    group.addSeparator();
                }
                group.add((AnAction)new ToggleAction(IdeBundle.message((String)"checkbox.narrow.down.on.typing", (Object[])new Object[0])){

                    public boolean isSelected(@NotNull AnActionEvent e) {
                        return FileStructurePopup.isShouldNarrowDown();
                    }

                    public void setSelected(@NotNull AnActionEvent e, boolean state) {
                        PropertiesComponent.getInstance().setValue(FileStructurePopup.NARROW_DOWN_PROPERTY_KEY, Boolean.toString(state));
                        if (FileStructurePopup.this.mySpeedSearch.isPopupActive() && !StringUtil.isEmpty((String)FileStructurePopup.this.mySpeedSearch.getEnteredPrefix())) {
                            FileStructurePopup.this.rebuild(true);
                        }
                    }
                });
                DataManager dataManager = DataManager.getInstance();
                ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataManager.getDataContext((Component)label2), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
                popup2.addListener(new JBPopupListener(){

                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        FileStructurePopup.this.myCanClose = true;
                    }
                });
                FileStructurePopup.this.myCanClose = false;
                popup2.showUnderneathOf((Component)label2);
                return true;
            }
        }.installOn((Component)label2);
        return label2;
    }

    private List<AnAction> createSorters() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        for (Sorter sorter : this.myTreeModel.getSorters()) {
            if (!sorter.isVisible()) continue;
            actions.add((AnAction)new MyTreeActionWrapper((TreeAction)sorter));
        }
        return actions;
    }

    @Nullable
    private static Object findClosestPsiElement(@NotNull PsiElement element, @NotNull TreePath adjusted, @NotNull javax.swing.tree.TreeModel treeModel) {
        TextRange range2 = element.getTextRange();
        if (range2 == null) {
            return null;
        }
        Object parent = adjusted.getLastPathComponent();
        int minDistance = 0;
        Object minChild = null;
        int count = treeModel.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            TextRange r;
            Object child2 = treeModel.getChild(parent, i);
            Object value = StructureViewComponent.unwrapValue(child2);
            if (value instanceof StubBasedPsiElement && ((StubBasedPsiElement)value).getStub() != null) continue;
            TextRange textRange = r = value instanceof PsiElement ? ((PsiElement)value).getTextRange() : null;
            if (r == null) continue;
            int distance2 = TextRangeUtil.getDistance((Segment)range2, (Segment)r);
            if (minChild != null && distance2 >= minDistance) continue;
            minDistance = distance2;
            minChild = child2;
        }
        return minChild;
    }

    @Nullable
    private AbstractTreeNode getSelectedNode() {
        TreePath path = this.myTree.getSelectionPath();
        Object o = StructureViewComponent.unwrapNavigatable(path == null ? null : path.getLastPathComponent());
        return o instanceof AbstractTreeNode ? (AbstractTreeNode)o : null;
    }

    private boolean navigateSelectedElement() {
        AbstractTreeNode selectedNode = this.getSelectedNode();
        if (ApplicationManager.getApplication().isInternal()) {
            String enteredPrefix = this.mySpeedSearch.getEnteredPrefix();
            String itemText = FileStructurePopup.getSpeedSearchText(selectedNode);
            if (StringUtil.isNotEmpty((String)enteredPrefix) && StringUtil.isNotEmpty((String)itemText)) {
                LOG.info("Chosen in file structure popup by prefix '" + enteredPrefix + "': '" + itemText + "'");
            }
        }
        Ref succeeded = new Ref();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            if (selectedNode != null) {
                if (selectedNode.canNavigateToSource()) {
                    selectedNode.navigate(true);
                    this.myPopup.cancel();
                    succeeded.set((Object)true);
                } else {
                    succeeded.set((Object)false);
                }
            } else {
                succeeded.set((Object)false);
            }
            IdeDocumentHistory.getInstance(this.myProject).includeCurrentCommandAsNavigation();
        }, "Navigate", null);
        return (Boolean)succeeded.get();
    }

    private void addCheckbox(JPanel panel2, TreeAction action) {
        String text;
        String string = action instanceof FileStructureFilter ? ((FileStructureFilter)action).getCheckBoxText() : (text = action instanceof FileStructureNodeProvider ? ((FileStructureNodeProvider)action).getCheckBoxText() : null);
        if (text == null) {
            return;
        }
        Shortcut[] shortcuts = FileStructurePopup.extractShortcutFor(action);
        JBCheckBox checkBox2 = new JBCheckBox();
        checkBox2.setOpaque(false);
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)checkBox2);
        boolean selected = FileStructurePopup.getDefaultValue(action);
        checkBox2.setSelected(selected);
        boolean isRevertedStructureFilter = action instanceof FileStructureFilter && ((FileStructureFilter)action).isReverted();
        this.myTreeActionsOwner.setActionIncluded(action, isRevertedStructureFilter != selected);
        checkBox2.addActionListener(__ -> {
            boolean state = checkBox2.isSelected();
            if (!this.myAutoClicked.contains(checkBox2)) {
                FileStructurePopup.saveState(action, state);
            }
            this.myTreeActionsOwner.setActionIncluded(action, isRevertedStructureFilter != state);
            this.rebuild(false).onProcessed(ignore -> {
                if (this.mySpeedSearch.isPopupActive()) {
                    this.mySpeedSearch.refreshSelection();
                }
            });
        });
        checkBox2.setFocusable(false);
        if (shortcuts.length > 0) {
            text = text + " (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ")";
            DumbAwareAction.create(e -> checkBox2.doClick()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)this.myTree);
        }
        checkBox2.setText(StringUtil.capitalize((String)StringUtil.trimStart((String)text.trim(), (String)"Show ")));
        panel2.add((Component)checkBox2);
        this.myCheckBoxes.put(action.getClass(), checkBox2);
    }

    @NotNull
    private Promise<Void> rebuild(boolean refilterOnly) {
        Object selection = JBIterable.of((Object[])this.myTree.getSelectionPaths()).filterMap(o -> StructureViewComponent.unwrapValue(o.getLastPathComponent())).first();
        return this.rebuildAndSelect(refilterOnly, selection).then(o -> null);
    }

    @NotNull
    private Promise<TreePath> rebuildAndSelect(boolean refilterOnly, Object selection) {
        AsyncPromise result2 = new AsyncPromise();
        this.myStructureTreeModel.getInvoker().runOrInvokeLater(() -> {
            if (refilterOnly) {
                this.myFilteringStructure.refilter();
                this.myStructureTreeModel.invalidate().onSuccess(res2 -> (selection == null ? this.myAsyncTreeModel.accept(o -> TreeVisitor.Action.CONTINUE) : this.select(selection)).onError(ignore2 -> result2.setError("rejected")).onSuccess(p -> UIUtil.invokeLaterIfNeeded(() -> {
                    TreeUtil.expand((JTree)this.getTree(), (int)(this.myTreeModel instanceof StructureViewCompositeModel ? 3 : 2));
                    TreeUtil.ensureSelection((JTree)this.myTree);
                    this.mySpeedSearch.refreshSelection();
                    result2.setResult(p);
                })));
            } else {
                this.myTreeStructure.rebuildTree();
                this.myStructureTreeModel.invalidate().onSuccess(res2 -> this.rebuildAndSelect(true, selection).processed((Promise)result2));
            }
        });
        return result2;
    }

    @NotNull
    static Shortcut[] extractShortcutFor(@NotNull TreeAction action) {
        if (action instanceof ActionShortcutProvider) {
            String actionId = ((ActionShortcutProvider)action).getActionIdForShortcut();
            return KeymapUtil.getActiveKeymapShortcuts((String)actionId).getShortcuts();
        }
        return action instanceof FileStructureFilter ? ((FileStructureFilter)action).getShortcut() : ((FileStructureNodeProvider)action).getShortcut();
    }

    private static boolean getDefaultValue(TreeAction action) {
        String propertyName = action instanceof PropertyOwner ? ((PropertyOwner)action).getPropertyName() : action.getName();
        return PropertiesComponent.getInstance().getBoolean(TreeStructureUtil.getPropertyName(propertyName), Sorter.ALPHA_SORTER.equals(action));
    }

    private static void saveState(TreeAction action, boolean state) {
        String propertyName = action instanceof PropertyOwner ? ((PropertyOwner)action).getPropertyName() : action.getName();
        PropertiesComponent.getInstance().setValue(TreeStructureUtil.getPropertyName(propertyName), state, Sorter.ALPHA_SORTER.equals(action));
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    @NotNull
    public Tree getTree() {
        return this.myTree;
    }

    public TreeSpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    public void setSearchFilterForTests(String filter) {
        this.myTestSearchFilter = filter;
    }

    public void setTreeActionState(Class<? extends TreeAction> action, boolean state) {
        JBCheckBox checkBox2 = this.myCheckBoxes.get(action);
        if (checkBox2 != null) {
            checkBox2.setSelected(state);
            for (ActionListener listener2 : checkBox2.getActionListeners()) {
                listener2.actionPerformed(new ActionEvent(this, 1, ""));
            }
        }
    }

    @Nullable
    public static String getSpeedSearchText(Object object) {
        String text = String.valueOf(object);
        Object value = StructureViewComponent.unwrapWrapper(object);
        if (text != null) {
            String locationString;
            if (value instanceof PsiTreeElementBase && ((PsiTreeElementBase)value).isSearchInLocationString() && !StringUtil.isEmpty((String)(locationString = ((PsiTreeElementBase)value).getLocationString()))) {
                String locationPrefix = null;
                String locationSuffix = null;
                if (value instanceof LocationPresentation) {
                    locationPrefix = ((LocationPresentation)value).getLocationPrefix();
                    locationSuffix = ((LocationPresentation)value).getLocationSuffix();
                }
                return text + StringUtil.notNullize((String)locationPrefix, (String)" (") + locationString + StringUtil.notNullize((String)locationSuffix, (String)")");
            }
            return text;
        }
        if (value instanceof TreeElement) {
            return (String)ReadAction.compute(() -> ((TreeElement)value).getPresentation().getPresentableText());
        }
        return null;
    }

    @Override
    public void setActionActive(String name, boolean state) {
    }

    @Override
    public boolean isActionActive(String name) {
        return false;
    }

    @Nullable
    private String getSearchPrefix() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myTestSearchFilter;
        }
        return this.mySpeedSearch != null && !StringUtil.isEmpty((String)this.mySpeedSearch.getEnteredPrefix()) ? this.mySpeedSearch.getEnteredPrefix() : null;
    }

    @Nullable
    private static SpeedSearchObjectWithWeight find(@NotNull PsiElement element, @NotNull List<SpeedSearchObjectWithWeight> objects, @NotNull BiPredicate<PsiElement, TreePath> predicate) {
        return (SpeedSearchObjectWithWeight)ContainerUtil.find(objects, object -> predicate.test(element, (TreePath)ObjectUtils.tryCast((Object)object.node, TreePath.class)));
    }

    private static boolean isElement(@NotNull PsiElement element, @Nullable TreePath path) {
        return element.equals(StructureViewComponent.unwrapValue(TreeUtil.getLastUserObject(FilteringTreeStructure.FilteringNode.class, (TreePath)path)));
    }

    private static boolean isParent(@NotNull PsiElement parent, @Nullable TreePath path) {
        return path != null && FileStructurePopup.isElement(parent, path.getParentPath());
    }

    private static boolean isAncestor(@NotNull PsiElement ancestor, @Nullable TreePath path) {
        while (path != null) {
            if (FileStructurePopup.isElement(ancestor, path)) {
                return true;
            }
            path = path.getParentPath();
        }
        return false;
    }

    static class MyTree
    extends DnDAwareTree
    implements PlaceProvider<String> {
        MyTree(javax.swing.tree.TreeModel treeModel) {
            super(treeModel);
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            HintUpdateSupply.installHintUpdateSupply((JComponent)((Object)this), o -> {
                Object value = StructureViewComponent.unwrapValue(o);
                return value instanceof PsiElement ? (PsiElement)value : null;
            });
        }

        public String getPlace() {
            return "StructureViewPopup";
        }
    }

    private class MyTreeSpeedSearch
    extends TreeSpeedSearch {
        MyTreeSpeedSearch() {
            super(FileStructurePopup.this.myTree, (Convertor<? super TreePath, String>)((Convertor)path -> FileStructurePopup.getSpeedSearchText(TreeUtil.getLastUserObject((TreePath)path))), true);
        }

        @Override
        protected Point getComponentLocationOnScreen() {
            return FileStructurePopup.this.myPopup.getContent().getLocationOnScreen();
        }

        @Override
        protected Rectangle getComponentVisibleRect() {
            return FileStructurePopup.this.myPopup.getContent().getVisibleRect();
        }

        @Override
        public Object findElement(String s) {
            List<SpeedSearchObjectWithWeight> elements = SpeedSearchObjectWithWeight.findElement(s, this);
            SpeedSearchObjectWithWeight best = (SpeedSearchObjectWithWeight)ContainerUtil.getFirstItem(elements);
            if (best == null) {
                return null;
            }
            if (FileStructurePopup.this.myInitialElement instanceof PsiElement) {
                SpeedSearchObjectWithWeight bestSibling;
                PsiElement initial = (PsiElement)FileStructurePopup.this.myInitialElement;
                SpeedSearchObjectWithWeight bestForParent = FileStructurePopup.find(initial, elements, (x$0, x$1) -> FileStructurePopup.isParent(x$0, x$1));
                if (bestForParent != null) {
                    return bestForParent.node;
                }
                PsiElement parent = initial.getParent();
                if (parent != null && (bestSibling = FileStructurePopup.find(parent, elements, (x$0, x$1) -> FileStructurePopup.isParent(x$0, x$1))) != null) {
                    return bestSibling.node;
                }
                SpeedSearchObjectWithWeight bestForAncestor = FileStructurePopup.find(initial, elements, (x$0, x$1) -> FileStructurePopup.isAncestor(x$0, x$1));
                if (bestForAncestor != null) {
                    return bestForAncestor.node;
                }
            }
            return best.node;
        }
    }

    private class FileStructurePopupFilter
    implements ElementFilter {
        private String myLastFilter;
        private final Set<Object> myVisibleParents = new HashSet<Object>();
        private final boolean isUnitTest = ApplicationManager.getApplication().isUnitTestMode();

        private FileStructurePopupFilter() {
        }

        public boolean shouldBeShowing(Object value) {
            if (!FileStructurePopup.isShouldNarrowDown()) {
                return true;
            }
            String filter = FileStructurePopup.this.getSearchPrefix();
            if (!StringUtil.equals((CharSequence)this.myLastFilter, (CharSequence)filter)) {
                this.myVisibleParents.clear();
                this.myLastFilter = filter;
            }
            if (filter != null) {
                if (this.myVisibleParents.contains(value)) {
                    return true;
                }
                String text = FileStructurePopup.getSpeedSearchText(value);
                if (text == null) {
                    return false;
                }
                if (this.matches(filter, text)) {
                    Object o = value;
                    while (o instanceof FilteringTreeStructure.FilteringNode && (o = ((FilteringTreeStructure.FilteringNode)o).getParent()) != null) {
                        this.myVisibleParents.add(o);
                    }
                    return true;
                }
                return false;
            }
            return true;
        }

        private boolean matches(@NotNull String filter, @NotNull String text) {
            return (this.isUnitTest || FileStructurePopup.this.mySpeedSearch.isPopupActive()) && StringUtil.isNotEmpty((String)filter) && FileStructurePopup.this.mySpeedSearch.getComparator().matchingFragments(filter, text) != null;
        }
    }

    private class MyTreeActionWrapper
    extends TreeActionWrapper {
        private final TreeAction myAction;

        MyTreeActionWrapper(TreeAction action) {
            super(action, FileStructurePopup.this.myTreeActionsOwner);
            this.myAction = action;
            FileStructurePopup.this.myTreeActionsOwner.setActionIncluded(action, FileStructurePopup.getDefaultValue(action));
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setIcon(null);
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            boolean actionState = TreeModelWrapper.shouldRevert(this.myAction) != state;
            FileStructurePopup.this.myTreeActionsOwner.setActionIncluded(this.myAction, actionState);
            FileStructurePopup.saveState(this.myAction, state);
            FileStructurePopup.this.rebuild(false).onProcessed(ignore -> {
                if (FileStructurePopup.this.mySpeedSearch.isPopupActive()) {
                    FileStructurePopup.this.mySpeedSearch.refreshSelection();
                }
            });
        }
    }
}

