/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class NavigationItemListCellRenderer
extends OpaquePanel
implements ListCellRenderer {
    public NavigationItemListCellRenderer() {
        super((LayoutManager)new BorderLayout());
    }

    public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        boolean hasRightRenderer = UISettings.getInstance().getShowIconInQuickNavigation();
        ModuleRendererFactory factory = ModuleRendererFactory.findInstance(value);
        LeftRenderer left = new LeftRenderer(!hasRightRenderer || !factory.rendersLocationString(), MatcherHolder.getAssociatedMatcher(list2));
        Component leftCellRendererComponent = left.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
        Color listBg = leftCellRendererComponent.getBackground();
        this.add(leftCellRendererComponent, "West");
        this.setBackground(isSelected ? UIUtil.getListSelectionBackground() : listBg);
        if (hasRightRenderer) {
            DefaultListCellRenderer moduleRenderer = factory.getModuleRenderer();
            Component rightCellRendererComponent = moduleRenderer.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
            ((JComponent)rightCellRendererComponent).setOpaque(false);
            rightCellRendererComponent.setBackground(listBg);
            this.add(rightCellRendererComponent, "East");
            NonOpaquePanel spacer = new NonOpaquePanel();
            Dimension size = rightCellRendererComponent.getSize();
            spacer.setSize(new Dimension((int)((double)size.width * 0.015 + (double)leftCellRendererComponent.getSize().width * 0.015), size.height));
            spacer.setBackground(isSelected ? UIUtil.getListSelectionBackground() : listBg);
            this.add((Component)spacer, "Center");
        }
        return this;
    }

    static PsiElement getPsiElement(Object o) {
        return o instanceof PsiElement ? (PsiElement)o : (o instanceof PsiElementNavigationItem ? ((PsiElementNavigationItem)o).getTargetElement() : null);
    }

    private static class LeftRenderer
    extends ColoredListCellRenderer {
        public final boolean myRenderLocation;
        private final Matcher myMatcher;

        LeftRenderer(boolean renderLocation, Matcher matcher) {
            this.myRenderLocation = renderLocation;
            this.myMatcher = matcher;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
            Color bgColor = UIUtil.getListBackground();
            if (value instanceof PsiElement && !((PsiElement)value).isValid()) {
                this.setIcon(IconUtil.getEmptyIcon((boolean)false));
                this.append("Invalid", SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else if (value instanceof NavigationItem) {
                String containerText;
                FileStatus status;
                NavigationItem item = (NavigationItem)value;
                ItemPresentation presentation = item.getPresentation();
                assert (presentation != null) : "PSI elements displayed in choose by name lists must return a non-null value from getPresentation(): element " + item.toString() + ", class " + item.getClass().getName();
                String name = presentation.getPresentableText();
                assert (name != null) : "PSI elements displayed in choose by name lists must return a non-null value from getPresentation().getPresentableName: element " + item.toString() + ", class " + item.getClass().getName();
                Color color = list2.getForeground();
                boolean isProblemFile = item instanceof PsiElement && WolfTheProblemSolver.getInstance((Project)((PsiElement)item).getProject()).isProblemFile(PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)item)));
                PsiElement psiElement = NavigationItemListCellRenderer.getPsiElement(item);
                if (psiElement != null && psiElement.isValid()) {
                    Color fileColor;
                    Project project = psiElement.getProject();
                    VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
                    isProblemFile = WolfTheProblemSolver.getInstance((Project)project).isProblemFile(virtualFile);
                    Color color2 = fileColor = virtualFile == null ? null : VfsPresentationUtil.getFileBackgroundColor(project, virtualFile);
                    if (fileColor != null) {
                        bgColor = fileColor;
                    }
                }
                if ((status = NavigationItemFileStatus.get((NavigationItem)item)) != FileStatus.NOT_CHANGED) {
                    color = status.getColor();
                }
                TextAttributes textAttributes = NodeRenderer.getSimpleTextAttributes((ItemPresentation)presentation).toTextAttributes();
                if (isProblemFile) {
                    textAttributes.setEffectType(EffectType.WAVE_UNDERSCORE);
                    textAttributes.setEffectColor((Color)JBColor.red);
                }
                textAttributes.setForegroundColor(color);
                SimpleTextAttributes nameAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)name, (SimpleColoredComponent)this, (SimpleTextAttributes)nameAttributes, (Matcher)this.myMatcher, (Color)bgColor, (boolean)selected);
                this.setIcon(presentation.getIcon(false));
                if (this.myRenderLocation && (containerText = presentation.getLocationString()) != null && containerText.length() > 0) {
                    this.append(" " + containerText, new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                }
            } else {
                this.setIcon(IconUtil.getEmptyIcon((boolean)false));
                this.append(value == null ? "" : value.toString(), new SimpleTextAttributes(0, list2.getForeground()));
            }
            this.setPaintFocusBorder(false);
            this.setBackground(selected ? UIUtil.getListSelectionBackground() : bgColor);
        }
    }
}

