/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesComponentImpl
extends PropertiesComponent
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(PropertiesComponentImpl.class);
    private final Map<String, String> myMap = ContainerUtil.newConcurrentMap();
    @NonNls
    private static final String ELEMENT_PROPERTY = "property";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";

    PropertiesComponentImpl() {
    }

    private void doPut(@NotNull String key, @NotNull String value) {
        String reason = Verifier.checkCharacterData((String)key);
        if (reason != null) {
            LOG.error(reason);
        }
        this.myMap.put(key, value);
        this.incModificationCount();
    }

    public Element getState() {
        Element parentNode = new Element("state");
        ArrayList<String> keys = new ArrayList<String>(this.myMap.keySet());
        keys.sort(null);
        for (String key : keys) {
            String value = this.myMap.get(key);
            if (value == null) continue;
            Element element = new Element(ELEMENT_PROPERTY);
            element.setAttribute(ATTRIBUTE_NAME, key);
            element.setAttribute(ATTRIBUTE_VALUE, value);
            parentNode.addContent(element);
        }
        return parentNode;
    }

    public void loadState(@NotNull Element parentNode) {
        this.myMap.clear();
        for (Element e : parentNode.getChildren(ELEMENT_PROPERTY)) {
            String name = e.getAttributeValue(ATTRIBUTE_NAME);
            if (name == null) continue;
            this.myMap.put(name, e.getAttributeValue(ATTRIBUTE_VALUE));
        }
    }

    public String getValue(@NotNull String name) {
        return this.myMap.get(name);
    }

    public void setValue(@NotNull String name, @Nullable String value) {
        if (value == null) {
            this.unsetValue(name);
        } else {
            this.doPut(name, value);
        }
    }

    public void setValue(@NotNull String name, @Nullable String value, @Nullable String defaultValue) {
        if (value == null || value.equals(defaultValue)) {
            this.unsetValue(name);
        } else {
            this.doPut(name, value);
        }
    }

    public void setValue(@NotNull String name, float value, float defaultValue) {
        if (value == defaultValue) {
            this.unsetValue(name);
        } else {
            this.doPut(name, String.valueOf(value));
        }
    }

    public void setValue(@NotNull String name, int value, int defaultValue) {
        if (value == defaultValue) {
            this.unsetValue(name);
        } else {
            this.doPut(name, String.valueOf(value));
        }
    }

    public void setValue(@NotNull String name, boolean value, boolean defaultValue) {
        if (value == defaultValue) {
            this.unsetValue(name);
        } else {
            this.setValue(name, String.valueOf(value));
        }
    }

    public void unsetValue(@NotNull String name) {
        this.myMap.remove(name);
        this.incModificationCount();
    }

    public boolean isValueSet(@NotNull String name) {
        return this.myMap.containsKey(name);
    }

    @Nullable
    public String[] getValues(@NotNull @NonNls String name) {
        String value = this.getValue(name);
        return value != null ? value.split("\n") : null;
    }

    public void setValues(@NotNull @NonNls String name, String[] values) {
        if (values == null) {
            this.setValue(name, null);
        } else {
            this.setValue(name, StringUtil.join((String[])values, (String)"\n"));
        }
    }
}

