/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureViewCompositeModel
extends StructureViewModelBase
implements Disposable,
StructureViewModel.ElementInfoProvider,
StructureViewModel.ExpandInfoProvider {
    private final List<? extends StructureViewComposite.StructureViewDescriptor> myViews;

    public StructureViewCompositeModel(@NotNull PsiFile file2, @Nullable Editor editor, @NotNull List<? extends StructureViewComposite.StructureViewDescriptor> views) {
        super(file2, editor, StructureViewCompositeModel.createRootNode(file2, views));
        this.myViews = views;
    }

    @NotNull
    private JBIterable<StructureViewModel> getModels() {
        return JBIterable.from(this.myViews).map(o -> o.structureModel);
    }

    public Object getCurrentEditorElement() {
        return this.getModels().filterMap(o -> o.getCurrentEditorElement()).first();
    }

    @NotNull
    private static StructureViewTreeElement createRootNode(final @NotNull PsiFile file2, @NotNull List<? extends StructureViewComposite.StructureViewDescriptor> views) {
        final JBIterable children2 = JBIterable.from(views).map(o -> StructureViewCompositeModel.createTreeElementFromView(file2, o));
        return new StructureViewTreeElement(){

            public Object getValue() {
                return file2;
            }

            public void navigate(boolean requestFocus) {
                file2.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return file2.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file2.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                return file2.getPresentation();
            }

            @NotNull
            public TreeElement[] getChildren() {
                List elements = children2.toList();
                return elements.toArray(TreeElement.EMPTY_ARRAY);
            }
        };
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        return this.getModels().filter(ProvidingTreeModel.class).flatMap(ProvidingTreeModel::getNodeProviders).toSet();
    }

    @NotNull
    public Filter[] getFilters() {
        Set filters = this.getModels().flatMap(o -> JBIterable.of((Object[])o.getFilters())).toSet();
        return filters.toArray(Filter.EMPTY_ARRAY);
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        for (StructureViewModel.ElementInfoProvider p : this.getModels().filter(StructureViewModel.ElementInfoProvider.class)) {
            if (!p.isAlwaysShowsPlus(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        for (StructureViewModel.ElementInfoProvider p : this.getModels().filter(StructureViewModel.ElementInfoProvider.class)) {
            if (!p.isAlwaysLeaf(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoExpand(@NotNull StructureViewTreeElement element) {
        if (element.getValue() instanceof StructureViewComposite.StructureViewDescriptor) {
            return true;
        }
        for (StructureViewModel.ExpandInfoProvider p : this.getModels().filter(StructureViewModel.ExpandInfoProvider.class)) {
            if (!p.isAutoExpand(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSmartExpand() {
        boolean result2 = false;
        for (StructureViewModel.ExpandInfoProvider p : this.getModels().filter(StructureViewModel.ExpandInfoProvider.class)) {
            if (!p.isSmartExpand()) {
                return false;
            }
            result2 = true;
        }
        return result2;
    }

    @NotNull
    private static TreeElement createTreeElementFromView(final PsiFile file2, final StructureViewComposite.StructureViewDescriptor view) {
        return new StructureViewTreeElement(){

            public Object getValue() {
                return view;
            }

            public void navigate(boolean requestFocus) {
                file2.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return file2.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file2.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                return new ItemPresentation(){

                    @Nullable
                    public String getPresentableText() {
                        return view.title;
                    }

                    @Nullable
                    public String getLocationString() {
                        return null;
                    }

                    @Nullable
                    public Icon getIcon(boolean unused) {
                        return view.icon;
                    }
                };
            }

            @NotNull
            public TreeElement[] getChildren() {
                return view.structureModel.getRoot().getChildren();
            }
        };
    }
}

