/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TipsOfTheDayUsagesCollector;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipDialog
extends DialogWrapper {
    private static TipDialog ourInstance;
    private TipPanel myTipPanel;

    @Nullable
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public TipDialog() {
        super((Component)WindowManagerEx.getInstanceEx().findVisibleFrame(), true);
        this.initialize();
    }

    public TipDialog(@NotNull Window parent) {
        super((Component)parent, true);
        this.initialize();
    }

    private void initialize() {
        this.setModal(false);
        this.setTitle(IdeBundle.message((String)"title.tip.of.the.day", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.myTipPanel = new TipPanel();
        this.myTipPanel.setTips(ContainerUtil.newArrayList((Iterable)TipAndTrickBean.EP_NAME.getExtensionList()));
        this.myTipPanel.nextTip();
        this.setDoNotAskOption(this.myTipPanel);
        this.setHorizontalStretch(1.33f);
        this.setVerticalStretch(1.25f);
        this.init();
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    protected JComponent createSouthPanel() {
        JComponent component = super.createSouthPanel();
        component.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        return component;
    }

    @NotNull
    protected Action[] createActions() {
        if (ApplicationManager.getApplication().isInternal()) {
            return new Action[]{new OpenTipsAction(), new PreviousTipAction(), new NextTipAction(), this.getCancelAction()};
        }
        return new Action[]{new PreviousTipAction(), new NextTipAction(), this.getCancelAction()};
    }

    protected JComponent createCenterPanel() {
        return this.myTipPanel;
    }

    public void dispose() {
        super.dispose();
    }

    public static void showForProject(@Nullable Project project) {
        TipDialog.createForProject(project);
        ourInstance.show();
    }

    @Deprecated
    public static TipDialog createForProject(@Nullable Project project) {
        Window w = WindowManagerEx.getInstanceEx().suggestParentWindow(project);
        if (ourInstance != null && ourInstance.isVisible()) {
            ourInstance.dispose();
        }
        ourInstance = w == null ? new TipDialog() : new TipDialog(w);
        return ourInstance;
    }

    public static void hideForProject(@Nullable Project project) {
        if (ourInstance != null) {
            ourInstance.dispose();
            ourInstance = null;
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocusedComponent;
    }

    private class NextTipAction
    extends AbstractAction {
        NextTipAction() {
            super(IdeBundle.message((String)"action.next.tip", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
            this.putValue("FocusedAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipsOfTheDayUsagesCollector.trigger("next.tip");
            TipDialog.this.myTipPanel.nextTip();
        }
    }

    private class PreviousTipAction
    extends AbstractAction {
        PreviousTipAction() {
            super(IdeBundle.message((String)"action.previous.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipsOfTheDayUsagesCollector.trigger("previous.tip");
            TipDialog.this.myTipPanel.prevTip();
        }
    }

    private class OpenTipsAction
    extends AbstractAction {
        private static final String LAST_OPENED_TIP_PATH = "last.opened.tip.path";

        OpenTipsAction() {
            super(IdeBundle.message((String)"action.open.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualFile[] virtualFileArray;
            VirtualFile lastOpenedTip;
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, true).withFileFilter(file2 -> Comparing.equal((String)file2.getExtension(), (String)"html", (boolean)SystemInfo.isFileSystemCaseSensitive));
            String value = propertiesComponent.getValue(LAST_OPENED_TIP_PATH);
            VirtualFile virtualFile = lastOpenedTip = value != null ? LocalFileSystem.getInstance().findFileByPath(value) : null;
            if (lastOpenedTip != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = lastOpenedTip;
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            VirtualFile[] pathToSelect = virtualFileArray;
            VirtualFile[] choose = FileChooserFactory.getInstance().createFileChooser(descriptor, null, (Component)TipDialog.this.myTipPanel).choose(null, pathToSelect);
            if (choose.length > 0) {
                ArrayList tips = ContainerUtil.newArrayList();
                for (VirtualFile file3 : choose) {
                    TipAndTrickBean tip = new TipAndTrickBean();
                    tip.fileName = file3.getPath();
                    tip.featureId = null;
                    tips.add(tip);
                    propertiesComponent.setValue(LAST_OPENED_TIP_PATH, file3.getPath());
                }
                TipDialog.this.myTipPanel.setTips(tips);
                TipDialog.this.myTipPanel.nextTip();
            }
        }
    }
}

