/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.io.IOUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipUIUtil {
    private static final Logger LOG = Logger.getInstance(TipUIUtil.class);
    private static final String SHORTCUT_ENTITY = "&shortcut:";

    private TipUIUtil() {
    }

    @NotNull
    public static String getPoweredByText(@NotNull TipAndTrickBean tip) {
        PluginDescriptor descriptor = tip.getPluginDescriptor();
        return descriptor instanceof IdeaPluginDescriptor && !"com.intellij".equals(descriptor.getPluginId().getIdString()) ? ((IdeaPluginDescriptor)descriptor).getName() : "";
    }

    @Nullable
    public static TipAndTrickBean getTip(String tipFileName) {
        TipAndTrickBean tip = TipAndTrickBean.findByFileName(tipFileName);
        if (tip == null && StringUtil.isNotEmpty((String)tipFileName)) {
            tip = new TipAndTrickBean();
            tip.fileName = tipFileName;
        }
        return tip;
    }

    @Deprecated
    public static void openTipInBrowser(@Nullable TipAndTrickBean tip, JEditorPane browser2) {
        browser2.setText(TipUIUtil.getTipText(tip, browser2));
    }

    private static String getTipText(@Nullable TipAndTrickBean tip, Component component) {
        if (tip == null) {
            return "";
        }
        try {
            String cssText;
            StringBuilder text = new StringBuilder();
            File tipFile = new File(tip.fileName);
            if (tipFile.isAbsolute() && tipFile.exists()) {
                text.append(FileUtil.loadFile((File)tipFile));
                TipUIUtil.updateImages(text, null, tipFile.getParentFile().getAbsolutePath(), component);
                cssText = FileUtil.loadFile((File)new File(tipFile.getParentFile(), UIUtil.isUnderDarcula() ? "css/tips_darcula.css" : "css/tips.css"));
            } else {
                PluginDescriptor pluginDescriptor = tip.getPluginDescriptor();
                ClassLoader tipLoader = pluginDescriptor == null ? TipUIUtil.class.getClassLoader() : (ClassLoader)ObjectUtils.notNull((Object)pluginDescriptor.getPluginClassLoader(), (Object)TipUIUtil.class.getClassLoader());
                URL url = ResourceUtil.getResource((ClassLoader)tipLoader, (String)"/tips/", (String)tip.fileName);
                if (url == null) {
                    return TipUIUtil.getCantReadText(tip);
                }
                text.append(ResourceUtil.loadText((URL)url));
                TipUIUtil.updateImages(text, tipLoader, "", component);
                URL cssResource = ResourceUtil.getResource((ClassLoader)tipLoader, (String)"/tips/", (String)(UIUtil.isUnderDarcula() ? "css/tips_darcula.css" : "css/tips.css"));
                cssText = cssResource != null ? new String(TipUIUtil.readBytes(cssResource), StandardCharsets.UTF_8) : "";
            }
            TipUIUtil.updateShortcuts(text);
            String replaced = text.toString().replace("&productName;", ApplicationNamesInfo.getInstance().getFullProductName());
            String major = ApplicationInfo.getInstance().getMajorVersion();
            replaced = replaced.replace("&majorVersion;", major);
            String minor = ApplicationInfo.getInstance().getMinorVersion();
            replaced = replaced.replace("&minorVersion;", minor);
            replaced = replaced.replace("&majorMinorVersion;", major + ("0".equals(minor) ? "" : "." + minor));
            replaced = replaced.replace("&settingsPath;", CommonBundle.settingsActionPath());
            String inlinedCSS = cssText + "\nbody {background-color:#" + ColorUtil.toHex((Color)UIUtil.getTextFieldBackground()) + ";overflow:hidden;}";
            replaced = replaced.replaceFirst("<link.*\\.css\">", "<style type=\"text/css\">\n" + inlinedCSS + "\n</style>");
            return replaced;
        }
        catch (IOException e) {
            return TipUIUtil.getCantReadText(tip);
        }
    }

    public static void openTipInBrowser(@Nullable TipAndTrickBean tip, Browser browser2) {
        browser2.setText(TipUIUtil.getTipText(tip, browser2.getComponent()));
    }

    private static String getCantReadText(TipAndTrickBean bean) {
        String plugin = TipUIUtil.getPoweredByText(bean);
        String product = ApplicationNamesInfo.getInstance().getFullProductName();
        if (!plugin.isEmpty()) {
            product = product + " and " + plugin + " plugin";
        }
        return IdeBundle.message((String)"error.unable.to.read.tip.of.the.day", (Object[])new Object[]{bean.fileName, product});
    }

    private static void updateImages(StringBuilder text, ClassLoader tipLoader, String tipPath, Component component) {
        boolean dark = UIUtil.isUnderDarcula();
        int index = text.indexOf("<img", 0);
        while (index != -1) {
            int end = text.indexOf(">", index + 1);
            if (end == -1) {
                return;
            }
            String img = text.substring(index, end + 1).replace('\r', ' ').replace('\n', ' ');
            int srcIndex = img.indexOf("src=\"");
            int endIndex = img.indexOf("\"", srcIndex + 6);
            if (srcIndex == -1 && endIndex == -1) {
                srcIndex = img.indexOf("src='");
                endIndex = img.indexOf("'", srcIndex + 6);
            }
            if (endIndex != -1) {
                String fileExtension;
                int extPoint;
                URL url;
                String path = img.substring(srcIndex + 5, endIndex);
                try {
                    url = tipLoader != null ? ResourceUtil.getResource((ClassLoader)tipLoader, (String)"/tips/", (String)path) : new File(tipPath, path).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    url = null;
                }
                if (url != null) {
                    path = url.toExternalForm();
                }
                String pathWithoutExtension = (extPoint = path.lastIndexOf(46)) != -1 ? path.substring(0, extPoint) : path;
                String string = fileExtension = extPoint != -1 ? path.substring(extPoint) : "";
                if (!pathWithoutExtension.endsWith("_dark") && !pathWithoutExtension.endsWith("@2x") || tipLoader == null) {
                    boolean hidpi = JBUI.isPixHiDPI((Component)component);
                    path = pathWithoutExtension + (hidpi ? "@2x" : "") + (dark ? "_dark" : "") + fileExtension;
                    if (url != null) {
                        String newImgTag = "<img src=\"" + url + "\" ";
                        try {
                            Trinity<String, BufferedImage, byte[]> trinity;
                            URL actualURL;
                            boolean fallbackUpscale = false;
                            try {
                                actualURL = new URL(path);
                                trinity = TipUIUtil.read(actualURL);
                            }
                            catch (IOException e) {
                                if (!path.endsWith(".svg")) {
                                    LOG.warn("Cannot find icon with path [" + path + "]");
                                }
                                fallbackUpscale = hidpi;
                                actualURL = url;
                                trinity = TipUIUtil.read(url);
                            }
                            newImgTag = Registry.is((String)"ide.javafx.tips") ? "<img src=\"data:image/" + (String)trinity.first + ";base64," + Base64.getEncoder().encodeToString((byte[])trinity.third) + "\" " : "<img src=\"" + actualURL.toExternalForm() + "\" ";
                            BufferedImage image = (BufferedImage)trinity.second;
                            int w = image.getWidth();
                            int h = image.getHeight();
                            if (hidpi) {
                                float k = 2.0f;
                                if (UIUtil.isJreHiDPI((Component)component)) {
                                    k = JBUI.sysScale((Component)component);
                                }
                                w = (int)((float)w / k);
                                h = (int)((float)h / k);
                            }
                            int userScale = PaintUtil.RoundingMode.ROUND_FLOOR_BIAS.round((double)JBUI.scale((float)1.0f));
                            w = userScale * w;
                            h = userScale * h;
                            if (fallbackUpscale) {
                                w *= 2;
                                h *= 2;
                            }
                            newImgTag = newImgTag + "width=\"" + w + "\" height=\"" + h + "\"";
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        newImgTag = newImgTag + ">";
                        text.replace(index, end + 1, newImgTag);
                    }
                }
            }
            index = text.indexOf("<img", index + 1);
        }
    }

    private static Trinity<String, BufferedImage, byte[]> read(@NotNull URL url) throws IOException {
        BufferedImage image;
        byte[] bytes = TipUIUtil.readBytes(url);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(new ByteArrayImageInputStream(bytes));
        String formatName = "png";
        if (readers.hasNext()) {
            formatName = readers.next().getFormatName();
        }
        if ((image = ImageIO.read(new ByteArrayInputStream(bytes))) == null) {
            throw new IOException("Cannot read image with ImageIO: " + url.toExternalForm());
        }
        return Trinity.create((Object)formatName, (Object)image, (Object)bytes);
    }

    private static byte[] readBytes(@NotNull URL url) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        try (InputStream stream = url.openStream();){
            int len = stream.read(buffer);
            while (len > 0) {
                baos.write(buffer, 0, len);
                len = stream.read(buffer);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private static void updateShortcuts(StringBuilder text) {
        int lastIndex = 0;
        while ((lastIndex = text.indexOf(SHORTCUT_ENTITY, lastIndex)) >= 0) {
            Keymap defKeymap;
            int actionIdStart = lastIndex + SHORTCUT_ENTITY.length();
            int actionIdEnd = text.indexOf(";", actionIdStart);
            if (actionIdEnd < 0) {
                return;
            }
            String actionId = text.substring(actionIdStart, actionIdEnd);
            String shortcutText = TipUIUtil.getShortcutText(actionId, KeymapManager.getInstance().getActiveKeymap());
            if (shortcutText == null && (defKeymap = KeymapManager.getInstance().getKeymap(DefaultKeymap.getInstance().getDefaultKeymapName())) != null && (shortcutText = TipUIUtil.getShortcutText(actionId, defKeymap)) != null) {
                shortcutText = shortcutText + " in default keymap";
            }
            if (shortcutText == null) {
                shortcutText = "<no shortcut for action " + actionId + ">";
            }
            text.replace(lastIndex, actionIdEnd + 1, shortcutText);
            lastIndex += shortcutText.length();
        }
        return;
    }

    @Nullable
    private static String getShortcutText(String actionId, Keymap keymap) {
        for (Shortcut shortcut : keymap.getShortcuts(actionId)) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            return KeymapUtil.getShortcutText((Shortcut)shortcut);
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static JEditorPane createTipBrowser() {
        return new SwingBrowser();
    }

    public static Browser createBrowser() {
        return new SwingBrowser();
    }

    private static class SwingBrowser
    extends JEditorPane
    implements Browser {
        SwingBrowser() {
            this.setEditable(false);
            this.setBackground(UIUtil.getTextFieldBackground());
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserUtil.browse((URL)e.getURL());
                    }
                }
            });
            URL resource = ResourceUtil.getResource(TipUIUtil.class, (String)"/tips/css/", (String)(UIUtil.isUnderDarcula() ? "tips_darcula.css" : "tips.css"));
            UIUtil.JBHtmlEditorKit kit = new UIUtil.JBHtmlEditorKit(false){
                private final ViewFactory myFactory;
                {
                    super(x0);
                    this.myFactory = this.createViewFactory();
                }

                private ViewFactory createViewFactory() {
                    return new HTMLEditorKit.HTMLFactory(){

                        @Override
                        public View create(Element elem) {
                            String src;
                            View view = super.create(elem);
                            if (view instanceof ImageView && (src = (String)view.getElement().getAttributes().getAttribute(HTML.Attribute.SRC)) != null) {
                                try {
                                    final URL url = new URL(src);
                                    Dictionary cache = (Dictionary)elem.getDocument().getProperty("imageCache");
                                    if (cache == null) {
                                        cache = new Dictionary(){
                                            private final HashMap myMap = new HashMap();

                                            @Override
                                            public int size() {
                                                return this.myMap.size();
                                            }

                                            @Override
                                            public boolean isEmpty() {
                                                return this.size() == 0;
                                            }

                                            public Enumeration keys() {
                                                return Collections.enumeration(this.myMap.keySet());
                                            }

                                            public Enumeration elements() {
                                                return Collections.enumeration(this.myMap.values());
                                            }

                                            public Object get(Object key) {
                                                return this.myMap.get(key);
                                            }

                                            public Object put(Object key, Object value) {
                                                return this.myMap.put(key, value);
                                            }

                                            public Object remove(Object key) {
                                                return this.myMap.remove(key);
                                            }
                                        };
                                        elem.getDocument().putProperty("imageCache", cache);
                                    }
                                    final Image image = src.endsWith(".svg") ? SVGLoader.load((URL)url, (float)(JBUI.isPixHiDPI((Component)null) ? 2.0f : 1.0f)) : Toolkit.getDefaultToolkit().createImage(url);
                                    cache.put(url, image);
                                    if (src.endsWith(".svg")) {
                                        return new ImageView(elem){

                                            @Override
                                            public Image getImage() {
                                                return image;
                                            }

                                            @Override
                                            public URL getImageURL() {
                                                return url;
                                            }

                                            @Override
                                            public void paint(Graphics g, Shape a) {
                                                Rectangle bounds2 = a.getBounds();
                                                int width = (int)this.getPreferredSpan(0);
                                                int height = (int)this.getPreferredSpan(1);
                                                BufferedImage buffer = new BufferedImage(width, height, 2);
                                                Graphics2D graphics = buffer.createGraphics();
                                                super.paint(graphics, new Rectangle(buffer.getWidth(), buffer.getHeight()));
                                                UIUtil.drawImage((Graphics)g, (Image)ImageUtil.ensureHiDPI((Image)image, (JBUI.ScaleContext)JBUI.ScaleContext.create((Component)null)), (int)bounds2.x, (int)bounds2.y, null);
                                            }

                                            @Override
                                            public float getMaximumSpan(int axis) {
                                                return this.getPreferredSpan(axis);
                                            }

                                            @Override
                                            public float getMinimumSpan(int axis) {
                                                return this.getPreferredSpan(axis);
                                            }

                                            @Override
                                            public float getPreferredSpan(int axis) {
                                                return (float)(axis == 0 ? image.getWidth(null) : image.getHeight(null)) / JBUI.sysScale();
                                            }
                                        };
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return view;
                        }
                    };
                }

                public ViewFactory getViewFactory() {
                    return this.myFactory;
                }
            };
            kit.getStyleSheet().addStyleSheet(UIUtil.loadStyleSheet((URL)resource));
            this.setEditorKit((EditorKit)kit);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            if (t != null && t.length() > 0) {
                this.setCaretPosition(0);
            }
        }

        @Override
        public void load(String url) throws IOException {
            this.setText(IOUtil.readString((DataInput)new DataInputStream(new URL(url).openStream())));
        }

        @Override
        public JComponent getComponent() {
            return this;
        }
    }

    public static interface Browser
    extends TextAccessor {
        public void load(String var1) throws IOException;

        public JComponent getComponent();
    }
}

