/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameFilterConfiguration;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseByNameLanguageFilter
extends ChooseByNameFilter<Language> {
    public ChooseByNameLanguageFilter(@NotNull ChooseByNamePopup popup2, @NotNull FilteringGotoByModel<Language> languageFilteringGotoByModel, @NotNull ChooseByNameFilterConfiguration<Language> languageChooseByNameFilterConfiguration, @NotNull Project project) {
        super(popup2, languageFilteringGotoByModel, languageChooseByNameFilterConfiguration, project);
    }

    @Override
    protected String textForFilterValue(@NotNull Language value) {
        return value.getDisplayName();
    }

    @Override
    @Nullable
    protected Icon iconForFilterValue(@NotNull Language value) {
        LanguageFileType fileType = value.getAssociatedFileType();
        return fileType != null ? fileType.getIcon() : null;
    }

    @Override
    @NotNull
    protected Collection<Language> getAllFilterValues() {
        Collection registeredLanguages = Language.getRegisteredLanguages();
        ArrayList<Language> accepted = new ArrayList<Language>();
        for (Language language : registeredLanguages) {
            if (language == Language.ANY || language instanceof DependentLanguage) continue;
            accepted.add(language);
        }
        Collections.sort(accepted, LanguageUtil.LANGUAGE_COMPARATOR);
        return accepted;
    }
}

