/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ContributorsBasedGotoByModel
implements ChooseByNameModelEx {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel");
    protected final Project myProject;
    private final List<ChooseByNameContributor> myContributors;
    private final ConcurrentMap<ChooseByNameContributor, TIntHashSet> myContributorToItsSymbolsMap = ContainerUtil.newConcurrentMap();
    private volatile IdFilter myIdFilter;
    private volatile boolean myIdFilterForLibraries;

    protected ContributorsBasedGotoByModel(@NotNull Project project, @NotNull ChooseByNameContributor[] contributors) {
        this(project, Arrays.asList(contributors));
    }

    protected ContributorsBasedGotoByModel(@NotNull Project project, @NotNull List<ChooseByNameContributor> contributors) {
        this.myProject = project;
        this.myContributors = contributors;
        assert (!contributors.contains(null));
    }

    public ListCellRenderer getListCellRenderer() {
        return new NavigationItemListCellRenderer();
    }

    public boolean sameNamesForProjectAndLibraries() {
        return !ChooseByNameBase.ourLoadNamesEachTime;
    }

    @Override
    public void processNames(final Processor<? super String> nameProcessor, final boolean checkBoxState) {
        long start2 = System.currentTimeMillis();
        List<ChooseByNameContributor> liveContribs = this.filterDumb(this.myContributors);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ReadActionProcessor<ChooseByNameContributor> processor2 = new ReadActionProcessor<ChooseByNameContributor>(){

            public boolean processInReadAction(@NotNull ChooseByNameContributor contributor) {
                try {
                    if (!ContributorsBasedGotoByModel.this.myProject.isDisposed()) {
                        long contributorStarted = System.currentTimeMillis();
                        ContributorsBasedGotoByModel.this.processContributorNames(contributor, checkBoxState, (Processor<? super String>)nameProcessor);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(contributor + " for " + (System.currentTimeMillis() - contributorStarted));
                        }
                    }
                }
                catch (ProcessCanceledException | IndexNotReadyException contributorStarted) {
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex);
                }
                return true;
            }
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(liveContribs, indicator, processor2)) {
            throw new ProcessCanceledException();
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        long finish = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("processNames(): " + (finish - start2) + "ms;");
        }
    }

    public void processContributorNames(@NotNull ChooseByNameContributor contributor, boolean checkBoxState, @NotNull Processor<? super String> nameProcessor) {
        TIntHashSet filter = new TIntHashSet(1000);
        if (contributor instanceof ChooseByNameContributorEx) {
            ((ChooseByNameContributorEx)contributor).processNames((Processor<String>)((Processor)s -> {
                if (nameProcessor.process(s)) {
                    filter.add(s.hashCode());
                }
                return true;
            }), FindSymbolParameters.searchScopeFor(this.myProject, checkBoxState), this.getIdFilter(checkBoxState));
        } else {
            String[] names;
            for (String element : names = contributor.getNames(this.myProject, checkBoxState)) {
                if (!nameProcessor.process((Object)element)) continue;
                filter.add(element.hashCode());
            }
        }
        this.myContributorToItsSymbolsMap.put(contributor, filter);
    }

    IdFilter getIdFilter(boolean withLibraries) {
        IdFilter idFilter = this.myIdFilter;
        if (idFilter == null || this.myIdFilterForLibraries != withLibraries) {
            this.myIdFilter = idFilter = IdFilter.getProjectIdFilter((Project)this.myProject, (boolean)withLibraries);
            this.myIdFilterForLibraries = withLibraries;
        }
        return idFilter;
    }

    @NotNull
    public String[] getNames(boolean checkBoxState) {
        THashSet allNames = ContainerUtil.newTroveSet();
        Collection result2 = Collections.synchronizedCollection(allNames);
        this.processNames((Processor<? super String>)Processors.cancelableCollectProcessor(result2), checkBoxState);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getNames(): (got " + allNames.size() + " elements)");
        }
        return ArrayUtil.toStringArray((Collection)allNames);
    }

    private List<ChooseByNameContributor> filterDumb(List<ChooseByNameContributor> contributors) {
        if (!DumbService.getInstance((Project)this.myProject).isDumb()) {
            return contributors;
        }
        ArrayList<ChooseByNameContributor> answer = new ArrayList<ChooseByNameContributor>(contributors.size());
        for (ChooseByNameContributor contributor : contributors) {
            if (!DumbService.isDumbAware((Object)contributor)) continue;
            answer.add(contributor);
        }
        return answer;
    }

    @NotNull
    public Object[] getElementsByName(@NotNull String name, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator canceled) {
        long elementByNameStarted = System.currentTimeMillis();
        List items = Collections.synchronizedList(new ArrayList());
        Processor processor2 = contributor -> {
            if (this.myProject.isDisposed()) {
                return true;
            }
            TIntHashSet filter = (TIntHashSet)this.myContributorToItsSymbolsMap.get(contributor);
            if (filter != null && !filter.contains(name.hashCode())) {
                return true;
            }
            try {
                boolean searchInLibraries = parameters.getSearchScope().isSearchInLibraries();
                long contributorStarted = System.currentTimeMillis();
                if (contributor instanceof ChooseByNameContributorEx) {
                    ((ChooseByNameContributorEx)contributor).processElementsWithName(name, (Processor<NavigationItem>)((Processor)item -> {
                        canceled.checkCanceled();
                        if (this.acceptItem((NavigationItem)item)) {
                            items.add(item);
                        }
                        return true;
                    }), parameters);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + ",");
                    }
                } else {
                    NavigationItem[] itemsByName;
                    for (NavigationItem item2 : itemsByName = contributor.getItemsByName(name, parameters.getLocalPatternName(), this.myProject, searchInLibraries)) {
                        canceled.checkCanceled();
                        if (item2 == null) {
                            PluginException.logPluginError((Logger)LOG, (String)("null item from contributor " + contributor + " for name " + name), null, contributor.getClass());
                            continue;
                        }
                        if (!this.acceptItem(item2)) continue;
                        items.add(item2);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + "," + itemsByName.length);
                    }
                }
            }
            catch (ProcessCanceledException searchInLibraries) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(this.filterDumb(this.myContributors), canceled, processor2)) {
            canceled.cancel();
        }
        canceled.checkCanceled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving " + name + ":" + items.size() + " for " + (System.currentTimeMillis() - elementByNameStarted));
        }
        return ArrayUtil.toObjectArray(items);
    }

    @NotNull
    public Object[] getElementsByName(String name, boolean checkBoxState, String pattern) {
        return this.getElementsByName(name, FindSymbolParameters.wrap(pattern, this.myProject, checkBoxState), new ProgressIndicatorBase());
    }

    public String getElementName(Object element) {
        if (!(element instanceof NavigationItem)) {
            throw new AssertionError((Object)((element == null ? "null" : element + " of " + element.getClass()) + " in " + this + " of " + this.getClass()));
        }
        return ((NavigationItem)element).getName();
    }

    public String getHelpId() {
        return null;
    }

    protected ChooseByNameContributor[] getContributors() {
        return this.myContributors.toArray(new ChooseByNameContributor[0]);
    }

    protected boolean acceptItem(NavigationItem item) {
        return true;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        return pattern;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }
}

