/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.SmartList;
import com.intellij.util.SynchronizedCollectConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultChooseByNameItemProvider
implements ChooseByNameItemProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ChooseByNameIdea");
    private static final String UNIVERSAL_SEPARATOR = "\u0000";
    private final SmartPsiElementPointer myContext;

    public DefaultChooseByNameItemProvider(@Nullable PsiElement context) {
        this.myContext = context == null ? null : SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(context);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        return DefaultChooseByNameItemProvider.filterElements(base, pattern, everywhere, indicator, this.myContext == null ? null : this.myContext.getElement(), (Producer<String[]>)((Producer)() -> base.getNames(everywhere)), consumer);
    }

    public static boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @Nullable PsiElement context, @NotNull Processor<Object> consumer) {
        return DefaultChooseByNameItemProvider.filterElements(base, pattern, everywhere, indicator, context, null, consumer);
    }

    private static boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @Nullable PsiElement context, @Nullable Producer<String[]> allNamesProducer, @NotNull Processor<Object> consumer) {
        if (base.getProject() != null) {
            base.getProject().putUserData(ChooseByNamePopup.CURRENT_SEARCH_PATTERN, (Object)pattern);
        }
        String namePattern = DefaultChooseByNameItemProvider.getNamePattern(base, pattern);
        boolean preferStartMatches = !pattern.startsWith("*");
        List<MatchResult> namesList = DefaultChooseByNameItemProvider.getSortedNamesForAllWildcards(base, pattern, everywhere, indicator, allNamesProducer, namePattern, preferStartMatches);
        indicator.checkCanceled();
        return DefaultChooseByNameItemProvider.processByNames(base, everywhere, indicator, context, consumer, preferStartMatches, namesList, DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere));
    }

    @NotNull
    private static List<MatchResult> getSortedNamesForAllWildcards(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @Nullable Producer<String[]> allNamesProducer, String namePattern, boolean preferStartMatches) {
        String matchingPattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern);
        if (matchingPattern.isEmpty() && !base.canShowListForEmptyPattern()) {
            return Collections.emptyList();
        }
        List<MatchResult> result2 = DefaultChooseByNameItemProvider.getSortedNames(base, pattern, everywhere, indicator, allNamesProducer, matchingPattern, preferStartMatches);
        if (!namePattern.contains("*")) {
            return result2;
        }
        HashSet<String> allNames = new HashSet<String>(ContainerUtil.map(result2, mr -> mr.elementName));
        for (int i = 1; i < namePattern.length() - 1; ++i) {
            if (namePattern.charAt(i) != '*') continue;
            List<MatchResult> namesForSuffix = DefaultChooseByNameItemProvider.getSortedNames(base, pattern, everywhere, indicator, allNamesProducer, DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern.substring(i + 1)), preferStartMatches);
            for (MatchResult mr2 : namesForSuffix) {
                if (!allNames.add(mr2.elementName)) continue;
                result2.add(mr2);
            }
        }
        return result2;
    }

    @NotNull
    private static List<MatchResult> getSortedNames(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @Nullable Producer<String[]> allNamesProducer, String namePattern, boolean preferStartMatches) {
        List<MatchResult> namesList = DefaultChooseByNameItemProvider.getAllNames(base, pattern, everywhere, indicator, allNamesProducer, namePattern);
        indicator.checkCanceled();
        long started = System.currentTimeMillis();
        Collections.sort(namesList, Comparator.comparing(mr -> !pattern.equalsIgnoreCase(mr.elementName)).thenComparing(mr -> !namePattern.equalsIgnoreCase(mr.elementName)).thenComparing((mr1, mr2) -> mr1.compareWith((MatchResult)mr2, preferStartMatches)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorted:" + (System.currentTimeMillis() - started) + ",results:" + namesList.size());
        }
        return namesList;
    }

    @NotNull
    private static List<MatchResult> getAllNames(@NotNull ChooseByNameViewModel base, @NotNull String fullPattern, boolean everywhere, @NotNull ProgressIndicator indicator, @Nullable Producer<String[]> allNamesProducer, String namePattern) {
        ArrayList<MatchResult> namesList = new ArrayList<MatchResult>();
        SynchronizedCollectConsumer collect = new SynchronizedCollectConsumer(namesList);
        ChooseByNameModel model = base.getModel();
        if (model instanceof ChooseByNameModelEx) {
            indicator.checkCanceled();
            long started = System.currentTimeMillis();
            MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(namePattern);
            ((ChooseByNameModelEx)model).processNames((Processor<? super String>)((Processor)arg_0 -> DefaultChooseByNameItemProvider.lambda$getAllNames$5(indicator, base, fullPattern, matcher, (CollectConsumer)collect, arg_0)), everywhere);
            if (LOG.isDebugEnabled()) {
                LOG.debug("loaded + matched:" + (System.currentTimeMillis() - started) + "," + collect.getResult().size());
            }
        } else {
            if (allNamesProducer == null) {
                throw new IllegalArgumentException("Need to specify allNamesProducer when using a model which isn't a ChooseByNameModelEx");
            }
            String[] names = (String[])allNamesProducer.produce();
            long started = System.currentTimeMillis();
            DefaultChooseByNameItemProvider.processNamesByPattern(base, names, namePattern, indicator, (Consumer<? super MatchResult>)collect);
            if (LOG.isDebugEnabled()) {
                LOG.debug("matched:" + (System.currentTimeMillis() - started) + "," + names.length);
            }
        }
        return namesList;
    }

    @NotNull
    private static FindSymbolParameters createParameters(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere) {
        ChooseByNameModel model = base.getModel();
        IdFilter idFilter = model instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model).getIdFilter(everywhere) : null;
        GlobalSearchScope searchScope = FindSymbolParameters.searchScopeFor(base.getProject(), everywhere);
        return new FindSymbolParameters(pattern, DefaultChooseByNameItemProvider.getNamePattern(base, pattern), searchScope, idFilter);
    }

    private static boolean processByNames(@NotNull ChooseByNameViewModel base, boolean everywhere, @NotNull ProgressIndicator indicator, final @Nullable PsiElement context, @NotNull Processor<Object> consumer, boolean preferStartMatches, List<? extends MatchResult> namesList, FindSymbolParameters parameters) {
        SmartList sameNameElements = new SmartList();
        THashMap qualifierMatchResults = ContainerUtil.newIdentityTroveMap();
        final ChooseByNameModel model = base.getModel();
        Comparator<Object> weightComparator = new Comparator<Object>((Map)qualifierMatchResults, preferStartMatches){
            final Comparator<Object> modelComparator;
            final /* synthetic */ Map val$qualifierMatchResults;
            final /* synthetic */ boolean val$preferStartMatches;
            {
                this.val$qualifierMatchResults = map2;
                this.val$preferStartMatches = bl;
                this.modelComparator = model instanceof Comparator ? (Comparator)model : new PathProximityComparator(context);
            }

            @Override
            public int compare(Object o1, Object o2) {
                int result2 = this.modelComparator.compare(o1, o2);
                return result2 != 0 ? result2 : ((MatchResult)this.val$qualifierMatchResults.get(o1)).compareWith((MatchResult)this.val$qualifierMatchResults.get(o2), this.val$preferStartMatches);
            }
        };
        MinusculeMatcher fullMatcher = DefaultChooseByNameItemProvider.getFullMatcher(parameters, base);
        for (MatchResult matchResult : namesList) {
            Object[] elements;
            indicator.checkCanceled();
            String name = matchResult.elementName;
            Object[] objectArray = elements = model instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model).getElementsByName(name, parameters, indicator) : model.getElementsByName(name, everywhere, DefaultChooseByNameItemProvider.getNamePattern(base, parameters.getCompletePattern()));
            if (elements.length > 1) {
                sameNameElements.clear();
                qualifierMatchResults.clear();
                for (Object element : elements) {
                    indicator.checkCanceled();
                    MatchResult qualifierResult = DefaultChooseByNameItemProvider.matchQualifiedName(model, fullMatcher, element);
                    if (qualifierResult == null) continue;
                    sameNameElements.add(element);
                    qualifierMatchResults.put(element, qualifierResult);
                }
                Collections.sort(sameNameElements, weightComparator);
                if (ContainerUtil.process((List)sameNameElements, consumer)) continue;
                return false;
            }
            if (elements.length != 1 || DefaultChooseByNameItemProvider.matchQualifiedName(model, fullMatcher, elements[0]) == null || consumer.process(elements[0])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected PathProximityComparator getPathProximityComparator() {
        return new PathProximityComparator(this.myContext == null ? null : this.myContext.getElement());
    }

    @NotNull
    private static MinusculeMatcher getFullMatcher(FindSymbolParameters parameters, ChooseByNameViewModel base) {
        String fullRawPattern = DefaultChooseByNameItemProvider.buildFullPattern(base, parameters.getCompletePattern());
        String fullNamePattern = DefaultChooseByNameItemProvider.buildFullPattern(base, base.transformPattern(parameters.getCompletePattern()));
        return NameUtil.buildMatcherWithFallback((String)fullRawPattern, (String)fullNamePattern, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }

    @NotNull
    private static String buildFullPattern(ChooseByNameViewModel base, String pattern) {
        String fullPattern = "*" + DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern);
        for (String separator : base.getModel().getSeparators()) {
            fullPattern = StringUtil.replace((String)fullPattern, (String)separator, (String)"*\u0000*");
        }
        return fullPattern;
    }

    @NotNull
    private static String getNamePattern(@NotNull ChooseByNameViewModel base, String pattern) {
        String transformedPattern = base.transformPattern(pattern);
        return DefaultChooseByNameItemProvider.getNamePattern(base.getModel(), transformedPattern);
    }

    private static String getNamePattern(ChooseByNameModel model, String pattern) {
        String[] separators = model.getSeparators();
        int lastSeparatorOccurrence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            if (idx == pattern.length() - 1) {
                idx = pattern.lastIndexOf(separator, idx - 1);
            }
            lastSeparatorOccurrence = Math.max(lastSeparatorOccurrence, idx == -1 ? idx : idx + separator.length());
        }
        return pattern.substring(lastSeparatorOccurrence);
    }

    @Nullable
    private static MatchResult matchQualifiedName(ChooseByNameModel model, MinusculeMatcher fullMatcher, Object element) {
        String fullName = model.getFullName(element);
        if (fullName == null) {
            return null;
        }
        for (String separator : model.getSeparators()) {
            fullName = StringUtil.replace((String)fullName, (String)separator, (String)UNIVERSAL_SEPARATOR);
        }
        return DefaultChooseByNameItemProvider.matchName(fullMatcher, fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, @NotNull String[] names, @NotNull String pattern) {
        if ((pattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, pattern)).isEmpty() && !base.canShowListForEmptyPattern()) {
            return Collections.emptyList();
        }
        ArrayList<String> filtered = new ArrayList<String>();
        DefaultChooseByNameItemProvider.processNamesByPattern(base, names, pattern, ProgressIndicatorProvider.getGlobalProgressIndicator(), (Consumer<? super MatchResult>)((Consumer)result2 -> {
            List list2 = filtered;
            synchronized (list2) {
                filtered.add(result2.elementName);
            }
        }));
        ArrayList<String> arrayList = filtered;
        synchronized (arrayList) {
            return filtered;
        }
    }

    private static void processNamesByPattern(@NotNull ChooseByNameViewModel base, @NotNull String[] names, @NotNull String pattern, ProgressIndicator indicator, @NotNull Consumer<? super MatchResult> consumer) {
        MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(pattern);
        Processor processor2 = name -> {
            ProgressManager.checkCanceled();
            MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, name);
            if (result2 != null) {
                consumer.consume((Object)result2);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(names), indicator, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private static String convertToMatchingPattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        return DefaultChooseByNameItemProvider.addSearchAnywherePatternDecorationIfNeeded(base, DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern));
    }

    @NotNull
    private static String addSearchAnywherePatternDecorationIfNeeded(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        String trimmedPattern;
        if (base.isSearchInAnyPlace() && !(trimmedPattern = pattern.trim()).isEmpty() && trimmedPattern.length() > 1) {
            pattern = "*" + pattern;
        }
        return pattern;
    }

    @NotNull
    private static String removeModelSpecificMarkup(@NotNull ChooseByNameModel model, @NotNull String pattern) {
        if (model instanceof ContributorsBasedGotoByModel) {
            pattern = ((ContributorsBasedGotoByModel)model).removeModelSpecificMarkup(pattern);
        }
        return pattern;
    }

    @Nullable
    protected static MatchResult matches(@NotNull ChooseByNameViewModel base, @NotNull String pattern, @NotNull MinusculeMatcher matcher, @Nullable String name) {
        if (name == null) {
            return null;
        }
        if (base.getModel() instanceof CustomMatcherModel) {
            try {
                return ((CustomMatcherModel)base.getModel()).matches(name, pattern) ? new MatchResult(name, 0, true) : null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        return DefaultChooseByNameItemProvider.matchName(matcher, name);
    }

    @Nullable
    private static MatchResult matchName(@NotNull MinusculeMatcher matcher, @NotNull String name) {
        FList fragments = matcher.matchingFragments(name);
        return fragments != null ? new MatchResult(name, matcher.matchingDegree(name, false, fragments), MinusculeMatcher.isStartMatch((Iterable)fragments)) : null;
    }

    @NotNull
    private static MinusculeMatcher buildPatternMatcher(@NotNull String pattern) {
        return NameUtil.buildMatcher((String)pattern, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }

    private static /* synthetic */ boolean lambda$getAllNames$5(ProgressIndicator indicator, ChooseByNameViewModel base, String fullPattern, MinusculeMatcher matcher, CollectConsumer collect, String sequence) {
        indicator.checkCanceled();
        MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, fullPattern, matcher, sequence);
        if (result2 != null) {
            collect.consume((Object)result2);
            return true;
        }
        return false;
    }

    protected static class PathProximityComparator
    implements Comparator<Object> {
        @NotNull
        private final PsiProximityComparator myProximityComparator;

        private PathProximityComparator(@Nullable PsiElement context) {
            this.myProximityComparator = new PsiProximityComparator(context);
        }

        private static boolean isCompiledWithoutSource(Object o) {
            return o instanceof PsiCompiledElement && ((PsiCompiledElement)o).getNavigationElement() == o;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int rc = this.myProximityComparator.compare(o1, o2);
            if (rc != 0) {
                return rc;
            }
            int o1Weight = PathProximityComparator.isCompiledWithoutSource(o1) ? 1 : 0;
            int o2Weight = PathProximityComparator.isCompiledWithoutSource(o2) ? 1 : 0;
            return o1Weight - o2Weight;
        }
    }
}

