/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.GotoActionAliasMatcher;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.OnOffButton;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionModel
implements ChooseByNameModel,
Comparator<Object>,
DumbAware {
    private static final Pattern INNER_GROUP_WITH_IDS = Pattern.compile("(.*) \\(\\d+\\)");
    @Nullable
    private final Project myProject;
    private final Component myContextComponent;
    @Nullable
    private final Editor myEditor;
    protected final ActionManager myActionManager = ActionManager.getInstance();
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    private final Map<AnAction, GroupMapping> myActionGroups = new HashMap<AnAction, GroupMapping>();
    private final NotNullLazyValue<Map<String, String>> myConfigurablesNames = VolatileNotNullLazyValue.createValue(() -> {
        THashMap map2 = ContainerUtil.newTroveMap();
        for (Configurable configurable : ShowSettingsUtilImpl.getConfigurables(this.getProject(), true)) {
            if (!(configurable instanceof SearchableConfigurable)) continue;
            map2.put(((SearchableConfigurable)configurable).getId(), configurable.getDisplayName());
        }
        return map2;
    });
    private final ModalityState myModality;

    public GotoActionModel(@Nullable Project project, Component component, @Nullable Editor editor) {
        this(project, component, editor, ModalityState.defaultModalityState());
    }

    public GotoActionModel(@Nullable Project project, Component component, @Nullable Editor editor, @Nullable ModalityState modalityState) {
        this.myProject = project;
        this.myContextComponent = component;
        this.myEditor = editor;
        this.myModality = modalityState;
        ActionGroup mainMenu = (ActionGroup)this.myActionManager.getActionOrStub("MainMenu");
        assert (mainMenu != null);
        this.collectActions(mainMenu, Collections.emptyList());
    }

    @NotNull
    Map<String, ApplyIntentionAction> getAvailableIntentions() {
        TreeMap<String, ApplyIntentionAction> map2 = new TreeMap<String, ApplyIntentionAction>();
        if (this.myProject != null && !this.myProject.isDisposed() && this.myEditor != null && !this.myEditor.isDisposed()) {
            ApplyIntentionAction[] children2;
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            ApplyIntentionAction[] applyIntentionActionArray = children2 = file2 == null ? null : ApplyIntentionAction.getAvailableIntentions(this.myEditor, file2);
            if (children2 != null) {
                for (ApplyIntentionAction action : children2) {
                    map2.put(action.getName(), action);
                }
            }
        }
        return map2;
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoaction.enter.action", (Object[])new Object[0]);
    }

    @Nullable
    public String getCheckBoxName() {
        return IdeBundle.message((String)"checkbox.disabled.included", (Object[])new Object[0]);
    }

    public String getNotInMessage() {
        return IdeBundle.message((String)"label.no.enabled.actions.found", (Object[])new Object[0]);
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.actions.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        return false;
    }

    public void saveInitialCheckBoxState(boolean state) {
    }

    public ListCellRenderer getListCellRenderer() {
        return new GotoActionListCellRenderer((Function<? super OptionDescription, String>)((Function)this::getGroupName));
    }

    protected String getActionId(@NotNull AnAction anAction) {
        return this.myActionManager.getId(anAction);
    }

    @NotNull
    private static JLabel createIconLabel(@Nullable Icon icon, boolean disabled) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon == null) {
            return new JLabel((Icon)layeredIcon);
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int emptyIconWidth = EMPTY_ICON.getIconWidth();
        int emptyIconHeight = EMPTY_ICON.getIconHeight();
        if (width <= emptyIconWidth && height <= emptyIconHeight) {
            layeredIcon.setIcon(disabled && IconLoader.isGoodSize((Icon)icon) ? IconLoader.getDisabledIcon((Icon)icon) : icon, 1, (emptyIconWidth - width) / 2, (emptyIconHeight - height) / 2);
        }
        return new JLabel((Icon)layeredIcon);
    }

    @Override
    public int compare(@NotNull Object o1, @NotNull Object o2) {
        if ("...".equals(o1)) {
            return 1;
        }
        if ("...".equals(o2)) {
            return -1;
        }
        return ((MatchedValue)o1).compareTo((MatchedValue)o2);
    }

    @NotNull
    public static AnActionEvent updateActionBeforeShow(@NotNull AnAction anAction, @NotNull DataContext dataContext) {
        Presentation presentation = new Presentation();
        presentation.copyFrom(anAction.getTemplatePresentation());
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"GoToAction", (Presentation)presentation, (DataContext)dataContext);
        ActionUtil.performDumbAwareUpdate((boolean)false, (AnAction)anAction, (AnActionEvent)event, (boolean)false);
        return event;
    }

    public static Color defaultActionForeground(boolean isSelected, @Nullable Presentation presentation) {
        if (!(presentation == null || presentation.isEnabled() && presentation.isVisible())) {
            return UIUtil.getInactiveTextColor();
        }
        if (isSelected) {
            return UIUtil.getListSelectionForeground();
        }
        return UIUtil.getListForeground();
    }

    @NotNull
    public String[] getNames(boolean checkBoxState) {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public Object[] getElementsByName(String id, boolean checkBoxState, String pattern) {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public String getGroupName(@NotNull OptionDescription description) {
        String settings;
        String name = description.getGroupName();
        if (name == null) {
            name = (String)((Map)this.myConfigurablesNames.getValue()).get(description.getConfigurableId());
        }
        String string = settings = SystemInfo.isMac ? "Preferences" : "Settings";
        if (name == null || name.equals(description.getHit())) {
            return settings;
        }
        return settings + " > " + name;
    }

    @NotNull
    Map<String, String> getConfigurablesNames() {
        return (Map)this.myConfigurablesNames.getValue();
    }

    private void collectActions(@NotNull ActionGroup group, @NotNull List<ActionGroup> path) {
        Object[] actions = group.getChildren(null);
        boolean hasMeaningfulChildren = ContainerUtil.exists((Object[])actions, action -> this.myActionManager.getId(action) != null);
        if (!hasMeaningfulChildren) {
            GroupMapping mapping = this.myActionGroups.computeIfAbsent((AnAction)group, key -> new GroupMapping());
            mapping.addPath(path);
        }
        List newPath = ContainerUtil.append(path, (Object[])new ActionGroup[]{group});
        for (Object action2 : actions) {
            if (action2 == null || action2 instanceof Separator) continue;
            if (action2 instanceof ActionGroup) {
                this.collectActions((ActionGroup)action2, newPath);
                continue;
            }
            GroupMapping mapping = this.myActionGroups.computeIfAbsent((AnAction)action2, key -> new GroupMapping());
            mapping.addPath(newPath);
        }
    }

    @Nullable
    GroupMapping getGroupMapping(@NotNull AnAction action) {
        return this.myActionGroups.get(action);
    }

    @Nullable
    public String getFullName(@NotNull Object element) {
        return this.getElementName(element);
    }

    @NonNls
    public String getHelpId() {
        return "procedures.navigating.goto.action";
    }

    @NotNull
    public String[] getSeparators() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Nullable
    public String getElementName(@NotNull Object mv) {
        return ((MatchedValue)mv).getValueText();
    }

    protected MatchMode actionMatches(@NotNull String pattern, MinusculeMatcher matcher, @NotNull AnAction anAction) {
        Presentation presentation = anAction.getTemplatePresentation();
        String text = presentation.getText();
        String description = presentation.getDescription();
        if (text != null && matcher.matches(text)) {
            return MatchMode.NAME;
        }
        if (description != null && !description.equals(text) && matcher.matches(description)) {
            return MatchMode.DESCRIPTION;
        }
        if (text == null) {
            return MatchMode.NONE;
        }
        GroupMapping groupMapping = this.myActionGroups.get(anAction);
        if (groupMapping != null) {
            for (String groupName : groupMapping.getAllGroupNames()) {
                if (matcher.matches(groupName + " " + text)) {
                    return anAction instanceof ToggleAction ? MatchMode.NAME : MatchMode.GROUP;
                }
                if (!matcher.matches(text + " " + groupName)) continue;
                return MatchMode.GROUP;
            }
        }
        for (GotoActionAliasMatcher m : (GotoActionAliasMatcher[])GotoActionAliasMatcher.EP_NAME.getExtensions()) {
            if (!m.match(anAction, pattern)) continue;
            return MatchMode.NAME;
        }
        return MatchMode.NONE;
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    protected Component getContextComponent() {
        return this.myContextComponent;
    }

    @NotNull
    public SortedSet<Object> sortItems(@NotNull Set<Object> elements) {
        TreeSet objects = ContainerUtilRt.newTreeSet((Comparator)this);
        objects.addAll(elements);
        return objects;
    }

    private void updateOnEdt(Runnable update) {
        Semaphore semaphore = new Semaphore(1);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                update.run();
            }
            finally {
                semaphore.up();
            }
        }, this.myModality, __ -> indicator != null && indicator.isCanceled());
        while (!semaphore.waitFor(10L)) {
            if (indicator == null || !indicator.isCanceled()) continue;
            throw new ProcessCanceledException();
        }
    }

    public boolean willOpenEditor() {
        return false;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    public static class GotoActionListCellRenderer
    extends DefaultListCellRenderer {
        private final Function<? super OptionDescription, String> myGroupNamer;
        private final boolean myUseListFont;

        public GotoActionListCellRenderer(Function<? super OptionDescription, String> groupNamer) {
            this(groupNamer, false);
        }

        public GotoActionListCellRenderer(Function<? super OptionDescription, String> groupNamer, boolean useListFont) {
            this.myGroupNamer = groupNamer;
            this.myUseListFont = useListFont;
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list2, Object matchedValue, int index, boolean isSelected, boolean cellHasFocus) {
            boolean showIcon = UISettings.getInstance().getShowIconsInMenus();
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setBorder(JBUI.Borders.empty((int)2));
            panel2.setOpaque(true);
            Color bg = UIUtil.getListBackground((boolean)isSelected);
            panel2.setBackground(bg);
            SimpleColoredComponent nameComponent = new SimpleColoredComponent();
            if (this.myUseListFont) {
                nameComponent.setFont(list2.getFont());
            }
            nameComponent.setBackground(bg);
            panel2.add((Component)nameComponent, "Center");
            if (matchedValue instanceof String) {
                if (showIcon) {
                    panel2.add((Component)new JBLabel(EMPTY_ICON), "West");
                }
                String str = GotoActionListCellRenderer.cutName((String)matchedValue, null, list2, panel2, nameComponent);
                nameComponent.append(str, new SimpleTextAttributes(0, GotoActionModel.defaultActionForeground(isSelected, null)));
                return panel2;
            }
            Color groupFg = isSelected ? UIUtil.getListSelectionForeground() : UIUtil.getInactiveTextColor();
            Comparable value = ((MatchedValue)matchedValue).value;
            String pattern = ((MatchedValue)matchedValue).pattern;
            JBEmptyBorder eastBorder = JBUI.Borders.emptyRight((int)2);
            if (value instanceof ActionWrapper) {
                boolean disabled;
                ActionWrapper actionWithParentGroup = (ActionWrapper)value;
                AnAction anAction = actionWithParentGroup.getAction();
                boolean toggle = anAction instanceof ToggleAction;
                String groupName = actionWithParentGroup.getAction() instanceof ApplyIntentionAction ? null : actionWithParentGroup.getGroupName();
                Presentation presentation = actionWithParentGroup.getPresentation();
                Color fg = GotoActionModel.defaultActionForeground(isSelected, presentation);
                boolean bl = disabled = !presentation.isEnabled() || !presentation.isVisible();
                if (disabled) {
                    groupFg = UIUtil.getLabelDisabledForeground();
                }
                if (showIcon) {
                    Icon icon = presentation.getIcon();
                    panel2.add((Component)GotoActionModel.createIconLabel(icon, disabled), "West");
                }
                if (toggle) {
                    AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)((ActionWrapper)value).myDataContext);
                    boolean selected = ((ToggleAction)anAction).isSelected(event);
                    GotoActionListCellRenderer.addOnOffButton(panel2, selected);
                } else if (groupName != null) {
                    JLabel groupLabel = new JLabel(groupName);
                    groupLabel.setBackground(bg);
                    groupLabel.setBorder((Border)eastBorder);
                    groupLabel.setForeground(groupFg);
                    panel2.add((Component)groupLabel, "East");
                }
                panel2.setToolTipText(presentation.getDescription());
                Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)ActionManager.getInstance().getId(anAction)).getShortcuts();
                String shortcutText = KeymapUtil.getPreferredShortcutText((Shortcut[])shortcuts);
                String name = GotoActionListCellRenderer.getName(presentation.getText(), groupName, toggle);
                name = GotoActionListCellRenderer.cutName(name, shortcutText, list2, panel2, nameComponent);
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, name, pattern, fg, isSelected);
                if (StringUtil.isNotEmpty((String)shortcutText)) {
                    nameComponent.append(" " + shortcutText, new SimpleTextAttributes(129, groupFg));
                }
            } else if (value instanceof OptionDescription) {
                String hit;
                if (!isSelected && !(value instanceof BooleanOptionDescription)) {
                    Color descriptorBg = UIUtil.isUnderDarcula() ? ColorUtil.brighter((Color)UIUtil.getListBackground(), (int)1) : LightColors.SLIGHTLY_GRAY;
                    panel2.setBackground(descriptorBg);
                    nameComponent.setBackground(descriptorBg);
                }
                if ((hit = ((OptionDescription)value).getHit()) == null) {
                    hit = ((OptionDescription)value).getOption();
                }
                hit = StringUtil.unescapeXmlEntities((String)hit);
                String fullHit = hit = hit.replace("  ", " ");
                Color fg = UIUtil.getListForeground((boolean)isSelected);
                if (showIcon) {
                    panel2.add((Component)new JLabel(EMPTY_ICON), "West");
                }
                panel2.setToolTipText(fullHit);
                if (value instanceof BooleanOptionDescription) {
                    boolean selected = ((BooleanOptionDescription)value).isOptionEnabled();
                    GotoActionListCellRenderer.addOnOffButton(panel2, selected);
                } else {
                    JLabel settingsLabel = new JLabel((String)this.myGroupNamer.fun((Object)((OptionDescription)value)));
                    settingsLabel.setForeground(groupFg);
                    settingsLabel.setBackground(bg);
                    settingsLabel.setBorder((Border)eastBorder);
                    panel2.add((Component)settingsLabel, "East");
                }
                String name = GotoActionListCellRenderer.cutName(fullHit, null, list2, panel2, nameComponent);
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, name, pattern, fg, isSelected);
            }
            return panel2;
        }

        private static String cutName(String name, String shortcutText, JList list2, JPanel panel2, SimpleColoredComponent nameComponent) {
            if (!list2.isShowing() || list2.getWidth() <= 0) {
                return StringUtil.first((String)name, (int)60, (boolean)true);
            }
            int freeSpace = GotoActionListCellRenderer.calcFreeSpace(list2, panel2, nameComponent, shortcutText);
            if (freeSpace <= 0) {
                return name;
            }
            FontMetrics fm = nameComponent.getFontMetrics(nameComponent.getFont());
            int strWidth = fm.stringWidth(name);
            if (strWidth <= freeSpace) {
                return name;
            }
            int cutSymbolIndex = (int)(((double)freeSpace - (double)fm.stringWidth("...")) / (double)strWidth * (double)name.length());
            cutSymbolIndex = Integer.max(1, cutSymbolIndex);
            name = name.substring(0, cutSymbolIndex);
            while (fm.stringWidth(name + "...") > freeSpace && name.length() > 1) {
                name = name.substring(0, name.length() - 1);
            }
            return name.trim() + "...";
        }

        private static int calcFreeSpace(JList list2, JPanel panel2, SimpleColoredComponent nameComponent, String shortcutText) {
            BorderLayout layout = (BorderLayout)panel2.getLayout();
            Component eastComponent = layout.getLayoutComponent("East");
            Component westComponent = layout.getLayoutComponent("West");
            int freeSpace = list2.getWidth() - (list2.getInsets().right + list2.getInsets().left) - (panel2.getInsets().right + panel2.getInsets().left) - (eastComponent == null ? 0 : eastComponent.getPreferredSize().width) - (westComponent == null ? 0 : westComponent.getPreferredSize().width) - (nameComponent.getInsets().right + nameComponent.getInsets().left) - (nameComponent.getIpad().right + nameComponent.getIpad().left) - nameComponent.getIconTextGap();
            if (StringUtil.isNotEmpty((String)shortcutText)) {
                FontMetrics fm = nameComponent.getFontMetrics(nameComponent.getFont().deriveFont(1));
                freeSpace -= fm.stringWidth(" " + shortcutText);
            }
            return freeSpace;
        }

        private static void addOnOffButton(@NotNull JPanel panel2, boolean selected) {
            OnOffButton button2 = new OnOffButton();
            button2.setSelected(selected);
            panel2.add((Component)button2, "East");
            panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
        }

        @NotNull
        private static String getName(@Nullable String text, @Nullable String groupName, boolean toggle) {
            return toggle && StringUtil.isNotEmpty((String)groupName) ? (StringUtil.isNotEmpty((String)text) ? groupName + ": " + text : groupName) : StringUtil.notNullize((String)text);
        }

        private static void appendWithColoredMatches(SimpleColoredComponent nameComponent, @NotNull String name, @NotNull String pattern, Color fg, boolean selected) {
            int matchStart;
            SimpleTextAttributes plain = new SimpleTextAttributes(0, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(null, fg, null, 64);
            ArrayList fragments = ContainerUtil.newArrayList();
            if (selected && (matchStart = StringUtil.indexOfIgnoreCase((String)name, (String)pattern, (int)0)) >= 0) {
                fragments.add(TextRange.from((int)matchStart, (int)pattern.length()));
            }
            SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)nameComponent, (String)name, (Iterable)fragments, (SimpleTextAttributes)plain, (SimpleTextAttributes)highlighted);
        }
    }

    public static class ActionWrapper
    implements Comparable<ActionWrapper> {
        @NotNull
        private final AnAction myAction;
        @NotNull
        private final MatchMode myMode;
        @Nullable
        private final GroupMapping myGroupMapping;
        private final DataContext myDataContext;
        private final GotoActionModel myModel;
        private volatile Presentation myPresentation;

        public ActionWrapper(@NotNull AnAction action, @Nullable GroupMapping groupMapping, @NotNull MatchMode mode, DataContext dataContext, GotoActionModel model) {
            this.myAction = action;
            this.myMode = mode;
            this.myGroupMapping = groupMapping;
            this.myDataContext = dataContext;
            this.myModel = model;
        }

        @NotNull
        public AnAction getAction() {
            return this.myAction;
        }

        @NotNull
        public MatchMode getMode() {
            return this.myMode;
        }

        @Override
        public int compareTo(@NotNull ActionWrapper o) {
            int compared = this.myMode.compareTo(o.getMode());
            if (compared != 0) {
                return compared;
            }
            Presentation myPresentation2 = this.myAction.getTemplatePresentation();
            Presentation oPresentation = o.getAction().getTemplatePresentation();
            String myText = StringUtil.notNullize((String)myPresentation2.getText());
            String oText = StringUtil.notNullize((String)oPresentation.getText());
            int byText = StringUtil.compare((String)StringUtil.trimEnd((String)myText, (String)"..."), (String)StringUtil.trimEnd((String)oText, (String)"..."), (boolean)true);
            if (byText != 0) {
                return byText;
            }
            int byTextLength = StringUtil.notNullize((String)myText).length() - StringUtil.notNullize((String)oText).length();
            if (byTextLength != 0) {
                return byTextLength;
            }
            int byGroup = Comparing.compare((Comparable)this.myGroupMapping, (Comparable)o.myGroupMapping);
            if (byGroup != 0) {
                return byGroup;
            }
            int byDesc = StringUtil.compare((String)myPresentation2.getDescription(), (String)oPresentation.getDescription(), (boolean)true);
            if (byDesc != 0) {
                return byDesc;
            }
            int byClassHashCode = Comparing.compare((int)this.myAction.getClass().hashCode(), (int)o.myAction.getClass().hashCode());
            if (byClassHashCode != 0) {
                return byClassHashCode;
            }
            int byInstanceHashCode = Comparing.compare((int)this.myAction.hashCode(), (int)o.myAction.hashCode());
            if (byInstanceHashCode != 0) {
                return byInstanceHashCode;
            }
            return 0;
        }

        public boolean isAvailable() {
            return this.getPresentation().isEnabledAndVisible();
        }

        @NotNull
        public Presentation getPresentation() {
            if (this.myPresentation != null) {
                return this.myPresentation;
            }
            Runnable r = () -> {
                this.myPresentation = GotoActionModel.updateActionBeforeShow(this.myAction, this.myDataContext).getPresentation();
                if (this.myGroupMapping != null) {
                    this.myGroupMapping.updateBeforeShow(this.myDataContext);
                }
            };
            if (ApplicationManager.getApplication().isDispatchThread()) {
                r.run();
            } else {
                this.myModel.updateOnEdt(r);
            }
            return (Presentation)ObjectUtils.notNull((Object)this.myPresentation, (Object)this.myAction.getTemplatePresentation());
        }

        private boolean hasPresentation() {
            return this.myPresentation != null;
        }

        @Nullable
        public String getGroupName() {
            if (this.myGroupMapping == null) {
                return null;
            }
            String groupName = this.myGroupMapping.getBestGroupName();
            if (this.myAction instanceof ActionGroup && Comparing.equal((String)this.myAction.getTemplatePresentation().getText(), (String)groupName)) {
                return null;
            }
            return groupName;
        }

        public boolean isGroupAction() {
            return this.myAction instanceof ActionGroup;
        }

        public boolean equals(Object obj) {
            return obj instanceof ActionWrapper && this.compareTo((ActionWrapper)obj) == 0;
        }

        public int hashCode() {
            String text = this.myAction.getTemplatePresentation().getText();
            return text != null ? text.hashCode() : 0;
        }

        public String toString() {
            return this.myAction.toString();
        }
    }

    public static class GroupMapping
    implements Comparable<GroupMapping> {
        private final List<List<ActionGroup>> myPaths = new ArrayList<List<ActionGroup>>();
        @Nullable
        private String myBestGroupName;
        private boolean myBestNameComputed;

        @NotNull
        public static GroupMapping createFromText(String text) {
            GroupMapping mapping = new GroupMapping();
            mapping.addPath(Collections.singletonList(new DefaultActionGroup(text, false)));
            return mapping;
        }

        private void addPath(@NotNull List<ActionGroup> path) {
            this.myPaths.add(path);
        }

        @Override
        public int compareTo(@NotNull GroupMapping o) {
            return Comparing.compare((Comparable)((Object)this.getFirstGroupName()), (Comparable)((Object)o.getFirstGroupName()));
        }

        @Nullable
        public String getBestGroupName() {
            if (this.myBestNameComputed) {
                return this.myBestGroupName;
            }
            return this.getFirstGroupName();
        }

        @Nullable
        private String getFirstGroupName() {
            List path = (List)ContainerUtil.getFirstItem(this.myPaths);
            return path != null ? GroupMapping.getPathName(path) : null;
        }

        private void updateBeforeShow(@NotNull DataContext context) {
            if (this.myBestNameComputed) {
                return;
            }
            this.myBestNameComputed = true;
            for (List<ActionGroup> path : this.myPaths) {
                String name = GroupMapping.getActualPathName(path, context);
                if (name == null) continue;
                this.myBestGroupName = name;
                return;
            }
        }

        @NotNull
        public List<String> getAllGroupNames() {
            return ContainerUtil.map(this.myPaths, GroupMapping::getPathName);
        }

        @Nullable
        private static String getPathName(@NotNull List<ActionGroup> path) {
            String name = "";
            for (ActionGroup group : path) {
                name = GroupMapping.appendGroupName(name, group, group.getTemplatePresentation());
            }
            return StringUtil.nullize((String)name);
        }

        @Nullable
        private static String getActualPathName(@NotNull List<ActionGroup> path, @NotNull DataContext context) {
            String name = "";
            for (ActionGroup group : path) {
                Presentation presentation = GotoActionModel.updateActionBeforeShow((AnAction)group, context).getPresentation();
                if (!presentation.isVisible()) {
                    return null;
                }
                name = GroupMapping.appendGroupName(name, group, presentation);
            }
            return StringUtil.nullize((String)name);
        }

        @NotNull
        private static String appendGroupName(@NotNull String prefix, @NotNull ActionGroup group, @NotNull Presentation presentation) {
            String groupName;
            if (group.isPopup() && !StringUtil.isEmptyOrSpaces((String)(groupName = GroupMapping.getActionGroupName(presentation)))) {
                return prefix.isEmpty() ? groupName : prefix + " | " + groupName;
            }
            return prefix;
        }

        @Nullable
        private static String getActionGroupName(@NotNull Presentation presentation) {
            String text = presentation.getText();
            if (text == null) {
                return null;
            }
            Matcher matcher = INNER_GROUP_WITH_IDS.matcher(text);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return text;
        }
    }

    public static enum MatchMode {
        NONE,
        INTENTION,
        NAME,
        DESCRIPTION,
        GROUP,
        NON_MENU;

    }

    public static class MatchedValue
    implements Comparable<MatchedValue> {
        @NotNull
        public final Comparable value;
        @NotNull
        final String pattern;

        public MatchedValue(@NotNull Comparable value, @NotNull String pattern) {
            this.value = value;
            this.pattern = pattern;
        }

        @Nullable
        @VisibleForTesting
        public String getValueText() {
            if (this.value instanceof OptionDescription) {
                return ((OptionDescription)this.value).getHit();
            }
            if (!(this.value instanceof ActionWrapper)) {
                return null;
            }
            return ((ActionWrapper)this.value).getAction().getTemplatePresentation().getText();
        }

        @Nullable
        public String toString() {
            return this.getMatchingDegree() + " " + this.getValueText();
        }

        private int getMatchingDegree() {
            String text = this.getValueText();
            if (text != null) {
                int degree = this.getRank(text);
                return this.value instanceof ActionWrapper && !((ActionWrapper)this.value).isGroupAction() ? degree + 1 : degree;
            }
            return 0;
        }

        private int getRank(@NotNull String text) {
            if (StringUtil.equalsIgnoreCase((CharSequence)StringUtil.trimEnd((String)text, (String)"..."), (CharSequence)this.pattern)) {
                return 3;
            }
            if (StringUtil.startsWithIgnoreCase((String)text, (String)this.pattern)) {
                return 2;
            }
            if (StringUtil.containsIgnoreCase((String)text, (String)this.pattern)) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compareTo(@NotNull MatchedValue o) {
            if (o == this) {
                return 0;
            }
            int diff = o.getMatchingDegree() - this.getMatchingDegree();
            if (diff != 0) {
                return diff;
            }
            boolean edt = ApplicationManager.getApplication().isDispatchThread();
            if (this.value instanceof ActionWrapper && o.value instanceof ActionWrapper) {
                int compared;
                if (edt || ((ActionWrapper)this.value).hasPresentation() && ((ActionWrapper)o.value).hasPresentation()) {
                    boolean p1Enable = ((ActionWrapper)this.value).isAvailable();
                    boolean p2enable = ((ActionWrapper)o.value).isAvailable();
                    if (p1Enable && !p2enable) {
                        return -1;
                    }
                    if (!p1Enable && p2enable) {
                        return 1;
                    }
                }
                if ((compared = this.value.compareTo(o.value)) != 0) {
                    return compared;
                }
            }
            if (this.value instanceof ActionWrapper && o.value instanceof BooleanOptionDescription) {
                return edt && ((ActionWrapper)this.value).isAvailable() ? -1 : 1;
            }
            if (o.value instanceof ActionWrapper && this.value instanceof BooleanOptionDescription) {
                return edt && ((ActionWrapper)o.value).isAvailable() ? 1 : -1;
            }
            if (this.value instanceof BooleanOptionDescription && !(o.value instanceof BooleanOptionDescription) && o.value instanceof OptionDescription) {
                return -1;
            }
            if (o.value instanceof BooleanOptionDescription && !(this.value instanceof BooleanOptionDescription) && this.value instanceof OptionDescription) {
                return 1;
            }
            if (this.value instanceof OptionDescription && !(o.value instanceof OptionDescription)) {
                return 1;
            }
            if (o.value instanceof OptionDescription && !(this.value instanceof OptionDescription)) {
                return -1;
            }
            diff = StringUtil.notNullize((String)this.getValueText()).length() - StringUtil.notNullize((String)o.getValueText()).length();
            if (diff != 0) {
                return diff;
            }
            diff = this.value.compareTo(o.value);
            if (diff != 0) {
                return diff;
            }
            return o.hashCode() - this.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchedValue value1 = (MatchedValue)o;
            return Objects.equals(this.value, value1.value) && Objects.equals(this.pattern, value1.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.pattern);
        }
    }
}

