/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoFileItemProvider;
import com.intellij.ide.actions.NonProjectScopeDisablerEP;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.ide.util.gotoByName.GotoFileCustomizer;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.Matcher;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileModel
extends FilteringGotoByModel<FileType>
implements DumbAware,
Comparator<Object> {
    private final int myMaxSize;

    public GotoFileModel(@NotNull Project project) {
        super(project, ChooseByNameContributor.FILE_EP_NAME.getExtensionList());
        this.myMaxSize = ApplicationManager.getApplication().isUnitTestMode() ? Integer.MAX_VALUE : WindowManagerEx.getInstanceEx().getFrame((Project)project).getSize().width;
    }

    public boolean isSlashlessMatchingEnabled() {
        return true;
    }

    @Override
    @NotNull
    public ChooseByNameItemProvider getItemProvider(@Nullable PsiElement context) {
        for (GotoFileCustomizer customizer : GotoFileCustomizer.EP_NAME.getExtensionList()) {
            GotoFileItemProvider provider = customizer.createItemProvider(this.myProject, context, this);
            if (provider == null) continue;
            return provider;
        }
        return new GotoFileItemProvider(this.myProject, context, this);
    }

    @Override
    protected boolean acceptItem(NavigationItem item) {
        if (item instanceof PsiFile) {
            PsiFile file2 = (PsiFile)item;
            Collection types = this.getFilterItems();
            if (types != null) {
                if (types.contains(file2.getFileType())) {
                    return true;
                }
                VirtualFile vFile = file2.getVirtualFile();
                return vFile != null && types.contains(vFile.getFileType());
            }
            return true;
        }
        return super.acceptItem(item);
    }

    @Override
    @Nullable
    protected FileType filterValueFor(NavigationItem item) {
        return item instanceof PsiFile ? ((PsiFile)item).getFileType() : null;
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotofile.enter.file.name", (Object[])new Object[0]);
    }

    public String getCheckBoxName() {
        if (NonProjectScopeDisablerEP.isSearchInNonProjectDisabled()) {
            return null;
        }
        return IdeBundle.message((String)"checkbox.include.non.project.files", (Object[])new Object[]{IdeUICustomization.getInstance().getProjectConceptName()});
    }

    public String getNotInMessage() {
        return "";
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.files.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        return propertiesComponent.isTrueValue("GoToClass.toSaveIncludeLibraries") && propertiesComponent.isTrueValue("GoToFile.includeJavaFiles");
    }

    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (propertiesComponent.isTrueValue("GoToClass.toSaveIncludeLibraries")) {
            propertiesComponent.setValue("GoToFile.includeJavaFiles", Boolean.toString(state));
        }
    }

    @Override
    public PsiElementListCellRenderer getListCellRenderer() {
        return new GotoFileCellRenderer(this.myMaxSize){

            @Override
            @NotNull
            protected PsiElementListCellRenderer.ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value) {
                PsiElementListCellRenderer.ItemMatchers defaultMatchers = super.getItemMatchers(list2, value);
                if (!(value instanceof PsiFileSystemItem)) {
                    return defaultMatchers;
                }
                return GotoFileModel.convertToFileItemMatchers(defaultMatchers, (PsiFileSystemItem)value, GotoFileModel.this);
            }
        };
    }

    @Override
    public boolean sameNamesForProjectAndLibraries() {
        return !FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }

    @Nullable
    public String getFullName(Object element) {
        return element instanceof PsiFileSystemItem ? this.getFullName(((PsiFileSystemItem)element).getVirtualFile()) : this.getElementName(element);
    }

    @Nullable
    public String getFullName(@NotNull VirtualFile file2) {
        VirtualFile root = this.getTopLevelRoot(file2);
        return root != null ? GotoFileCellRenderer.getRelativePathFromRoot(file2, root) : GotoFileCellRenderer.getRelativePath(file2, this.myProject);
    }

    @Nullable
    public VirtualFile getTopLevelRoot(@NotNull VirtualFile file2) {
        VirtualFile root = this.getContentRoot(file2);
        return root == null ? null : (VirtualFile)JBIterable.generate((Object)root, r -> this.getContentRoot(r.getParent())).last();
    }

    private VirtualFile getContentRoot(@Nullable VirtualFile file2) {
        return file2 == null ? null : GotoFileCellRenderer.getAnyRoot(file2, this.myProject);
    }

    @NotNull
    public String[] getSeparators() {
        return new String[]{"/", "\\"};
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }

    public boolean willOpenEditor() {
        return true;
    }

    @Override
    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern.endsWith("/") || pattern.endsWith("\\")) {
            return pattern.substring(0, pattern.length() - 1);
        }
        return pattern;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return 0;
    }

    @NotNull
    public static PsiElementListCellRenderer.ItemMatchers convertToFileItemMatchers(@NotNull PsiElementListCellRenderer.ItemMatchers defaultMatchers, @NotNull PsiFileSystemItem value, @NotNull GotoFileModel model) {
        String shortName = model.getElementName(value);
        String fullName = model.getFullName(value);
        if (shortName != null && fullName != null && defaultMatchers.nameMatcher instanceof MinusculeMatcher) {
            String sanitized = GotoFileItemProvider.getSanitizedPattern(((MinusculeMatcher)defaultMatchers.nameMatcher).getPattern(), model);
            for (int i = sanitized.lastIndexOf(47) + 1; i < sanitized.length() - 1; ++i) {
                MinusculeMatcher nameMatcher = NameUtil.buildMatcher((String)("*" + sanitized.substring(i)), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
                if (!nameMatcher.matches(shortName)) continue;
                String locationPattern = FileUtil.toSystemDependentName((String)StringUtil.trimEnd((String)sanitized.substring(0, i), (String)"/"));
                return new PsiElementListCellRenderer.ItemMatchers((Matcher)nameMatcher, (Matcher)GotoFileItemProvider.getQualifiedNameMatcher(locationPattern));
            }
        }
        return defaultMatchers;
    }
}

