/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import org.jetbrains.annotations.NotNull;

public class MatchResult {
    public final String elementName;
    final int matchingDegree;
    final boolean startMatch;

    public MatchResult(String elementName, int matchingDegree, boolean startMatch) {
        this.elementName = elementName;
        this.matchingDegree = matchingDegree;
        this.startMatch = startMatch;
    }

    public int compareDegrees(@NotNull MatchResult that, boolean preferStartMatches) {
        int startMatchResult;
        boolean start1 = this.startMatch;
        boolean start2 = that.startMatch;
        int n = start1 == start2 ? 0 : (startMatchResult = start1 ? -1 : 1);
        if (preferStartMatches && startMatchResult != 0) {
            return startMatchResult;
        }
        int degree2 = that.matchingDegree;
        int degree1 = this.matchingDegree;
        if (degree2 < degree1) {
            return -1;
        }
        if (degree2 > degree1) {
            return 1;
        }
        return -startMatchResult;
    }

    int compareWith(@NotNull MatchResult that, boolean preferStartMatches) {
        int result2 = this.compareDegrees(that, preferStartMatches);
        return result2 != 0 ? result2 : this.elementName.compareToIgnoreCase(that.elementName);
    }

    public String toString() {
        return "MatchResult{'" + this.elementName + '\'' + ", degree=" + this.matchingDegree + ", start=" + this.startMatch + '}';
    }
}

