/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelDiff {
    @Nullable
    public static List<Cmd> createDiffCmds(@NotNull Model<Object> listModel, @NotNull Object[] oldElements, @NotNull Object[] newElements) {
        Diff.Change change = null;
        try {
            change = Diff.buildChanges((Object[])oldElements, (Object[])newElements);
        }
        catch (FilesTooBigForDiffException filesTooBigForDiffException) {
            // empty catch block
        }
        if (change == null) {
            return null;
        }
        ArrayList<Cmd> commands = new ArrayList<Cmd>();
        int inserted = 0;
        int deleted = 0;
        while (change != null) {
            if (change.deleted > 0) {
                int start2 = change.line0 + inserted - deleted;
                commands.add(new RemoveCmd(listModel, start2, start2 + change.deleted - 1));
            }
            if (change.inserted > 0) {
                ArrayList<Object> elements = new ArrayList<Object>(Arrays.asList(newElements).subList(change.line1, change.line1 + change.inserted));
                commands.add(new InsertCmd(listModel, change.line0 + inserted - deleted, elements));
            }
            deleted += change.deleted;
            inserted += change.inserted;
            change = change.link;
        }
        return commands;
    }

    private static class InsertCmd<T>
    implements Cmd {
        private final Model<T> myListModel;
        private final int idx;
        private final List<T> elements;

        private InsertCmd(@NotNull Model<T> model, int idx, @NotNull List<T> elements) {
            this.myListModel = model;
            this.idx = idx;
            this.elements = elements;
        }

        @Override
        public void apply() {
            this.myListModel.addAllToModel(this.idx, this.elements);
        }

        @Override
        public int translateSelection(int row2) {
            return this.idx > row2 ? row2 : row2 + this.elements.size();
        }

        public String toString() {
            return "+[" + this.idx + "]";
        }
    }

    private static class RemoveCmd<T>
    implements Cmd {
        private final Model<T> myListModel;
        private final int start;
        private final int end;

        private RemoveCmd(@NotNull Model<T> model, int start2, int end) {
            this.myListModel = model;
            this.start = start2;
            this.end = end;
        }

        @Override
        public void apply() {
            this.myListModel.removeRangeFromModel(this.start, this.end);
        }

        @Override
        public int translateSelection(int row2) {
            if (row2 < this.start) {
                return row2;
            }
            if (row2 >= this.end) {
                return row2 - (this.end - this.start);
            }
            return this.start - 1;
        }

        public String toString() {
            return "-[" + this.start + ", " + this.end + "]";
        }
    }

    public static interface Model<T> {
        public void addToModel(int var1, T var2);

        default public void addAllToModel(int index, List<T> elements) {
            for (int i = 0; i < elements.size(); ++i) {
                this.addToModel(index + i, elements.get(i));
            }
        }

        public void removeRangeFromModel(int var1, int var2);
    }

    public static interface Cmd {
        public void apply();

        public int translateSelection(int var1);
    }
}

