/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProjectBaseDirNavigationContributor
implements ChooseByNameContributor,
DumbAware {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        VirtualFile[] files2 = baseDir.getChildren();
        ArrayList<String> list2 = new ArrayList<String>();
        for (VirtualFile file2 : files2) {
            if (file2.isDirectory()) continue;
            list2.add(file2.getName());
        }
        return ArrayUtil.toStringArray(list2);
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        }
        VirtualFile[] files2 = baseDir.getChildren();
        ArrayList<PsiFile> list2 = new ArrayList<PsiFile>();
        for (VirtualFile file2 : files2) {
            PsiFile psiFile;
            if (!ProjectBaseDirNavigationContributor.isEditable(file2, includeNonProjectItems) || !Comparing.strEqual((String)name, (String)file2.getName()) || (psiFile = psiManager.findFile(file2)) == null) continue;
            list2.add(psiFile);
        }
        return PsiUtilCore.toPsiFileArray(list2);
    }

    private static boolean isEditable(VirtualFile file2, boolean checkboxState) {
        FileType type = file2.getFileType();
        if (!checkboxState && type == StdFileTypes.JAVA) {
            return false;
        }
        return type != StdFileTypes.CLASS;
    }
}

