/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.BundleBase;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.WebProjectSettingsStepWrapper;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.platform.templates.TemplateProjectDirectoryGenerator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSettingsStepBase<T>
extends AbstractActionWithPanel
implements DumbAware,
Disposable {
    protected DirectoryProjectGenerator<T> myProjectGenerator;
    protected AbstractNewProjectStep.AbstractCallback myCallback;
    protected TextFieldWithBrowseButton myLocationField;
    protected File myProjectDirectory;
    protected JButton myCreateButton;
    protected JLabel myErrorLabel;
    protected NotNullLazyValue<ProjectGeneratorPeer<T>> myLazyGeneratorPeer;

    public ProjectSettingsStepBase(DirectoryProjectGenerator<T> projectGenerator, AbstractNewProjectStep.AbstractCallback callback2) {
        this.getTemplatePresentation().setIcon(projectGenerator.getLogo());
        this.getTemplatePresentation().setText(projectGenerator.getName());
        this.myProjectGenerator = projectGenerator;
        this.myCallback = callback2;
        this.myProjectDirectory = this.findSequentNonExistingUntitled();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
    }

    @Override
    public void onPanelSelected() {
        this.checkWebProjectValid();
    }

    @Override
    @NotNull
    public JButton getActionButton() {
        return this.myCreateButton;
    }

    @NotNull
    protected NotNullLazyValue<ProjectGeneratorPeer<T>> createLazyPeer() {
        return this.myProjectGenerator.createLazyPeer();
    }

    @Override
    public JPanel createPanel() {
        this.myLazyGeneratorPeer = this.createLazyPeer();
        JPanel mainPanel = new JPanel(new BorderLayout());
        JLabel label2 = this.createErrorLabel();
        JButton button2 = this.createActionButton();
        button2.addActionListener(this.createCloseActionListener());
        Disposer.register((Disposable)this, () -> UIUtil.dispose((Component)button2));
        JPanel scrollPanel = this.createAndFillContentPanel();
        this.initGeneratorListeners();
        this.registerValidators();
        JBScrollPane scrollPane = new JBScrollPane((Component)scrollPanel, 20, 31);
        scrollPane.setBorder(null);
        mainPanel.add((Component)scrollPane, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setName("BOTTOM_PANEL");
        bottomPanel.add((Component)label2, "North");
        bottomPanel.add((Component)button2, "East");
        mainPanel.add((Component)bottomPanel, "South");
        return mainPanel;
    }

    protected final JLabel createErrorLabel() {
        JLabel errorLabel = new JLabel("");
        errorLabel.setForeground((Color)JBColor.RED);
        this.myErrorLabel = errorLabel;
        return errorLabel;
    }

    protected final JButton createActionButton() {
        JButton button2 = new JButton("Create");
        button2.putClientProperty("DefaultAction", Boolean.TRUE);
        this.myCreateButton = button2;
        return button2;
    }

    @NotNull
    protected final ActionListener createCloseActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isValid = ProjectSettingsStepBase.this.checkValid();
                if (isValid && ProjectSettingsStepBase.this.myCallback != null) {
                    DialogWrapper dialog2 = DialogWrapper.findInstance((Component)ProjectSettingsStepBase.this.myCreateButton);
                    if (dialog2 != null) {
                        dialog2.close(0);
                    }
                    ProjectSettingsStepBase.this.myCallback.consume(ProjectSettingsStepBase.this, ProjectSettingsStepBase.this.getPeer());
                }
            }
        };
    }

    protected ProjectGeneratorPeer<T> getPeer() {
        return (ProjectGeneratorPeer)this.myLazyGeneratorPeer.getValue();
    }

    protected final JPanel createContentPanelWithAdvancedSettingsPanel() {
        JPanel basePanel = this.createBasePanel();
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)basePanel, "North");
        JPanel advancedSettings = this.createAdvancedSettings();
        if (advancedSettings != null) {
            scrollPanel.add((Component)advancedSettings, "Center");
        }
        return scrollPanel;
    }

    protected void initGeneratorListeners() {
        if (this.myProjectGenerator instanceof WebProjectTemplate) {
            this.getPeer().addSettingsListener(new ProjectGeneratorPeer.SettingsListener(){

                @Override
                public void stateChanged(boolean validSettings) {
                    ProjectSettingsStepBase.this.checkValid();
                }
            });
        }
    }

    protected final Icon getIcon() {
        return this.myProjectGenerator.getLogo();
    }

    protected JPanel createBasePanel() {
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 2));
        LabeledComponent<TextFieldWithBrowseButton> component = this.createLocationComponent();
        panel2.add((Component)component);
        return panel2;
    }

    protected void registerValidators() {
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ProjectSettingsStepBase.this.checkValid();
            }
        };
        this.myLocationField.getTextField().getDocument().addDocumentListener((DocumentListener)documentAdapter);
        Disposer.register((Disposable)this, () -> this.myLocationField.getTextField().getDocument().removeDocumentListener((DocumentListener)documentAdapter));
        this.checkWebProjectValid();
    }

    private void checkWebProjectValid() {
        if (this.myProjectGenerator instanceof WebProjectTemplate && !((WebProjectTemplate)this.myProjectGenerator).postponeValidation()) {
            this.checkValid();
        }
    }

    public boolean checkValid() {
        if (this.myLocationField == null) {
            return true;
        }
        String projectName = this.myLocationField.getText();
        if (projectName.trim().isEmpty()) {
            this.setErrorText("Project name can't be empty");
            return false;
        }
        String text = this.myLocationField.getText().trim();
        if (text.indexOf(36) >= 0) {
            this.setErrorText("Project directory name must not contain the $ character");
            return false;
        }
        try {
            Paths.get(text, new String[0]);
        }
        catch (InvalidPathException e) {
            this.setErrorText("Invalid project directory path");
            return false;
        }
        if (this.myProjectGenerator != null) {
            ProjectGeneratorPeer<T> peer;
            ValidationInfo validationInfo;
            String baseDirPath = this.myLocationField.getTextField().getText();
            ValidationResult validationResult = this.myProjectGenerator.validate(baseDirPath);
            ValidationInfo peerValidationResult = this.getPeer().validate();
            if (!validationResult.isOk()) {
                this.setErrorText(validationResult.getErrorMessage());
                return false;
            }
            if (peerValidationResult != null) {
                this.setErrorText(peerValidationResult.message);
                return false;
            }
            if (this.myProjectGenerator instanceof WebProjectTemplate && (validationInfo = (peer = this.getPeer()).validate()) != null) {
                this.setErrorText(validationInfo.message);
                return false;
            }
        }
        this.setErrorText(null);
        return true;
    }

    protected JPanel createAndFillContentPanel() {
        WebProjectSettingsStepWrapper settingsStep = new WebProjectSettingsStepWrapper();
        if (this.myProjectGenerator instanceof WebProjectTemplate) {
            this.getPeer().buildUI(settingsStep);
        } else if (this.myProjectGenerator instanceof TemplateProjectDirectoryGenerator) {
            ((TemplateProjectDirectoryGenerator)this.myProjectGenerator).buildUI(settingsStep);
        } else {
            return this.createContentPanelWithAdvancedSettingsPanel();
        }
        if (settingsStep.isEmpty()) {
            return this.createContentPanelWithAdvancedSettingsPanel();
        }
        JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 5));
        ArrayList labeledComponentList = ContainerUtil.newArrayList();
        labeledComponentList.add(this.createLocationComponent());
        labeledComponentList.addAll(settingsStep.getFields());
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)jPanel, "North");
        for (LabeledComponent labeledComponent : labeledComponentList) {
            labeledComponent.setLabelLocation("West");
            jPanel.add((Component)labeledComponent);
        }
        for (JComponent jComponent : settingsStep.getComponents()) {
            jPanel.add(jComponent);
        }
        UIUtil.mergeComponentsWithAnchor((Collection)labeledComponentList);
        return scrollPanel;
    }

    public void setErrorText(@Nullable String text) {
        this.myErrorLabel.setText(text);
        this.myErrorLabel.setForeground(MessageType.ERROR.getTitleForeground());
        this.myErrorLabel.setIcon(StringUtil.isEmpty((String)text) ? null : AllIcons.Actions.Lightning);
        this.myCreateButton.setEnabled(text == null);
    }

    public void setWarningText(@Nullable String text) {
        this.myErrorLabel.setText("<html>Note: " + text + "  </html>");
        this.myErrorLabel.setForeground(MessageType.WARNING.getTitleForeground());
    }

    @Nullable
    protected JPanel createAdvancedSettings() {
        JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 5));
        jPanel.add(this.getPeer().getComponent(this.myLocationField, () -> this.checkValid()));
        return jPanel;
    }

    public DirectoryProjectGenerator<T> getProjectGenerator() {
        return this.myProjectGenerator;
    }

    public final String getProjectLocation() {
        return FileUtil.expandUserHome((String)FileUtil.toSystemIndependentName((String)this.myLocationField.getText()));
    }

    public final void setLocation(@NotNull String location) {
        this.myLocationField.setText(FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)location)));
    }

    protected final LabeledComponent<TextFieldWithBrowseButton> createLocationComponent() {
        this.myLocationField = new TextFieldWithBrowseButton();
        this.myProjectDirectory = this.findSequentNonExistingUntitled();
        String projectLocation = this.myProjectDirectory.toString();
        this.myLocationField.setText(projectLocation);
        int index = projectLocation.lastIndexOf(File.separator);
        if (index > 0) {
            JTextField textField2 = this.myLocationField.getTextField();
            textField2.select(index + 1, projectLocation.length());
            textField2.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, true);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myLocationField.addBrowseFolderListener("Select Base Directory", "Select base directory for the project", null, descriptor);
        return LabeledComponent.create((JComponent)this.myLocationField, (String)BundleBase.replaceMnemonicAmpersand((String)"&Location"), (String)"West");
    }

    @NotNull
    protected File findSequentNonExistingUntitled() {
        return FileUtil.findSequentNonexistentFile((File)new File(ProjectUtil.getBaseDir()), (String)"untitled", (String)"");
    }

    public void dispose() {
    }
}

