/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserUtils {
    private static final String CURRENT_FILE_SCOPE_NAME = IdeBundle.message((String)"scope.current.file", (Object[])new Object[0]);
    private static final String OPEN_FILES_SCOPE_NAME = IdeBundle.message((String)"scope.open.files", (Object[])new Object[0]);

    private ScopeChooserUtils() {
    }

    @NotNull
    public static GlobalSearchScope findScopeByName(@NotNull Project project, @Nullable String scopeName) {
        if (scopeName == null) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        if (OPEN_FILES_SCOPE_NAME.equals(scopeName)) {
            return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopes.openFilesScope((Project)project));
        }
        if (CURRENT_FILE_SCOPE_NAME.equals(scopeName)) {
            Object[] array = FileEditorManager.getInstance((Project)project).getSelectedFiles();
            List files2 = ContainerUtil.createMaybeSingletonList((Object)ArrayUtil.getFirstElement((Object[])array));
            GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)project, (Collection)files2, (String)CURRENT_FILE_SCOPE_NAME);
            return ScopeChooserUtils.intersectWithContentScope(project, scope);
        }
        for (SearchScope scope : PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, null, false, false, false, false, true)) {
            if (!(scope instanceof GlobalSearchScope) || !scope.getDisplayName().equals(scopeName)) continue;
            if (scope instanceof ScratchesSearchScope) {
                return (ScratchesSearchScope)scope;
            }
            return ScopeChooserUtils.intersectWithContentScope(project, (GlobalSearchScope)scope);
        }
        for (SearchScope scope : ChangeListsScopesProvider.getInstance(project).getFilteredScopes()) {
            if (!scope.getName().equals(scopeName)) continue;
            return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)scope));
        }
        for (Iterator<Object> iterator : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = iterator.getEditableScopes()) {
                if (!scope.getName().equals(scopeName)) continue;
                return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)scope));
            }
        }
        if (scopeName.startsWith("Module '") && scopeName.endsWith("'")) {
            return ProjectScope.getContentScope((Project)project);
        }
        return GlobalSearchScope.EMPTY_SCOPE;
    }

    @NotNull
    private static GlobalSearchScope intersectWithContentScope(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        return scope.intersectWith(ProjectScope.getContentScope((Project)project));
    }
}

