/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.SettingsProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeStructureBase
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.AbstractTreeStructureBase");
    protected final Project myProject;

    protected AbstractTreeStructureBase(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Object[] getChildElements(@NotNull Object element) {
        List<TreeStructureProvider> providers;
        LOG.assertTrue(element instanceof AbstractTreeNode, (Object)element.getClass().getName());
        AbstractTreeNode treeNode = (AbstractTreeNode)element;
        Collection elements = treeNode.getChildren();
        if (elements.stream().anyMatch(Objects::isNull)) {
            LOG.error("node contains null child: " + treeNode + "; " + treeNode.getClass());
        }
        List<TreeStructureProvider> list2 = providers = Registry.is((String)"allow.tree.structure.provider.in.dumb.mode") ? this.getProviders() : this.getProvidersDumbAware();
        if (providers != null && !providers.isEmpty()) {
            ViewSettings settings = treeNode instanceof SettingsProvider ? ((SettingsProvider)treeNode).getSettings() : ViewSettings.DEFAULT;
            for (TreeStructureProvider provider : providers) {
                try {
                    if (!(elements = provider.modify(treeNode, elements, settings)).stream().anyMatch(Objects::isNull)) continue;
                    LOG.error("provider creates null child: " + provider);
                }
                catch (IndexNotReadyException e) {
                    LOG.debug("TreeStructureProvider.modify requires indices", (Throwable)e);
                    throw new ProcessCanceledException((Throwable)e);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        elements.forEach(node -> node.setParent(treeNode));
        return ArrayUtil.toObjectArray((Collection)elements);
    }

    public boolean isValid(@NotNull Object element) {
        return element instanceof AbstractTreeNode;
    }

    public Object getParentElement(@NotNull Object element) {
        if (element instanceof AbstractTreeNode) {
            return ((AbstractTreeNode)element).getParent();
        }
        return null;
    }

    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        return (NodeDescriptor)element;
    }

    @Nullable
    public abstract List<TreeStructureProvider> getProviders();

    @Nullable
    public Object getDataFromProviders(@NotNull List<AbstractTreeNode> selectedNodes, @NotNull String dataId) {
        List<TreeStructureProvider> providers = this.getProvidersDumbAware();
        if (!providers.isEmpty()) {
            for (TreeStructureProvider treeStructureProvider : providers) {
                Object fromProvider = treeStructureProvider.getData(selectedNodes, dataId);
                if (fromProvider == null) continue;
                return fromProvider;
            }
        }
        return null;
    }

    @NotNull
    private List<TreeStructureProvider> getProvidersDumbAware() {
        if (this.myProject == null) {
            return Collections.emptyList();
        }
        List<TreeStructureProvider> providers = this.getProviders();
        if (providers == null) {
            return Collections.emptyList();
        }
        return DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(providers);
    }
}

