/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.structureView.impl.StructureViewElementWrapper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.GroupWrapper;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class CachingChildrenTreeNode<Value>
extends AbstractTreeNode<Value> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode");
    private List<CachingChildrenTreeNode> myChildren;
    private List<CachingChildrenTreeNode> myOldChildren;
    @NotNull
    protected final TreeModel myTreeModel;

    CachingChildrenTreeNode(Project project, @NotNull Value value, @NotNull TreeModel treeModel) {
        super(project, value instanceof StructureViewElementWrapper ? ((StructureViewElementWrapper)value).getWrappedElement() : value);
        this.myTreeModel = treeModel;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        this.ensureChildrenAreInitialized();
        return new ArrayList<AbstractTreeNode>(this.myChildren);
    }

    private void ensureChildrenAreInitialized() {
        if (this.myChildren == null) {
            try {
                this.myChildren = new ArrayList<CachingChildrenTreeNode>();
                this.rebuildSubtree();
            }
            catch (ProcessCanceledException pce) {
                this.myChildren = null;
                throw pce;
            }
        }
    }

    void addSubElement(@NotNull CachingChildrenTreeNode node) {
        JBIterable parents = JBIterable.generate((Object)((Object)this), o -> o.getParent());
        if (parents.map(o -> o.getValue()).contains(node.getValue())) {
            return;
        }
        this.ensureChildrenAreInitialized();
        this.myChildren.add(node);
        node.setParent(this);
    }

    protected void setChildren(@NotNull Collection<? extends AbstractTreeNode> children2) {
        this.clearChildren();
        for (AbstractTreeNode abstractTreeNode : children2) {
            this.myChildren.add((CachingChildrenTreeNode)abstractTreeNode);
            abstractTreeNode.setParent((AbstractTreeNode)this);
        }
    }

    protected void sortChildren(@NotNull Sorter[] sorters) {
        if (this.myChildren == null) {
            return;
        }
        Collections.sort(this.myChildren, new CompositeComparator(sorters));
        for (CachingChildrenTreeNode child2 : this.myChildren) {
            if (!(child2 instanceof GroupWrapper)) continue;
            child2.sortChildren(sorters);
        }
    }

    protected void filterChildren(@NotNull Filter[] filters) {
        Collection<AbstractTreeNode> children2 = this.getChildren();
        for (Filter filter : filters) {
            Iterator<AbstractTreeNode> eachNode = children2.iterator();
            while (eachNode.hasNext()) {
                AbstractTreeNode eachChild = eachNode.next();
                Object value = eachChild.getValue();
                if (value instanceof TreeElement && filter.isVisible((TreeElement)value)) continue;
                eachNode.remove();
            }
        }
        this.setChildren(children2);
    }

    void groupChildren(@NotNull Grouper[] groupers) {
        for (Grouper grouper : groupers) {
            this.groupElements(grouper);
        }
        Collection<AbstractTreeNode> children2 = this.getChildren();
        for (AbstractTreeNode child2 : children2) {
            if (!(child2 instanceof GroupWrapper)) continue;
            ((GroupWrapper)child2).groupChildren(groupers);
        }
    }

    private void groupElements(@NotNull Grouper grouper) {
        ArrayList<AbstractTreeNode> ungrouped = new ArrayList<AbstractTreeNode>();
        Collection<AbstractTreeNode> children2 = this.getChildren();
        for (AbstractTreeNode child2 : children2) {
            if (!(child2 instanceof TreeElementWrapper)) continue;
            ungrouped.add(child2);
        }
        if (!ungrouped.isEmpty()) {
            this.processUngrouped(ungrouped, grouper);
        }
        LinkedHashSet<AbstractTreeNode> result2 = new LinkedHashSet<AbstractTreeNode>();
        for (AbstractTreeNode child3 : children2) {
            AbstractTreeNode parent = child3.getParent();
            if (parent != this) {
                if (result2.contains(parent)) continue;
                result2.add(parent);
                continue;
            }
            result2.add(child3);
        }
        this.setChildren(result2);
    }

    private void processUngrouped(@NotNull List<? extends AbstractTreeNode<TreeElement>> ungrouped, @NotNull Grouper grouper) {
        Map<TreeElement, AbstractTreeNode> ungroupedObjects = CachingChildrenTreeNode.collectValues(ungrouped);
        Collection groups = grouper.group((AbstractTreeNode)this, ungroupedObjects.keySet());
        Map<Group, GroupWrapper> groupNodes = this.createGroupNodes(groups);
        for (Group group : groups) {
            if (group == null) {
                LOG.error(grouper + " returned null group: " + groups);
            }
            GroupWrapper groupWrapper = groupNodes.get(group);
            Collection children2 = group.getChildren();
            for (TreeElement node : children2) {
                if (node == null) {
                    LOG.error(group + " returned null child: " + children2);
                }
                TreeElementWrapper child2 = this.createChildNode(node);
                groupWrapper.addSubElement(child2);
                AbstractTreeNode abstractTreeNode = ungroupedObjects.get(node);
                abstractTreeNode.setParent((AbstractTreeNode)groupWrapper);
            }
        }
    }

    @NotNull
    protected TreeElementWrapper createChildNode(@NotNull TreeElement child2) {
        return new TreeElementWrapper(this.getProject(), child2, this.myTreeModel);
    }

    @NotNull
    private static Map<TreeElement, AbstractTreeNode> collectValues(@NotNull List<? extends AbstractTreeNode<TreeElement>> ungrouped) {
        LinkedHashMap<TreeElement, AbstractTreeNode> objects = new LinkedHashMap<TreeElement, AbstractTreeNode>();
        for (AbstractTreeNode<TreeElement> abstractTreeNode : ungrouped) {
            objects.put((TreeElement)abstractTreeNode.getValue(), abstractTreeNode);
        }
        return objects;
    }

    @NotNull
    private Map<Group, GroupWrapper> createGroupNodes(@NotNull Collection<? extends Group> groups) {
        THashMap result2 = new THashMap();
        for (Group group : groups) {
            result2.put(group, this.createGroupWrapper(this.getProject(), group, this.myTreeModel));
        }
        return result2;
    }

    @NotNull
    protected GroupWrapper createGroupWrapper(Project project, @NotNull Group group, @NotNull TreeModel treeModel) {
        return new GroupWrapper(project, group, treeModel);
    }

    private void rebuildSubtree() {
        this.initChildren();
        this.performTreeActions();
        this.synchronizeChildren();
    }

    void synchronizeChildren() {
        List<CachingChildrenTreeNode> children2 = this.myChildren;
        if (this.myOldChildren != null && children2 != null) {
            HashMap<CachingChildrenTreeNode, CachingChildrenTreeNode> oldValuesToChildrenMap = new HashMap<CachingChildrenTreeNode, CachingChildrenTreeNode>();
            for (CachingChildrenTreeNode oldChild : this.myOldChildren) {
                Object oldValue = oldChild instanceof TreeElementWrapper ? oldChild.getValue() : oldChild;
                if (oldValue == null) continue;
                oldValuesToChildrenMap.put((CachingChildrenTreeNode)((Object)oldValue), oldChild);
            }
            for (int i = 0; i < children2.size(); ++i) {
                CachingChildrenTreeNode oldChild;
                Object newValue;
                CachingChildrenTreeNode newChild = children2.get(i);
                Object object = newValue = newChild instanceof TreeElementWrapper ? newChild.getValue() : newChild;
                if (newValue == null || (oldChild = (CachingChildrenTreeNode)((Object)oldValuesToChildrenMap.get(newValue))) == null) continue;
                oldChild.copyFromNewInstance(newChild);
                oldChild.setValue(newChild.getValue());
                children2.set(i, oldChild);
            }
            this.myOldChildren = null;
        }
    }

    protected abstract void copyFromNewInstance(@NotNull CachingChildrenTreeNode var1);

    protected abstract void performTreeActions();

    protected abstract void initChildren();

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.getValue()).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigateToSource();
    }

    protected void clearChildren() {
        if (this.myChildren != null) {
            this.myChildren.clear();
        } else {
            this.myChildren = new ArrayList<CachingChildrenTreeNode>();
        }
    }

    void rebuildChildren() {
        if (this.myChildren != null) {
            this.myOldChildren = this.myChildren;
            for (CachingChildrenTreeNode node : this.myChildren) {
                node.rebuildChildren();
            }
            this.myChildren = null;
        }
    }

    protected void resetChildren() {
        this.myChildren = null;
    }

    private static class CompositeComparator
    implements Comparator<CachingChildrenTreeNode> {
        private final Sorter[] mySorters;

        CompositeComparator(@NotNull Sorter[] sorters) {
            this.mySorters = sorters;
        }

        @Override
        public int compare(CachingChildrenTreeNode o1, CachingChildrenTreeNode o2) {
            Object value1 = o1.getValue();
            Object value2 = o2.getValue();
            for (Sorter sorter : this.mySorters) {
                int result2 = sorter.getComparator().compare(value1, value2);
                if (result2 == 0) continue;
                return result2;
            }
            return 0;
        }
    }
}

