/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TreeElementWrapper
extends CachingChildrenTreeNode<TreeElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.smartTree.TreeElementWrapper");

    public TreeElementWrapper(Project project, @NotNull TreeElement value, @NotNull TreeModel treeModel) {
        super(project, value, treeModel);
    }

    @Override
    public void copyFromNewInstance(@NotNull CachingChildrenTreeNode oldInstance) {
    }

    public void update(@NotNull PresentationData presentation) {
        if (((StructureViewTreeElement)this.getValue()).getValue() != null) {
            presentation.updateFrom(((TreeElement)this.getValue()).getPresentation());
        }
    }

    @Override
    public void initChildren() {
        Object[] children2;
        this.clearChildren();
        TreeElement value = (TreeElement)this.getValue();
        for (TreeElement treeElement : children2 = value.getChildren()) {
            if (treeElement == null) {
                LOG.error(value + " returned null child: " + Arrays.toString(children2));
            }
            this.addSubElement(this.createChildNode(treeElement));
        }
        if (this.myTreeModel instanceof ProvidingTreeModel) {
            Collection originalProviders = ((ProvidingTreeModel)this.myTreeModel).getNodeProviders();
            List providers = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(originalProviders);
            for (NodeProvider nodeProvider : providers) {
                if (!((ProvidingTreeModel)this.myTreeModel).isEnabled(nodeProvider)) continue;
                Collection nodes = nodeProvider.provideNodes(value);
                for (TreeElement node : nodes) {
                    if (node == null) {
                        LOG.error(nodeProvider + " returned null node: " + nodes);
                    }
                    this.addSubElement(this.createChildNode(node));
                }
            }
        }
    }

    @Override
    protected void performTreeActions() {
        this.filterChildren(this.myTreeModel.getFilters());
        this.groupChildren(this.myTreeModel.getGroupers());
        this.sortChildren(this.myTreeModel.getSorters());
    }
}

