/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.LogMessage;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.ApplicationInfoProvider;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.log4j.DefaultThrowableRenderer;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.ThrowableRenderer;
import org.apache.log4j.spi.ThrowableRendererSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaLogger
extends Log4jBasedLogger {
    public static String ourLastActionId = "";
    public static Exception ourErrorsOccurred;
    private static final ApplicationInfoProvider ourApplicationInfoProvider;
    private static final String ourCompilationTimestamp;
    private static final ThrowableRenderer ourThrowableRenderer;

    @Nullable
    public static String getOurCompilationTimestamp() {
        return ourCompilationTimestamp;
    }

    @NotNull
    public static ThrowableRenderer getThrowableRenderer() {
        return ourThrowableRenderer;
    }

    IdeaLogger(@NotNull Logger logger) {
        super(logger);
        LoggerRepository repository = this.myLogger.getLoggerRepository();
        if (repository instanceof ThrowableRendererSupport) {
            ((ThrowableRendererSupport)repository).setThrowableRenderer(ourThrowableRenderer);
        }
    }

    public void error(Object message) {
        if (message instanceof IdeaLoggingEvent) {
            this.myLogger.error(message);
        } else {
            super.error(message);
        }
    }

    public void error(String message, @Nullable Throwable t, Attachment ... attachments) {
        this.myLogger.error((Object)LogMessage.createEvent(t != null ? t : new Throwable(), message, attachments));
    }

    public void warn(String message, @Nullable Throwable t) {
        super.warn(message, IdeaLogger.checkException((Throwable)t));
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        String detailString;
        if (t instanceof ControlFlowException) {
            this.myLogger.error((Object)message, IdeaLogger.checkException((Throwable)t));
            ExceptionUtil.rethrow((Throwable)t);
        }
        if (!(detailString = StringUtil.join((String[])details, (String)"\n")).isEmpty()) {
            detailString = "\nDetails: " + detailString;
        }
        if (ourErrorsOccurred == null) {
            String mess = "Logger errors occurred. See IDEA logs for details. " + (StringUtil.isEmpty((String)message) ? "" : "Error message is '" + message + "'");
            ourErrorsOccurred = new Exception(mess + detailString, t);
        }
        this.myLogger.error((Object)(message + detailString), t);
        this.logErrorHeader(t);
    }

    private void logErrorHeader(@Nullable Throwable t) {
        ApplicationImpl application;
        IdeaPluginDescriptor plugin;
        this.myLogger.error((Object)ourApplicationInfoProvider.getInfo());
        if (ourCompilationTimestamp != null) {
            this.myLogger.error((Object)("Internal version. Compiled " + ourCompilationTimestamp));
        }
        this.myLogger.error((Object)("JDK: " + System.getProperties().getProperty("java.version", "unknown") + "; VM: " + System.getProperties().getProperty("java.vm.name", "unknown") + "; Vendor: " + System.getProperties().getProperty("java.vendor", "unknown")));
        this.myLogger.error((Object)("OS: " + System.getProperties().getProperty("os.name", "unknown")));
        IdeaPluginDescriptor ideaPluginDescriptor = plugin = t == null ? null : PluginManager.findPluginIfInitialized(t);
        if (plugin != null && (!plugin.isBundled() || plugin.allowBundledUpdate())) {
            this.myLogger.error((Object)("Plugin to blame: " + plugin.getName() + " version: " + plugin.getVersion()));
        }
        if ((application = (ApplicationImpl)ApplicationManager.getApplication()) != null && application.isComponentsCreated() && !application.isDisposed()) {
            String currentCommandName;
            CommandProcessor commandProcessor;
            String lastPreformedActionId = ourLastActionId;
            if (lastPreformedActionId != null) {
                this.myLogger.error((Object)("Last Action: " + lastPreformedActionId));
            }
            if ((commandProcessor = CommandProcessor.getInstance()) != null && (currentCommandName = commandProcessor.getCurrentCommandName()) != null) {
                this.myLogger.error((Object)("Current Command: " + currentCommandName));
            }
        }
    }

    static {
        ourApplicationInfoProvider = () -> {
            ApplicationInfoEx info = ApplicationInfoImpl.getShadowInstance();
            return info.getFullApplicationName() + "  Build #" + info.getBuild().asString();
        };
        String stamp = null;
        URL resource = com.intellij.openapi.diagnostic.Logger.class.getResource("/.compilation-timestamp");
        if (resource != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream()));){
                String s = reader.readLine();
                if (s != null) {
                    stamp = s.trim();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ourCompilationTimestamp = stamp;
        ourThrowableRenderer = t -> {
            int maxExtraSize;
            int maxStackSize;
            String[] lines2 = DefaultThrowableRenderer.render((Throwable)t);
            if (lines2.length > (maxStackSize = 1024) + (maxExtraSize = 256)) {
                String[] res2 = new String[maxStackSize + maxExtraSize + 1];
                System.arraycopy(lines2, 0, res2, 0, maxStackSize);
                res2[maxStackSize] = "\t...";
                System.arraycopy(lines2, lines2.length - maxExtraSize, res2, maxStackSize + 1, maxExtraSize);
                return res2;
            }
            return lines2;
        };
    }
}

