/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharSequenceReader;
import java.io.File;
import java.io.Reader;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jdom.Document;
import org.jdom.output.DOMOutputter;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class LoggerFactory
implements Logger.Factory {
    private static final String SYSTEM_MACRO = "$SYSTEM_DIR$";
    private static final String APPLICATION_MACRO = "$APPLICATION_DIR$";
    private static final String LOG_DIR_MACRO = "$LOG_DIR$";
    private boolean myInitialized = false;

    private LoggerFactory() {
    }

    @NotNull
    public synchronized com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String name) {
        try {
            if (!this.myInitialized) {
                this.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new IdeaLogger(Logger.getLogger((String)name));
    }

    private void init() {
        try {
            System.setProperty("log4j.defaultInitOverride", "true");
            File logXmlFile = PathManager.getLogFile();
            String text = FileUtilRt.loadFile((File)logXmlFile);
            text = StringUtil.replace((String)text, (String)SYSTEM_MACRO, (String)StringUtil.replace((String)PathManager.getSystemPath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)APPLICATION_MACRO, (String)StringUtil.replace((String)PathManager.getHomePath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)LOG_DIR_MACRO, (String)StringUtil.replace((String)PathManager.getLogPath(), (String)"\\", (String)"\\\\"));
            File file2 = new File(PathManager.getLogPath());
            if (!file2.mkdirs() && !file2.exists()) {
                System.err.println("Cannot create log directory: " + file2);
            }
            Document document = JDOMUtil.loadDocument((Reader)new CharSequenceReader((CharSequence)text));
            Element element = new DOMOutputter().output(document).getDocumentElement();
            new DOMConfigurator().doConfigure(element, LogManager.getLoggerRepository());
            this.myInitialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

