/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.MessageDecoder;

public final class SocketLock {
    private static final String PORT_FILE = "port";
    private static final String PORT_LOCK_FILE = "port.lock";
    private static final String TOKEN_FILE = "token";
    private static final String ACTIVATE_COMMAND = "activate ";
    private static final String PID_COMMAND = "pid";
    private static final String PATHS_EOT_RESPONSE = "---";
    private static final String OK_RESPONSE = "ok";
    private final String myConfigPath;
    private final String mySystemPath;
    private final AtomicReference<Consumer<List<String>>> myActivateListener = new AtomicReference();
    private String myToken;
    private BuiltInServer myServer;

    public SocketLock(@NotNull String configPath, @NotNull String systemPath) {
        this.myConfigPath = SocketLock.canonicalPath(configPath);
        this.mySystemPath = SocketLock.canonicalPath(systemPath);
        if (FileUtil.pathsEqual((String)this.myConfigPath, (String)this.mySystemPath)) {
            throw new IllegalArgumentException("'config' and 'system' paths should point to different directories");
        }
    }

    public void setExternalInstanceListener(@Nullable Consumer<List<String>> consumer) {
        this.myActivateListener.set(consumer);
    }

    public void dispose() {
        SocketLock.log("enter: dispose()", new Object[0]);
        BuiltInServer server = this.myServer;
        if (server == null) {
            return;
        }
        try {
            Disposer.dispose((Disposable)server);
        }
        finally {
            try {
                this.underLocks(() -> {
                    FileUtil.delete((File)new File(this.myConfigPath, PORT_FILE));
                    FileUtil.delete((File)new File(this.mySystemPath, PORT_FILE));
                    FileUtil.delete((File)new File(this.mySystemPath, TOKEN_FILE));
                    return null;
                });
            }
            catch (Exception e) {
                Logger.getInstance(SocketLock.class).warn((Throwable)e);
            }
        }
    }

    @Nullable
    public BuiltInServer getServer() {
        return this.myServer;
    }

    @NotNull
    public ActivateStatus lock() throws Exception {
        return this.lock(ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @NotNull
    public ActivateStatus lock(@NotNull String[] args) throws Exception {
        SocketLock.log("enter: lock(config=%s system=%s)", this.myConfigPath, this.mySystemPath);
        return this.underLocks(() -> {
            File portMarkerC = new File(this.myConfigPath, PORT_FILE);
            File portMarkerS = new File(this.mySystemPath, PORT_FILE);
            MultiMap portToPath = MultiMap.createSmart();
            SocketLock.addExistingPort(portMarkerC, this.myConfigPath, (MultiMap<Integer, String>)portToPath);
            SocketLock.addExistingPort(portMarkerS, this.mySystemPath, (MultiMap<Integer, String>)portToPath);
            if (!portToPath.isEmpty()) {
                for (Map.Entry entry : portToPath.entrySet()) {
                    ActivateStatus status = this.tryActivate((Integer)entry.getKey(), (Collection)entry.getValue(), args);
                    if (status == ActivateStatus.NO_INSTANCE) continue;
                    SocketLock.log("exit: lock(): " + (Object)((Object)status), new Object[0]);
                    return status;
                }
            }
            if (SocketLock.isShutdownCommand()) {
                System.exit(0);
            }
            this.myToken = UUID.randomUUID().toString();
            String[] lockedPaths = new String[]{this.myConfigPath, this.mySystemPath};
            NotNullProducer handler2 = () -> new MyChannelInboundHandler(lockedPaths, this.myActivateListener, this.myToken);
            this.myServer = BuiltInServer.startNioOrOio(2, 6942, 50, false, (NotNullProducer<? extends ChannelHandler>)handler2);
            byte[] portBytes = Integer.toString(this.myServer.getPort()).getBytes(StandardCharsets.UTF_8);
            FileUtil.writeToFile((File)portMarkerC, (byte[])portBytes);
            FileUtil.writeToFile((File)portMarkerS, (byte[])portBytes);
            Path tokenFile = Paths.get(this.mySystemPath, TOKEN_FILE);
            Files.write(tokenFile, this.myToken.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            PosixFileAttributeView view = Files.getFileAttributeView(tokenFile, PosixFileAttributeView.class, new LinkOption[0]);
            if (view != null) {
                try {
                    view.setPermissions(ContainerUtil.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE}));
                }
                catch (IOException e) {
                    SocketLock.log(e);
                }
            }
            SocketLock.log("exit: lock(): succeed", new Object[0]);
            return ActivateStatus.NO_INSTANCE;
        });
    }

    /*
     * Exception decompiling
     */
    private <V> V underLocks(@NotNull Callable<V> action) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void addExistingPort(@NotNull File portMarker, @NotNull String path, @NotNull MultiMap<Integer, String> portToPath) {
        if (portMarker.exists()) {
            try {
                portToPath.putValue((Object)Integer.parseInt(FileUtilRt.loadFile((File)portMarker)), (Object)path);
            }
            catch (Exception e) {
                SocketLock.log(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ActivateStatus tryActivate(int portNumber, @NotNull Collection<String> paths, @NotNull String[] args) {
        DataInputStream in;
        boolean result2;
        Throwable throwable;
        Socket socket;
        block26: {
            block25: {
                SocketLock.log("trying: port=%s", portNumber);
                args = SocketLock.checkForJetBrainsProtocolCommand(args);
                try {
                    socket = new Socket(InetAddress.getLoopbackAddress(), portNumber);
                    throwable = null;
                    try {
                        socket.setSoTimeout(5000);
                        result2 = false;
                        in = new DataInputStream(socket.getInputStream());
                        try {}
                        catch (IOException e) {
                            SocketLock.log("read: %s", e.getMessage());
                            break block26;
                        }
                        break block25;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (ConnectException e) {
                    SocketLock.log("%s (stale port file?)", e.getMessage());
                    return ActivateStatus.NO_INSTANCE;
                }
                catch (IOException e) {
                    SocketLock.log(e);
                }
                return ActivateStatus.NO_INSTANCE;
            }
            while (true) {
                String path = in.readUTF();
                SocketLock.log("read: path=%s", path);
                if (PATHS_EOT_RESPONSE.equals(path)) break;
                if (!paths.contains(path)) continue;
                result2 = true;
            }
        }
        if (!result2) return ActivateStatus.NO_INSTANCE;
        try {
            String token = FileUtil.loadFile((File)new File(this.mySystemPath, TOKEN_FILE));
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeUTF(ACTIVATE_COMMAND + token + "\u0000" + new File(".").getAbsolutePath() + "\u0000" + StringUtil.join((String[])args, (String)"\u0000"));
            out.flush();
            String response = in.readUTF();
            SocketLock.log("read: response=%s", response);
            if (!response.equals(OK_RESPONSE)) return ActivateStatus.CANNOT_ACTIVATE;
            if (!SocketLock.isShutdownCommand()) return ActivateStatus.ACTIVATED;
            SocketLock.printPID(portNumber);
            return ActivateStatus.ACTIVATED;
        }
        catch (IOException e) {
            SocketLock.log(e);
        }
        return ActivateStatus.CANNOT_ACTIVATE;
        finally {
            if (socket != null) {
                if (throwable != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    socket.close();
                }
            }
        }
    }

    private static void printPID(int port) {
        try {
            Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
            socket.setSoTimeout(1000);
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeUTF(PID_COMMAND);
            DataInputStream in = new DataInputStream(socket.getInputStream());
            int pid = 0;
            try {
                while (true) {
                    String s;
                    if (!Pattern.matches("[0-9]+@.*", s = in.readUTF())) {
                        continue;
                    }
                    pid = Integer.parseInt(s.substring(0, s.indexOf(64)));
                    System.err.println(pid);
                }
            }
            catch (IOException e) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isShutdownCommand() {
        return "shutdown".equals(JetBrainsProtocolHandler.getCommand());
    }

    private static String[] checkForJetBrainsProtocolCommand(String[] args) {
        String jbUrl = System.getProperty(JetBrainsProtocolHandler.class.getName());
        if (jbUrl != null) {
            return new String[]{jbUrl};
        }
        return args;
    }

    @NotNull
    private static String canonicalPath(@NotNull String configPath) {
        try {
            return new File(configPath).getCanonicalPath();
        }
        catch (IOException ignore) {
            return configPath;
        }
    }

    private static void log(Exception e) {
        Logger.getInstance(SocketLock.class).warn((Throwable)e);
    }

    private static void log(String format, Object ... args) {
        Logger logger = Logger.getInstance(SocketLock.class);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(format, args));
        }
    }

    static /* synthetic */ void access$000(Exception x0) {
        SocketLock.log(x0);
    }

    private static class MyChannelInboundHandler
    extends MessageDecoder {
        private final String[] myLockedPaths;
        private final AtomicReference<? extends Consumer<List<String>>> myActivateListener;
        private final String myToken;
        private State myState = State.HEADER;

        MyChannelInboundHandler(@NotNull String[] lockedPaths, @NotNull AtomicReference<? extends Consumer<List<String>>> activateListener, @NotNull String token) {
            this.myLockedPaths = lockedPaths;
            this.myActivateListener = activateListener;
            this.myToken = token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelActive(ChannelHandlerContext context) throws Exception {
            ByteBuf buffer = context.alloc().ioBuffer(1024);
            boolean success2 = false;
            try (ByteBufOutputStream out = new ByteBufOutputStream(buffer);){
                for (String path : this.myLockedPaths) {
                    out.writeUTF(path);
                }
                out.writeUTF(SocketLock.PATHS_EOT_RESPONSE);
                success2 = true;
            }
            finally {
                if (!success2) {
                    buffer.release();
                }
            }
            context.writeAndFlush((Object)buffer);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
            while (true) {
                switch (1.$SwitchMap$com$intellij$idea$SocketLock$MyChannelInboundHandler$State[this.myState.ordinal()]) {
                    case 1: {
                        buffer = this.getBufferIfSufficient(input, 2, context);
                        if (buffer == null) {
                            return;
                        }
                        this.contentLength = buffer.readUnsignedShort();
                        if (this.contentLength > 8192) {
                            context.close();
                            return;
                        }
                        this.myState = State.CONTENT;
                        break;
                    }
                    case 2: {
                        command = this.readChars(input);
                        if (command == null) {
                            return;
                        }
                        if (!StringUtil.startsWith((CharSequence)command, (CharSequence)"pid")) ** GOTO lbl42
                        buffer = context.alloc().ioBuffer();
                        out = new ByteBufOutputStream(buffer);
                        var6_6 = null;
                        try {
                            name = ManagementFactory.getRuntimeMXBean().getName();
                            out.writeUTF(name);
                        }
                        catch (Throwable name) {
                            var6_6 = name;
                            throw name;
                        }
                        finally {
                            if (out != null) {
                                if (var6_6 != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (Throwable name) {
                                        var6_6.addSuppressed(name);
                                    }
                                } else {
                                    out.close();
                                }
                            }
                        }
                        context.writeAndFlush((Object)buffer);
lbl42:
                        // 2 sources

                        if (!StringUtil.startsWith((CharSequence)command, (CharSequence)"activate ")) ** GOTO lbl74
                        args = StringUtil.split((String)data, (String)((data = command.subSequence("activate ".length(), command.length()).toString()).contains("\u0000") != false ? "\u0000" : "\ufffd"));
                        v0 = tokenOK = args.isEmpty() == false && this.myToken.equals(args.get(0)) != false;
                        if (!tokenOK) {
                            SocketLock.access$000(new UnsupportedOperationException("unauthorized request: " + command));
                            Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"activation.auth.title", (Object[])new Object[0]), IdeBundle.message((String)"activation.auth.message", (Object[])new Object[0]), NotificationType.WARNING));
                        } else {
                            listener = this.myActivateListener.get();
                            if (listener != null) {
                                listener.consume(args.subList(1, args.size()));
                            }
                        }
                        buffer = context.alloc().ioBuffer(4);
                        out = new ByteBufOutputStream(buffer);
                        var9_13 = null;
                        try {
                            out.writeUTF("ok");
                        }
                        catch (Throwable var10_16) {
                            var9_13 = var10_16;
                            throw var10_16;
                        }
                        finally {
                            if (out != null) {
                                if (var9_13 != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (Throwable var10_15) {
                                        var9_13.addSuppressed(var10_15);
                                    }
                                } else {
                                    out.close();
                                }
                            }
                        }
                        context.writeAndFlush((Object)buffer);
lbl74:
                        // 2 sources

                        context.close();
                    }
                }
            }
        }

        private static enum State {
            HEADER,
            CONTENT;

        }
    }

    public static enum ActivateStatus {
        ACTIVATED,
        NO_INSTANCE,
        CANNOT_ACTIVATE;

    }
}

