/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.conversion.impl.ProjectConversionUtil;
import com.intellij.conversion.impl.ui.ConvertProjectDialog;
import com.intellij.ide.IdeBundle;
import com.intellij.impl.ConversionResultImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ConversionServiceImpl
extends ConversionService {
    private static final Logger LOG = Logger.getInstance(ConversionServiceImpl.class);

    @Override
    @NotNull
    public ConversionResult convertSilently(@NotNull String projectPath) {
        return this.convertSilently(projectPath, new ConversionListener(){

            @Override
            public void conversionNeeded() {
            }

            @Override
            public void successfullyConverted(@NotNull File backupDir) {
            }

            @Override
            public void error(@NotNull String message) {
            }

            @Override
            public void cannotWriteToFiles(@NotNull List<? extends File> readonlyFiles) {
            }
        });
    }

    @Override
    @NotNull
    public ConversionResult convertSilently(@NotNull String projectPath, @NotNull ConversionListener listener2) {
        try {
            if (!ConversionServiceImpl.isConversionNeeded(projectPath)) {
                return ConversionResultImpl.CONVERSION_NOT_NEEDED;
            }
            listener2.conversionNeeded();
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> runners = ConversionServiceImpl.getConversionRunners(context);
            HashSet<File> affectedFiles2 = new HashSet<File>();
            for (ConversionRunner runner : runners) {
                affectedFiles2.addAll(runner.getAffectedFiles());
            }
            List<File> readOnlyFiles = ConversionRunner.getReadOnlyFiles(affectedFiles2);
            if (!readOnlyFiles.isEmpty()) {
                listener2.cannotWriteToFiles(readOnlyFiles);
                return ConversionResultImpl.ERROR_OCCURRED;
            }
            File backupDir = ProjectConversionUtil.backupFiles(affectedFiles2, context.getProjectBaseDir());
            ArrayList<ConversionRunner> usedRunners = new ArrayList<ConversionRunner>();
            for (ConversionRunner runner : runners) {
                if (!runner.isConversionNeeded()) continue;
                runner.preProcess();
                runner.process();
                runner.postProcess();
                usedRunners.add(runner);
            }
            context.saveFiles(affectedFiles2, usedRunners);
            listener2.successfullyConverted(backupDir);
            ConversionServiceImpl.saveConversionResult(context);
            return new ConversionResultImpl(runners);
        }
        catch (CannotConvertException | IOException e) {
            listener2.error(e.getMessage());
            return ConversionResultImpl.ERROR_OCCURRED;
        }
    }

    @Override
    @NotNull
    public ConversionResult convert(@NotNull String projectPath) {
        try {
            if (!new File(projectPath).exists() || ApplicationManager.getApplication().isHeadlessEnvironment() || !ConversionServiceImpl.isConversionNeeded(projectPath)) {
                return ConversionResultImpl.CONVERSION_NOT_NEEDED;
            }
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> converters2 = ConversionServiceImpl.getConversionRunners(context);
            ConvertProjectDialog dialog2 = new ConvertProjectDialog(context, converters2);
            dialog2.show();
            if (dialog2.isConverted()) {
                ConversionServiceImpl.saveConversionResult(context);
                return new ConversionResultImpl(converters2);
            }
            return ConversionResultImpl.CONVERSION_CANCELED;
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.convert.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.convert.project", (Object[])new Object[0]));
            return ConversionResultImpl.ERROR_OCCURRED;
        }
    }

    private static List<ConversionRunner> getConversionRunners(ConversionContextImpl context) throws CannotConvertException {
        List<ConversionRunner> converters2 = ConversionServiceImpl.getSortedConverters(context);
        Iterator<ConversionRunner> iterator = converters2.iterator();
        HashSet<String> convertersToRunIds = new HashSet<String>();
        while (iterator.hasNext()) {
            ConversionRunner runner = iterator.next();
            boolean conversionNeeded = runner.isConversionNeeded();
            if (!conversionNeeded) {
                for (String id : runner.getProvider().getPrecedingConverterIds()) {
                    if (!convertersToRunIds.contains(id)) continue;
                    conversionNeeded = true;
                    break;
                }
            }
            if (conversionNeeded) {
                convertersToRunIds.add(runner.getProvider().getId());
                continue;
            }
            iterator.remove();
        }
        return converters2;
    }

    public static boolean isConversionNeeded(String projectPath) {
        try {
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> runners = ConversionServiceImpl.getSortedConverters(context);
            if (runners.isEmpty()) {
                return false;
            }
            for (ConversionRunner runner : runners) {
                if (!runner.isConversionNeeded()) continue;
                return true;
            }
            ConversionServiceImpl.saveConversionResult(context);
        }
        catch (CannotConvertException e) {
            LOG.info("Cannot check whether conversion of project files is needed or not, conversion won't be performed", (Throwable)e);
        }
        return false;
    }

    private static List<ConversionRunner> getSortedConverters(ConversionContextImpl context) {
        Set<String> performedConversionIds;
        CachedConversionResult conversionResult = ConversionServiceImpl.loadCachedConversionResult(context.getProjectFile());
        Map<String, Long> oldMap = conversionResult.myProjectFilesTimestamps;
        Map<String, Long> newMap = ConversionServiceImpl.getProjectFilesMap(context);
        boolean changed = false;
        LOG.debug("Checking project files");
        for (Map.Entry<String, Long> entry : newMap.entrySet()) {
            String path = entry.getKey();
            Long oldValue = oldMap.get(path);
            if (oldValue == null) {
                LOG.debug(" new file: " + path);
                changed = true;
                continue;
            }
            if (entry.getValue().equals(oldValue)) continue;
            LOG.debug(" changed file: " + path);
            changed = true;
        }
        if (changed) {
            performedConversionIds = Collections.emptySet();
            LOG.debug("Project files were modified.");
        } else {
            performedConversionIds = conversionResult.myAppliedConverters;
            LOG.debug("Project files are up to date. Applied converters: " + performedConversionIds);
        }
        return ConversionServiceImpl.createConversionRunners(context, performedConversionIds);
    }

    private static Map<String, Long> getProjectFilesMap(ConversionContextImpl context) {
        HashMap<String, Long> map2 = new HashMap<String, Long>();
        for (File file2 : context.getAllProjectFiles()) {
            if (!file2.exists()) continue;
            map2.put(file2.getAbsolutePath(), file2.lastModified());
        }
        return map2;
    }

    private static List<ConversionRunner> createConversionRunners(ConversionContextImpl context, Set<String> performedConversionIds) {
        ConverterProvider[] providers;
        ArrayList<ConversionRunner> runners = new ArrayList<ConversionRunner>();
        for (ConverterProvider provider : providers = (ConverterProvider[])ConverterProvider.EP_NAME.getExtensions()) {
            if (performedConversionIds.contains(provider.getId())) continue;
            runners.add(new ConversionRunner(provider, context));
        }
        Graph graph2 = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new ConverterProvidersGraph(providers)));
        DFSTBuilder builder2 = new DFSTBuilder(graph2);
        if (!builder2.isAcyclic()) {
            Couple pair = builder2.getCircularDependency();
            LOG.error("cyclic dependencies between converters: " + ((ConverterProvider)pair.getFirst()).getId() + " and " + ((ConverterProvider)pair.getSecond()).getId());
        }
        Comparator comparator2 = builder2.comparator();
        Collections.sort(runners, (o1, o2) -> comparator2.compare(o1.getProvider(), o2.getProvider()));
        return runners;
    }

    @Override
    public void saveConversionResult(@NotNull String projectPath) {
        try {
            ConversionServiceImpl.saveConversionResult(new ConversionContextImpl(projectPath));
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
        }
    }

    private static void saveConversionResult(ConversionContextImpl context) {
        CachedConversionResult conversionResult = new CachedConversionResult();
        for (ConverterProvider provider : (ConverterProvider[])ConverterProvider.EP_NAME.getExtensions()) {
            conversionResult.myAppliedConverters.add(provider.getId());
        }
        conversionResult.myProjectFilesTimestamps = ConversionServiceImpl.getProjectFilesMap(context);
        File infoFile = ConversionServiceImpl.getConversionInfoFile(context.getProjectFile());
        FileUtil.createParentDirs((File)infoFile);
        try {
            JDOMUtil.writeDocument((Document)new Document(XmlSerializer.serialize((Object)conversionResult)), (File)infoFile, (String)SystemProperties.getLineSeparator());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private static CachedConversionResult loadCachedConversionResult(File projectFile) {
        try {
            File infoFile = ConversionServiceImpl.getConversionInfoFile(projectFile);
            if (!infoFile.exists()) {
                return new CachedConversionResult();
            }
            return (CachedConversionResult)XmlSerializer.deserialize((Element)JDOMUtil.load((File)infoFile), CachedConversionResult.class);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return new CachedConversionResult();
        }
    }

    private static File getConversionInfoFile(@NotNull File projectFile) {
        String dirName = PathUtil.suggestFileName((String)(projectFile.getName() + Integer.toHexString(projectFile.getAbsolutePath().hashCode())));
        return new File(PathManager.getSystemPath() + File.separator + "conversion" + File.separator + dirName + ".xml");
    }

    @Override
    @NotNull
    public ConversionResult convertModule(@NotNull Project project, @NotNull File moduleFile) {
        String url = project.getPresentableUrl();
        assert (url != null) : project;
        String projectPath = FileUtil.toSystemDependentName((String)url);
        if (!ConversionServiceImpl.isConversionNeeded(projectPath, moduleFile)) {
            return ConversionResultImpl.CONVERSION_NOT_NEEDED;
        }
        int res2 = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"message.module.file.has.an.older.format.do.you.want.to.convert.it", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (res2 != 0) {
            return ConversionResultImpl.CONVERSION_CANCELED;
        }
        if (!moduleFile.canWrite()) {
            Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.message.cannot.modify.file.0", (Object[])new Object[]{moduleFile.getAbsolutePath()}), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]));
            return ConversionResultImpl.ERROR_OCCURRED;
        }
        try {
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> runners = ConversionServiceImpl.createConversionRunners(context, Collections.emptySet());
            File backupFile = ProjectConversionUtil.backupFile(moduleFile);
            ArrayList<ConversionRunner> usedRunners = new ArrayList<ConversionRunner>();
            for (ConversionRunner runner : runners) {
                if (!runner.isModuleConversionNeeded(moduleFile)) continue;
                runner.convertModule(moduleFile);
                usedRunners.add(runner);
            }
            context.saveFiles(Collections.singletonList(moduleFile), usedRunners);
            Messages.showInfoMessage((Project)project, (String)IdeBundle.message((String)"message.your.module.was.successfully.converted.br.old.version.was.saved.to.0", (Object[])new Object[]{backupFile.getAbsolutePath()}), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]));
            return new ConversionResultImpl(runners);
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)"Cannot Convert Module");
            return ConversionResultImpl.ERROR_OCCURRED;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return ConversionResultImpl.ERROR_OCCURRED;
        }
    }

    private static boolean isConversionNeeded(String projectPath, File moduleFile) {
        try {
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> runners = ConversionServiceImpl.createConversionRunners(context, Collections.emptySet());
            for (ConversionRunner runner : runners) {
                if (!runner.isModuleConversionNeeded(moduleFile)) continue;
                return true;
            }
            return false;
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    private static class ConverterProvidersGraph
    implements InboundSemiGraph<ConverterProvider> {
        private final ConverterProvider[] myProviders;

        ConverterProvidersGraph(ConverterProvider[] providers) {
            this.myProviders = providers;
        }

        @NotNull
        public Collection<ConverterProvider> getNodes() {
            return Arrays.asList(this.myProviders);
        }

        @NotNull
        public Iterator<ConverterProvider> getIn(ConverterProvider n) {
            ArrayList<ConverterProvider> preceding = new ArrayList<ConverterProvider>();
            for (String id : n.getPrecedingConverterIds()) {
                for (ConverterProvider provider : this.myProviders) {
                    if (!provider.getId().equals(id)) continue;
                    preceding.add(provider);
                }
            }
            return preceding.iterator();
        }
    }

    @Tag(value="conversion")
    public static class CachedConversionResult {
        @Tag(value="applied-converters")
        @XCollection(elementName="converter", valueAttributeName="id")
        public Set<String> myAppliedConverters = new HashSet<String>();
        @XMap(propertyElementName="project-files", entryTagName="file", keyAttributeName="path", valueAttributeName="timestamp")
        public Map<String, Long> myProjectFilesTimestamps = new HashMap<String, Long>();
    }
}

