/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class MarkupModelWindow
extends UserDataHolderBase
implements MarkupModelEx {
    private final DocumentWindow myDocument;
    private final MarkupModelEx myHostModel;

    public MarkupModelWindow(MarkupModelEx editorMarkupModel, DocumentWindow document) {
        this.myDocument = document;
        this.myHostModel = editorMarkupModel;
    }

    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        return this.myHostModel.addRangeHighlighter(hostRange.getStartOffset(), hostRange.getEndOffset(), layer, textAttributes, targetArea);
    }

    @Override
    @NotNull
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, Consumer<RangeHighlighterEx> changeAttributesAction) {
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        return this.myHostModel.addRangeHighlighterAndChangeAttributes(hostRange.getStartOffset(), hostRange.getEndOffset(), layer, textAttributes, targetArea, isPersistent, changeAttributesAction);
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter, @NotNull Consumer<RangeHighlighterEx> changeAttributesAction) {
        this.myHostModel.changeAttributesInBatch(highlighter, changeAttributesAction);
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int line, int layer, TextAttributes textAttributes) {
        int hostLine = this.myDocument.injectedToHostLine(line);
        return this.myHostModel.addLineHighlighter(hostLine, layer, textAttributes);
    }

    public void removeHighlighter(@NotNull RangeHighlighter rangeHighlighter) {
        this.myHostModel.removeHighlighter(rangeHighlighter);
    }

    public void removeAllHighlighters() {
        this.myHostModel.removeAllHighlighters();
    }

    @NotNull
    public RangeHighlighter[] getAllHighlighters() {
        return this.myHostModel.getAllHighlighters();
    }

    @Override
    public void dispose() {
        this.myHostModel.dispose();
    }

    @Override
    public RangeHighlighterEx addPersistentLineHighlighter(int line, int layer, TextAttributes textAttributes) {
        int hostLine = this.myDocument.injectedToHostLine(line);
        return this.myHostModel.addPersistentLineHighlighter(hostLine, layer, textAttributes);
    }

    @Override
    public boolean containsHighlighter(@NotNull RangeHighlighter highlighter) {
        return this.myHostModel.containsHighlighter(highlighter);
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, @NotNull MarkupModelListener listener2) {
        this.myHostModel.addMarkupModelListener(parentDisposable, listener2);
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter, @NotNull TextAttributes textAttributes) {
        this.myHostModel.setRangeHighlighterAttributes(highlighter, textAttributes);
    }

    @Override
    public boolean processRangeHighlightersOverlappingWith(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        return false;
    }

    @Override
    public boolean processRangeHighlightersOutside(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        return false;
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        return this.myHostModel.overlappingIterator(startOffset, endOffset);
    }

    @Override
    public void fireAttributesChanged(@NotNull RangeHighlighterEx segmentHighlighter, boolean renderersChanged, boolean fontStyleChanged) {
    }

    @Override
    public void fireAfterAdded(@NotNull RangeHighlighterEx segmentHighlighter) {
    }

    @Override
    public void fireBeforeRemoved(@NotNull RangeHighlighterEx segmentHighlighter) {
    }

    @Override
    public void addRangeHighlighter(@NotNull RangeHighlighterEx marker, int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
    }
}

