/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DumpLookupElementWeights
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.DumpLookupElementWeights");

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        DumpLookupElementWeights.dumpLookupElementWeights((LookupImpl)LookupManager.getActiveLookup(editor));
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        presentation.setEnabled(editor != null && LookupManager.getActiveLookup(editor) != null);
    }

    public static void dumpLookupElementWeights(LookupImpl lookup) {
        LookupElement selected = lookup.getCurrentItem();
        String sb = "selected: " + selected;
        if (selected != null) {
            sb = sb + "\nprefix: " + lookup.itemPattern(selected);
        }
        sb = sb + "\nweights:\n" + StringUtil.join(DumpLookupElementWeights.getLookupElementWeights(lookup, true), (String)"\n");
        System.out.println(sb);
        LOG.info(sb);
        try {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> getLookupElementWeights(LookupImpl lookup, boolean hideSingleValued) {
        Map<LookupElement, List<Pair<String, Object>>> weights = lookup.getRelevanceObjects(lookup.getItems(), hideSingleValued);
        return ContainerUtil.map(weights.entrySet(), entry -> ((LookupElement)entry.getKey()).getLookupString() + "\t" + StringUtil.join((Collection)((Collection)entry.getValue()), pair -> (String)pair.first + "=" + pair.second, (String)", "));
    }
}

