/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class LoadAllContentsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.LoadAllContentsAction");
    private final AtomicInteger count = new AtomicInteger();
    private final AtomicLong totalSize = new AtomicLong();

    public LoadAllContentsAction() {
        super("Load all files content", "Measure FileUtil.loadFile() for all files in the project", null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        String m = "Started loading content";
        LOG.info(m);
        System.out.println(m);
        long start2 = System.currentTimeMillis();
        this.count.set(0);
        this.totalSize.set(0L);
        ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronously(() -> ProjectRootManager.getInstance((Project)project).getFileIndex().iterateContent(fileOrDir -> {
            if (fileOrDir.isDirectory() || fileOrDir.is(VFileProperty.SPECIAL)) {
                return true;
            }
            try {
                this.count.incrementAndGet();
                byte[] bytes = FileUtil.loadFileBytes((File)new File(fileOrDir.getPath()));
                this.totalSize.addAndGet(bytes.length);
                ProgressManager.getInstance().getProgressIndicator().setText(fileOrDir.getPresentableUrl());
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
            return true;
        }), "Loading", false, project);
        long end = System.currentTimeMillis();
        String message = "Finished loading content of " + this.count + " files. Total size=" + StringUtil.formatFileSize((long)this.totalSize.get()) + ". Elapsed=" + (end - start2) / 1000L + "sec.";
        LOG.info(message);
        System.out.println(message);
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PROJECT) != null);
    }
}

