/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class LoadAllVfsStoredContentsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.LoadAllContentsAction");
    private final AtomicInteger count = new AtomicInteger();
    private final AtomicLong totalSize = new AtomicLong();

    public LoadAllVfsStoredContentsAction() {
        super("Load all VirtualFiles content", "Measure virtualFile.contentsToByteArray() for all virtual files stored in the VFS", null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        String m = "Started loading content";
        LOG.info(m);
        System.out.println(m);
        long start2 = System.currentTimeMillis();
        this.count.set(0);
        this.totalSize.set(0L);
        ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronously(() -> {
            VirtualFile[] roots;
            PersistentFS vfs = (PersistentFS)((Object)((Object)application.getComponent(ManagingFS.class)));
            for (VirtualFile root : roots = vfs.getRoots()) {
                this.iterateCached(root);
            }
        }, "Loading", false, null);
        long end = System.currentTimeMillis();
        String message = "Finished loading content of " + this.count + " files. Total size=" + StringUtil.formatFileSize((long)this.totalSize.get()) + ". Elapsed=" + (end - start2) / 1000L + "sec.";
        LOG.info(message);
        System.out.println(message);
    }

    private void iterateCached(VirtualFile root) {
        this.processFile((NewVirtualFile)root);
        Collection children2 = ((NewVirtualFile)root).getCachedChildren();
        for (VirtualFile child2 : children2) {
            this.iterateCached(child2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processFile(NewVirtualFile file2) {
        if (file2.isDirectory()) return true;
        if (file2.is(VFileProperty.SPECIAL)) {
            return true;
        }
        try (InputStream stream = PersistentFS.getInstance().getInputStream((VirtualFile)file2);){
            if (!(stream instanceof DataInputStream)) {
                boolean bl = true;
                return bl;
            }
            byte[] bytes = FileUtil.loadBytes((InputStream)stream);
            this.totalSize.addAndGet(bytes.length);
            this.count.incrementAndGet();
            ProgressManager.getInstance().getProgressIndicator().setText(file2.getPresentableUrl());
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PROJECT) != null);
    }
}

