/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cachedValueProfiler;

import com.google.gson.stream.JsonReader;
import com.intellij.internal.cachedValueProfiler.CVPInfo;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CVPReader {
    @NotNull
    private final JsonReader myReader;

    private CVPReader(@NotNull JsonReader reader) {
        this.myReader = reader;
    }

    @NotNull
    public static List<CVPInfo> deserialize(@NotNull InputStream stream) throws IOException {
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));){
            List<CVPInfo> list2 = new CVPReader(reader).read();
            return list2;
        }
    }

    @NotNull
    private List<CVPInfo> read() throws IOException {
        ArrayList list2 = ContainerUtil.newArrayList();
        this.myReader.beginArray();
        while (this.myReader.hasNext()) {
            list2.add(this.readInfo());
        }
        this.myReader.endArray();
        return list2;
    }

    @NotNull
    private CVPInfo readInfo() throws IOException {
        String origin = null;
        long totalLifeTime = 0L;
        long totalUseCount = 0L;
        long createdCount = 0L;
        this.myReader.beginObject();
        while (this.myReader.hasNext()) {
            String name = this.myReader.nextName();
            if ("origin".equals(name)) {
                origin = this.myReader.nextString();
                continue;
            }
            if ("total lifetime".equals(name)) {
                totalLifeTime = this.myReader.nextLong();
                continue;
            }
            if ("total use count".equals(name)) {
                totalUseCount = this.myReader.nextLong();
                continue;
            }
            if (!"created".equals(name)) continue;
            createdCount = this.myReader.nextLong();
        }
        this.myReader.endObject();
        return new CVPInfo(origin, totalLifeTime, totalUseCount, createdCount);
    }
}

