/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cfgView;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowProvider;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.util.ExecUtil;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ShowControlFlowHandler
implements CodeInsightActionHandler {
    private static final Logger LOGGER = Logger.getInstance(ShowControlFlowHandler.class);
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Show control flow group");
    private static final String NO_GRAPHVIZ_HELP = "Probably graphviz is missing.You could install graphviz using `apt install graphviz` or `brew install graphviz`";

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement position = file2.findElementAt(offset);
        if (position == null) {
            return;
        }
        try {
            File svgFile = FileUtil.createTempFile((String)"control-flow", (String)".svg", (boolean)true);
            String path = svgFile.getAbsolutePath();
            boolean success2 = ShowControlFlowHandler.toSvgFile(path, position);
            if (success2) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    boolean exists = svgFile.exists();
                    VirtualFile fileByUrl = VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)path));
                    if (fileByUrl != null) {
                        AnAction openInBrowser2 = ActionManager.getInstance().getAction("OpenInBrowser");
                        DataContext dataContext = dataId -> {
                            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                                return fileByUrl;
                            }
                            if (CommonDataKeys.PROJECT.is(dataId)) {
                                return project;
                            }
                            return null;
                        };
                        AnActionEvent action = AnActionEvent.createFromDataContext((String)"ShowControlFlow", null, (DataContext)dataContext);
                        openInBrowser2.actionPerformed(action);
                    } else {
                        LOGGER.error("cannot find file by URL: " + path + " " + exists);
                    }
                });
            }
        }
        catch (FileNotFoundException e) {
            NOTIFICATION_GROUP.createNotification("Show CFG:", e.getMessage(), NO_GRAPHVIZ_HELP, NotificationType.ERROR).notify(project);
            LOGGER.warn((Throwable)e);
        }
        catch (ExecutionException | IOException e) {
            LOGGER.warn(e);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean toSvgFile(@NotNull String outSvgFile, @NotNull PsiElement target2) throws IOException, ExecutionException {
        String dotUtilName = SystemInfoRt.isUnix ? "dot" : "dot.exe";
        File dotFullPath = PathEnvironmentVariableUtil.findInPath((String)dotUtilName);
        if (dotFullPath == null) {
            throw new FileNotFoundException("Cannot find dot utility in path");
        }
        ControlFlow controlFlow = null;
        ControlFlowProvider provider = null;
        for (ControlFlowProvider extension : (ControlFlowProvider[])ControlFlowProvider.EP_NAME.getExtensions()) {
            controlFlow = extension.getControlFlow(target2);
            if (controlFlow == null) continue;
            provider = extension;
            break;
        }
        if (controlFlow == null) {
            return false;
        }
        File tmpFile = FileUtil.createTempFile((String)"control-flow", (String)".dot", (boolean)true);
        try {
            FileUtil.writeToFile((File)tmpFile, (String)ShowControlFlowHandler.toDot(controlFlow, provider));
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{dotFullPath.getAbsolutePath()}).withInput(tmpFile.getAbsoluteFile()).withParameters(new String[]{"-Tsvg", "-o" + outSvgFile, tmpFile.getAbsolutePath()}).withRedirectErrorStream(true);
            ExecUtil.execAndGetOutput((GeneralCommandLine)generalCommandLine);
        }
        finally {
            if (!tmpFile.delete()) {
                LOGGER.warn("Cannot delete tmp file: " + tmpFile);
            }
        }
        return true;
    }

    @NotNull
    private static String toDot(@NotNull ControlFlow flow, @NotNull ControlFlowProvider provider) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("digraph {");
        for (Instruction instruction : flow.getInstructions()) {
            ShowControlFlowHandler.printInstruction(builder2, instruction, provider);
            if (instruction instanceof ConditionalInstruction) {
                ConditionalInstruction conditionalInstruction = (ConditionalInstruction)instruction;
                builder2.append("\n").append("Its ").append(conditionalInstruction.getResult()).append(" branch, condition: ").append(conditionalInstruction.getCondition().getText());
            }
            builder2.append("\"").append("]");
            builder2.append(System.lineSeparator());
            if (instruction.allPred().isEmpty()) {
                builder2.append("Entry -> Instruction").append(instruction.num()).append(System.lineSeparator());
            }
            if (instruction.allSucc().isEmpty()) {
                builder2.append("Instruction").append(instruction.num()).append(" -> Exit").append(System.lineSeparator());
            }
            for (Instruction succ : instruction.allSucc()) {
                builder2.append("Instruction").append(instruction.num()).append(" -> ").append("Instruction").append(succ.num()).append(System.lineSeparator());
            }
        }
        builder2.append("}");
        return builder2.toString();
    }

    private static void printInstruction(@NotNull StringBuilder builder2, @NotNull Instruction instruction, @NotNull ControlFlowProvider provider) {
        PsiElement element = instruction.getElement();
        Class<?> instructionClass = instruction.getClass();
        builder2.append("Instruction").append(instruction.num()).append("[font=\"Courier\", label=\"").append(element != null ? ShowControlFlowHandler.escape(element.getText()) : "").append(" \\n(").append(instruction.num()).append(")[").append(element != null ? element.getClass().getSimpleName() : "null").append("]").append(System.lineSeparator()).append("{").append(instructionClass.getSimpleName().isEmpty() ? instructionClass.getSuperclass().getSimpleName() : instructionClass.getSimpleName()).append("}");
        String additionalInfo = provider.getAdditionalInfo(instruction);
        if (additionalInfo != null) {
            builder2.append("\n{").append(additionalInfo).append("}");
        }
    }

    @NotNull
    private static String escape(@NotNull String text) {
        return StringUtil.replace((String)StringUtil.escapeChars((String)text, (char[])new char[]{'\"'}), (String)"\n", (String)"\\n");
    }
}

