/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.google.common.base.MoreObjects;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.ColorsIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiInspectorAction
extends ToggleAction
implements DumbAware {
    private static final String CLICK_INFO = "CLICK_INFO";
    private static final String CLICK_INFO_POINT = "CLICK_INFO_POINT";
    private static final String RENDERER_BOUNDS = "clicked renderer";
    private static final int MAX_DEEPNESS_TO_DISCOVER_FIELD_NAME = 8;
    private UiInspector myInspector;

    public UiInspectorAction() {
        if (Boolean.getBoolean("idea.ui.debug.mode")) {
            ApplicationManager.getApplication().invokeLater(() -> this.setSelected(true));
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        return this.myInspector != null;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        this.setSelected(state);
    }

    void setSelected(boolean state) {
        if (state) {
            UiInspectorNotification[] existing;
            if (this.myInspector == null) {
                this.myInspector = new UiInspector();
            }
            if ((existing = (UiInspectorNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UiInspectorNotification.class, null)).length == 0) {
                Notifications.Bus.notify((Notification)new UiInspectorNotification(), null);
            }
        } else {
            UiInspector inspector = this.myInspector;
            this.myInspector = null;
            if (inspector != null) {
                Disposer.dispose((Disposable)inspector);
            }
        }
    }

    @NotNull
    private static String getComponentName(Component component) {
        String name = UiInspectorAction.getClassName(component);
        String componentName = component.getName();
        if (StringUtil.isNotEmpty((String)componentName)) {
            name = name + " \"" + componentName + "\"";
        }
        return name;
    }

    @Nullable
    private static Pair<Class, String> getClassAndFieldName(Component component) {
        Container parent = component.getParent();
        for (int deepness = 1; parent != null && deepness <= 8; parent = parent.getParent(), ++deepness) {
            Field[] fields;
            Class<?> aClass = parent.getClass();
            for (Field field : fields = aClass.getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    if (field.get(parent) != component) continue;
                    return Pair.create(parent.getClass(), (Object)field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static TreeModel buildModel(Component c) {
        Container parent = c.getParent();
        while (parent != null) {
            c = parent;
            parent = c.getParent();
        }
        return new DefaultTreeModel(new HierarchyTree.ComponentNode(c));
    }

    private static void drawCenteredString(Graphics2D g2d, FontMetrics fm, int fontHeight, String text, int x, int y) {
        int width = fm.stringWidth(text);
        UIUtil.drawCenteredString((Graphics2D)g2d, (Rectangle)new Rectangle(x - width / 2, y - fontHeight / 2, width, fontHeight), (String)text);
    }

    @NotNull
    private static String getToStringValue(@NotNull Object value) {
        String toString = StringUtil.notNullize((String)String.valueOf(value), (String)"toString()==null");
        return toString.replace('\n', ' ');
    }

    @NotNull
    private static String getClassName(Object value) {
        Class<?> clazz0 = value.getClass();
        Class<?> clazz = clazz0.isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
        return clazz.getSimpleName();
    }

    private static ColorIcon createColorIcon(Color color) {
        return (ColorIcon)JBUI.scale((JBUI.JBIcon)new ColorIcon(13, 11, color, true));
    }

    private static Icon createColorIcon(Color color1, Color color2) {
        return JBUI.scale((JBUI.JBIcon)new ColorsIcon(11, new Color[]{color1, color2}));
    }

    @Nullable
    private static AnAction getAction(Component c) {
        return (AnAction)UIUtil.getClientProperty((Object)c, (Key)CustomComponentAction.ACTION_KEY);
    }

    private static Object fromObject(Object o, Class<?> type) {
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return o;
        }
        if ("null".equals(o)) {
            return null;
        }
        String value = String.valueOf(o).trim();
        if (type == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (type == Boolean.TYPE) {
            return "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
        }
        if (type == Byte.TYPE) {
            return Byte.parseByte(value);
        }
        if (type == Short.TYPE) {
            return Short.parseShort(value);
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        String[] s = value.split("(?i)\\s*(?:[x@:]|[a-z]+:)\\s*", 6);
        if (type == Dimension.class) {
            if (s.length == 2) {
                return new Dimension(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
            }
        } else if (type == Point.class) {
            if (s.length == 2) {
                return new Point(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
            }
        } else if (type == Rectangle.class) {
            if (s.length >= 5) {
                return new Rectangle(Integer.parseInt(s[3]), Integer.parseInt(s[4]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
            }
        } else if (type == Insets.class) {
            if (s.length >= 5) {
                return new Insets(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[4]), Integer.parseInt(s[4]));
            }
        } else if (type == Color.class && s.length >= 5) {
            return new ColorUIResource(new Color(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[3]), Integer.parseInt(s[4])));
        }
        throw new UnsupportedOperationException(type.toString());
    }

    private static class UiInspector
    implements AWTEventListener,
    Disposable {
        UiInspector() {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 18L);
        }

        public void dispose() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            for (Window window : Window.getWindows()) {
                if (!(window instanceof InspectorWindow)) continue;
                ((InspectorWindow)window).close();
            }
        }

        public void showInspector(@NotNull Component c) {
            InspectorWindow window = new InspectorWindow(c);
            if (DimensionService.getInstance().getSize(InspectorWindow.getDimensionServiceKey()) == null) {
                window.pack();
            }
            ((Window)window).setVisible(true);
            window.toFront();
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                this.processMouseEvent((MouseEvent)event);
            } else if (event instanceof ContainerEvent) {
                UiInspector.processContainerEvent((ContainerEvent)event);
            }
        }

        private void processMouseEvent(MouseEvent me) {
            if (!me.isAltDown() || !me.isControlDown()) {
                return;
            }
            if (me.getClickCount() != 1 || me.isPopupTrigger()) {
                return;
            }
            me.consume();
            if (me.getID() != 502) {
                return;
            }
            Component component = me.getComponent();
            if (component instanceof Container) {
                component = ((Container)component).findComponentAt(me.getPoint());
            } else if (component == null) {
                component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            }
            if (component != null) {
                if (component instanceof JComponent) {
                    ((JComponent)component).putClientProperty(UiInspectorAction.CLICK_INFO, UiInspector.getClickInfo(me, component));
                    ((JComponent)component).putClientProperty(UiInspectorAction.CLICK_INFO_POINT, me.getPoint());
                }
                this.showInspector(component);
            }
        }

        private static List<PropertyBean> getClickInfo(MouseEvent me, Component component) {
            JTree tree;
            TreePath path;
            JList list2;
            int row2;
            if (me.getComponent() == null) {
                return null;
            }
            me = SwingUtilities.convertMouseEvent(me.getComponent(), me, component);
            ArrayList<PropertyBean> clickInfo = new ArrayList<PropertyBean>();
            if (component instanceof JList && (row2 = (list2 = (JList)component).getUI().locationToIndex(list2, me.getPoint())) != -1) {
                Component rendererComponent = list2.getCellRenderer().getListCellRendererComponent(list2, list2.getModel().getElementAt(row2), row2, list2.getSelectionModel().isSelectedIndex(row2), list2.hasFocus());
                clickInfo.addAll(UiInspector.findActionsFor(list2.getModel().getElementAt(row2)));
                clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, list2.getUI().getCellBounds(list2, row2, row2)));
                clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                return clickInfo;
            }
            if (component instanceof JTable) {
                JTable table = (JTable)component;
                row2 = table.rowAtPoint(me.getPoint());
                int column = table.columnAtPoint(me.getPoint());
                if (row2 != -1 && column != -1) {
                    Component rendererComponent = table.getCellRenderer(row2, column).getTableCellRendererComponent(table, table.getValueAt(row2, column), table.getSelectionModel().isSelectedIndex(row2), table.hasFocus(), row2, column);
                    clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, table.getCellRect(row2, column, true)));
                    clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                    return clickInfo;
                }
            }
            if (component instanceof JTree && (path = (tree = (JTree)component).getClosestPathForLocation(me.getX(), me.getY())) != null) {
                Object object = path.getLastPathComponent();
                Component rendererComponent = tree.getCellRenderer().getTreeCellRendererComponent(tree, object, tree.getSelectionModel().isPathSelected(path), tree.isExpanded(path), tree.getModel().isLeaf(object), tree.getRowForPath(path), tree.hasFocus());
                clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, tree.getPathBounds(path)));
                clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                return clickInfo;
            }
            if (component instanceof ActionToolbarImpl) {
                clickInfo.add(new PropertyBean("Toolbar Place", ((ActionToolbarImpl)component).getPlace(), true));
                clickInfo.add(new PropertyBean("Toolbar Group", ((ActionToolbarImpl)component).getGroupId(), true));
                return clickInfo;
            }
            return null;
        }

        private static List<PropertyBean> findActionsFor(Object object) {
            if (object instanceof PopupFactoryImpl.ActionItem) {
                AnAction action = ((PopupFactoryImpl.ActionItem)object).getAction();
                return Collections.singletonList(new PropertyBean("action", action.getClass().getName(), true));
            }
            if (object instanceof QuickFixWrapper) {
                return UiInspector.findActionsFor(((QuickFixWrapper)object).getFix());
            }
            if (object instanceof IntentionActionDelegate) {
                IntentionAction delegate = ((IntentionActionDelegate)object).getDelegate();
                if (delegate != object) {
                    return UiInspector.findActionsFor(delegate);
                }
            } else {
                if (object instanceof IntentionAction) {
                    return Collections.singletonList(new PropertyBean("intention action", object.getClass().getName(), true));
                }
                if (object instanceof QuickFix) {
                    return Collections.singletonList(new PropertyBean("quick fix", object.getClass().getName(), true));
                }
            }
            return Collections.emptyList();
        }

        private static void processContainerEvent(ContainerEvent event) {
            Component child2;
            Component component = child2 = event.getID() == 300 ? event.getChild() : null;
            if (child2 instanceof JComponent && !(event.getSource() instanceof CellRendererPane)) {
                String text = ExceptionUtil.getThrowableText((Throwable)new Throwable());
                int first = text.indexOf("at com.intellij", text.indexOf("at java.awt"));
                int last = text.indexOf("at java.awt.EventQueue");
                if (last == -1) {
                    last = text.length();
                }
                String val = last > first && first > 0 ? text.substring(first, last) : null;
                ((JComponent)child2).putClientProperty("uiInspector.addedAt", val);
            }
        }
    }

    private static class InspectorTableModel
    extends AbstractTableModel {
        final List<String> PROPERTIES = Arrays.asList("ui", "getLocation", "getLocationOnScreen", "getSize", "isOpaque", "getBorder", "getForeground", "getBackground", "getFont", "getCellRenderer", "getCellEditor", "getMinimumSize", "getMaximumSize", "getPreferredSize", "getText", "isEditable", "getIcon", "getVisibleRect", "getLayout", "getAlignmentX", "getAlignmentY", "getTooltipText", "getToolTipText", "isShowing", "isEnabled", "isVisible", "isDoubleBuffered", "isFocusable", "isFocusCycleRoot", "isFocusOwner", "isValid", "isDisplayable", "isLightweight");
        final List<String> CHECKERS = Arrays.asList("isForegroundSet", "isBackgroundSet", "isFontSet", "isMinimumSizeSet", "isMaximumSizeSet", "isPreferredSizeSet");
        final List<String> ACCESSIBLE_CONTEXT_PROPERTIES = Arrays.asList("getAccessibleRole", "getAccessibleName", "getAccessibleDescription", "getAccessibleAction", "getAccessibleChildrenCount", "getAccessibleIndexInParent", "getAccessibleRelationSet", "getAccessibleStateSet", "getAccessibleEditableText", "getAccessibleTable", "getAccessibleText", "getAccessibleValue", "accessibleChangeSupport");
        final Component myComponent;
        final List<PropertyBean> myProperties = ContainerUtil.newArrayList();

        InspectorTableModel(@NotNull List<? extends PropertyBean> clickInfo) {
            this.myComponent = null;
            this.myProperties.addAll(clickInfo);
        }

        InspectorTableModel(@NotNull Component c) {
            this.myComponent = c;
            this.fillTable();
        }

        void fillTable() {
            this.addProperties("", this.myComponent, this.PROPERTIES);
            Object addedAt = this.myComponent instanceof JComponent ? ((JComponent)this.myComponent).getClientProperty("uiInspector.addedAt") : null;
            this.myProperties.add(new PropertyBean("added-at", addedAt));
            boolean isAccessible = this.myComponent instanceof Accessible;
            this.myProperties.add(new PropertyBean("accessible", isAccessible));
            AccessibleContext context = this.myComponent.getAccessibleContext();
            this.myProperties.add(new PropertyBean("accessibleContext", context));
            if (isAccessible) {
                this.addProperties("  ", this.myComponent.getAccessibleContext(), this.ACCESSIBLE_CONTEXT_PROPERTIES);
            }
            if (this.myComponent instanceof Container) {
                this.addLayoutProperties((Container)this.myComponent);
            }
        }

        private void addProperties(@NotNull String prefix, @NotNull Object component, @NotNull List<String> methodNames) {
            Class<?> clazz0 = component.getClass();
            Class<?> clazz = clazz0.isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
            this.myProperties.add(new PropertyBean(prefix + "class", clazz.getName()));
            this.addActionInfo(component);
            this.addGutterInfo(component);
            StringBuilder classHierarchy = new StringBuilder();
            for (Class<?> cl = clazz.getSuperclass(); cl != null; cl = cl.getSuperclass()) {
                if (classHierarchy.length() > 0) {
                    classHierarchy.append(" -> ");
                }
                classHierarchy.append(cl.getName());
                if (JComponent.class.getName().equals(cl.getName())) break;
            }
            this.myProperties.add(new PropertyBean(prefix + "hierarchy", classHierarchy.toString()));
            for (String name : methodNames) {
                String propertyName = (String)ObjectUtils.notNull((Object)StringUtil.getPropertyName((String)name), (Object)name);
                try {
                    Object propertyValue;
                    try {
                        propertyValue = ReflectionUtil.findMethod(Arrays.asList(clazz.getMethods()), (String)name, (Class[])new Class[0]).invoke(component, new Object[0]);
                    }
                    catch (Exception e) {
                        propertyValue = ReflectionUtil.findField(clazz, null, (String)name).get(component);
                    }
                    boolean changed = false;
                    try {
                        Object value;
                        String checkerMethodName = "is" + StringUtil.capitalize((String)propertyName) + "Set";
                        if (this.CHECKERS.contains(checkerMethodName) && (value = ReflectionUtil.findMethod(Arrays.asList(clazz.getMethods()), (String)checkerMethodName, (Class[])new Class[0]).invoke(component, new Object[0])) instanceof Boolean) {
                            changed = (Boolean)value;
                        }
                    }
                    catch (Exception e) {
                        changed = false;
                    }
                    this.myProperties.add(new PropertyBean(prefix + propertyName, propertyValue, changed));
                }
                catch (Exception exception) {}
            }
        }

        private void addGutterInfo(Object component) {
            Point clickPoint;
            GutterMark renderer2;
            if (component instanceof EditorGutterComponentEx && ((JComponent)component).getClientProperty(UiInspectorAction.CLICK_INFO_POINT) instanceof Point && (renderer2 = ((EditorGutterComponentEx)component).getGutterRenderer(clickPoint = (Point)((JComponent)component).getClientProperty(UiInspectorAction.CLICK_INFO_POINT))) != null) {
                this.myProperties.add(new PropertyBean("gutter renderer", renderer2.getClass().getName(), true));
            }
        }

        private void addActionInfo(Object component) {
            AnAction action = null;
            if (component instanceof ActionButton) {
                action = ((ActionButton)component).getAction();
            } else if (component instanceof JComponent) {
                action = component instanceof ActionMenuItem ? ((ActionMenuItem)((Object)component)).getAnAction() : UiInspectorAction.getAction(UIUtil.findParentByCondition((Component)((Component)component), c -> UiInspectorAction.getAction(c) != null));
            }
            if (action != null) {
                this.myProperties.add(new PropertyBean("action", action.getClass().getName(), true));
            }
        }

        private void addLayoutProperties(@NotNull Container component) {
            block11: {
                LayoutManager layout;
                String prefix;
                block13: {
                    block12: {
                        block10: {
                            prefix = "  ";
                            layout = component.getLayout();
                            if (!(layout instanceof GridBagLayout)) break block10;
                            GridBagLayout bagLayout = (GridBagLayout)layout;
                            GridBagConstraints defaultConstraints = (GridBagConstraints)ReflectionUtil.getField(GridBagLayout.class, (Object)bagLayout, GridBagConstraints.class, (String)"defaultConstraints");
                            this.myProperties.add(new PropertyBean("GridBagLayout constraints", String.format("defaultConstraints - %s", InspectorTableModel.toString(defaultConstraints))));
                            if (bagLayout.columnWidths != null) {
                                this.myProperties.add(new PropertyBean(prefix + "columnWidths", Arrays.toString(bagLayout.columnWidths)));
                            }
                            if (bagLayout.rowHeights != null) {
                                this.myProperties.add(new PropertyBean(prefix + "rowHeights", Arrays.toString(bagLayout.rowHeights)));
                            }
                            if (bagLayout.columnWeights != null) {
                                this.myProperties.add(new PropertyBean(prefix + "columnWeights", Arrays.toString(bagLayout.columnWeights)));
                            }
                            if (bagLayout.rowWeights != null) {
                                this.myProperties.add(new PropertyBean(prefix + "rowWeights", Arrays.toString(bagLayout.rowWeights)));
                            }
                            for (Component child2 : component.getComponents()) {
                                this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child2), InspectorTableModel.toString(bagLayout.getConstraints(child2))));
                            }
                            break block11;
                        }
                        if (!(layout instanceof BorderLayout)) break block12;
                        BorderLayout borderLayout = (BorderLayout)layout;
                        this.myProperties.add(new PropertyBean("BorderLayout constraints", String.format("hgap - %s, vgap - %s", borderLayout.getHgap(), borderLayout.getVgap())));
                        for (Component child3 : component.getComponents()) {
                            this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child3), borderLayout.getConstraints(child3)));
                        }
                        break block11;
                    }
                    if (!(layout instanceof CardLayout)) break block13;
                    CardLayout cardLayout = (CardLayout)layout;
                    Integer currentCard = (Integer)ReflectionUtil.getField(CardLayout.class, (Object)cardLayout, null, (String)"currentCard");
                    Vector vector = (Vector)ReflectionUtil.getField(CardLayout.class, (Object)cardLayout, Vector.class, (String)"vector");
                    String cardDescription = "???";
                    if (vector != null && currentCard != null) {
                        Object card = vector.get(currentCard);
                        cardDescription = (String)ReflectionUtil.getField(card.getClass(), card, String.class, (String)"name");
                    }
                    this.myProperties.add(new PropertyBean("CardLayout constraints", String.format("card - %s, hgap - %s, vgap - %s", cardDescription, cardLayout.getHgap(), cardLayout.getVgap())));
                    if (vector == null) break block11;
                    for (Object card : vector) {
                        String cardName = (String)ReflectionUtil.getField(card.getClass(), card, String.class, (String)"name");
                        Component child4 = (Component)ReflectionUtil.getField(card.getClass(), card, Component.class, (String)"comp");
                        this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child4), cardName));
                    }
                    break block11;
                }
                if (layout instanceof MigLayout) {
                    MigLayout migLayout = (MigLayout)layout;
                    this.myProperties.add(new PropertyBean("MigLayout layout constraints", migLayout.getLayoutConstraints()));
                    this.myProperties.add(new PropertyBean("MigLayout column constraints", migLayout.getColumnConstraints()));
                    this.myProperties.add(new PropertyBean("MigLayout row constraints", migLayout.getRowConstraints()));
                    for (Component child5 : component.getComponents()) {
                        this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child5), migLayout.getComponentConstraints(child5)));
                    }
                }
            }
        }

        @NotNull
        private static String toString(@Nullable GridBagConstraints constraints) {
            if (constraints == null) {
                return "null";
            }
            MoreObjects.ToStringHelper h = MoreObjects.toStringHelper((String)"");
            InspectorTableModel.appendFieldValue(h, constraints, "gridx");
            InspectorTableModel.appendFieldValue(h, constraints, "gridy");
            InspectorTableModel.appendFieldValue(h, constraints, "gridwidth");
            InspectorTableModel.appendFieldValue(h, constraints, "gridheight");
            InspectorTableModel.appendFieldValue(h, constraints, "weightx");
            InspectorTableModel.appendFieldValue(h, constraints, "weighty");
            InspectorTableModel.appendFieldValue(h, constraints, "anchor");
            InspectorTableModel.appendFieldValue(h, constraints, "fill");
            InspectorTableModel.appendFieldValue(h, constraints, "insets");
            InspectorTableModel.appendFieldValue(h, constraints, "ipadx");
            InspectorTableModel.appendFieldValue(h, constraints, "ipady");
            return h.toString();
        }

        private static void appendFieldValue(@NotNull MoreObjects.ToStringHelper h, @NotNull GridBagConstraints constraints, @NotNull String field) {
            Object defaultValue;
            Object value = ReflectionUtil.getField(GridBagConstraints.class, (Object)constraints, null, (String)field);
            if (!Comparing.equal((Object)value, (Object)(defaultValue = ReflectionUtil.getField(GridBagConstraints.class, (Object)new GridBagConstraints(), null, (String)field)))) {
                h.add(field, value);
            }
        }

        @Override
        @Nullable
        public Object getValueAt(int row2, int column) {
            PropertyBean bean = this.myProperties.get(row2);
            if (bean != null) {
                return column == 0 ? bean.propertyName : bean.propertyValue;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row2, int col) {
            return col == 1 && this.updater(this.myProperties.get(row2)) != null;
        }

        @Override
        public void setValueAt(Object value, int row2, int col) {
            PropertyBean bean = this.myProperties.get(row2);
            try {
                this.myProperties.set(row2, new PropertyBean(bean.propertyName, ((Function)ObjectUtils.notNull(this.updater(bean))).fun(value)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Nullable
        public Function<Object, Object> updater(PropertyBean bean) {
            if (this.myComponent == null) {
                return null;
            }
            String name = bean.propertyName.trim();
            try {
                Method getter;
                try {
                    getter = this.myComponent.getClass().getMethod("get" + StringUtil.capitalize((String)name), new Class[0]);
                }
                catch (Exception e) {
                    getter = this.myComponent.getClass().getMethod("is" + StringUtil.capitalize((String)name), new Class[0]);
                }
                Method finalGetter = getter;
                Method setter = this.myComponent.getClass().getMethod("set" + StringUtil.capitalize((String)name), getter.getReturnType());
                setter.setAccessible(true);
                return o -> {
                    try {
                        setter.invoke((Object)this.myComponent, UiInspectorAction.fromObject(o, finalGetter.getReturnType()));
                        return finalGetter.invoke((Object)this.myComponent, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (Exception e) {
                try {
                    Field field = ReflectionUtil.findField(this.myComponent.getClass(), null, (String)name);
                    if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                        return null;
                    }
                    return o -> {
                        try {
                            field.set(this.myComponent, UiInspectorAction.fromObject(o, field.getType()));
                            return field.get(this.myComponent);
                        }
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                    };
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myProperties.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Property" : "Value";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : Object.class;
        }

        public void refresh() {
            this.myProperties.clear();
            this.fillTable();
            this.fireTableDataChanged();
        }
    }

    private static class PropertyBean {
        final String propertyName;
        final Object propertyValue;
        final boolean changed;

        PropertyBean(String name, Object value) {
            this(name, value, false);
        }

        PropertyBean(String name, Object value, boolean changed) {
            this.propertyName = name;
            this.propertyValue = value;
            this.changed = changed;
        }
    }

    private static class ObjectRenderer
    extends JLabel
    implements Renderer<Object> {
        private ObjectRenderer() {
            this.putClientProperty("html.disable", Boolean.TRUE);
        }

        @Override
        public JComponent setValue(@NotNull Object value) {
            this.setText(UiInspectorAction.getToStringValue(value));
            return this;
        }
    }

    private static class BorderRenderer
    extends JLabel
    implements Renderer<Border> {
        private BorderRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Border value) {
            this.setText(BorderRenderer.getTextDescription(value));
            if (value instanceof CompoundBorder) {
                Color insideColor = BorderRenderer.getBorderColor(((CompoundBorder)value).getInsideBorder());
                Color outsideColor = BorderRenderer.getBorderColor(((CompoundBorder)value).getOutsideBorder());
                if (insideColor != null && outsideColor != null) {
                    this.setIcon(UiInspectorAction.createColorIcon(insideColor, outsideColor));
                } else if (insideColor != null) {
                    this.setIcon((Icon)UiInspectorAction.createColorIcon(insideColor));
                } else if (outsideColor != null) {
                    this.setIcon((Icon)UiInspectorAction.createColorIcon(outsideColor));
                } else {
                    this.setIcon(null);
                }
            } else {
                Color color = BorderRenderer.getBorderColor(value);
                this.setIcon((Icon)(color != null ? UiInspectorAction.createColorIcon(color) : null));
            }
            return this;
        }

        @Nullable
        private static Color getBorderColor(@NotNull Border value) {
            if (value instanceof LineBorder) {
                return ((LineBorder)value).getLineColor();
            }
            if (value instanceof CustomLineBorder) {
                try {
                    return (Color)ReflectionUtil.findField(CustomLineBorder.class, Color.class, (String)"myColor").get(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        @NotNull
        private static String getTextDescription(@Nullable Border value) {
            if (value == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(UiInspectorAction.getClassName(value));
            Color color = BorderRenderer.getBorderColor(value);
            if (color != null) {
                sb.append(" color=").append(color.toString());
            }
            if (value instanceof LineBorder && ((LineBorder)value).getRoundedCorners()) {
                sb.append(" roundedCorners=true");
            }
            if (value instanceof TitledBorder) {
                sb.append(" title='").append(((TitledBorder)value).getTitle()).append("'");
            }
            if (value instanceof CompoundBorder) {
                sb.append(" inside={").append(BorderRenderer.getTextDescription(((CompoundBorder)value).getInsideBorder())).append("}");
                sb.append(" outside={").append(BorderRenderer.getTextDescription(((CompoundBorder)value).getOutsideBorder())).append("}");
            }
            if (value instanceof EmptyBorder) {
                Insets insets = ((EmptyBorder)value).getBorderInsets();
                sb.append(" insets={top=").append(insets.top).append(" left=").append(insets.left).append(" bottom=").append(insets.bottom).append(" right=").append(insets.right).append("}");
            }
            if (value instanceof UIResource) {
                sb.append(" UIResource");
            }
            sb.append(" (").append(UiInspectorAction.getToStringValue(value)).append(")");
            return sb.toString();
        }
    }

    private static class IconRenderer
    extends JLabel
    implements Renderer<Icon> {
        private IconRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Icon value) {
            this.setIcon(value);
            this.setText(UiInspectorAction.getToStringValue(value));
            return this;
        }
    }

    private static class BooleanRenderer
    extends JLabel
    implements Renderer<Boolean> {
        private BooleanRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Boolean value) {
            this.setText(value != false ? "Yes" : "No");
            return this;
        }
    }

    private static class FontRenderer
    extends JLabel
    implements Renderer<Font> {
        private FontRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Font value) {
            StringBuilder sb = new StringBuilder();
            sb.append(value.getFontName()).append(" (").append(value.getFamily()).append("), ").append(value.getSize()).append("px");
            if (1 == (1 & value.getStyle())) {
                sb.append(" bold");
            }
            if (2 == (2 & value.getStyle())) {
                sb.append(" italic");
            }
            if (value instanceof UIResource) {
                sb.append(" UIResource");
            }
            this.setText(sb.toString());
            return this;
        }
    }

    private static class ColorRenderer
    extends JLabel
    implements Renderer<Color> {
        private ColorRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Color value) {
            StringBuilder sb = new StringBuilder();
            sb.append(" r:").append(value.getRed());
            sb.append(" g:").append(value.getGreen());
            sb.append(" b:").append(value.getBlue());
            sb.append(" a:").append(value.getAlpha());
            sb.append(" argb:0x");
            String hex = Integer.toHexString(value.getRGB());
            for (int i = hex.length(); i < 8; ++i) {
                sb.append('0');
            }
            sb.append(hex.toUpperCase(Locale.ENGLISH));
            if (value instanceof UIResource) {
                sb.append(" UIResource");
            }
            this.setText(sb.toString());
            this.setIcon((Icon)UiInspectorAction.createColorIcon(value));
            return this;
        }
    }

    private static class RectangleRenderer
    extends JLabel
    implements Renderer<Rectangle> {
        private RectangleRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Rectangle value) {
            this.setText(RectangleRenderer.toString(value));
            return this;
        }

        @NotNull
        static String toString(@NotNull Rectangle r) {
            return r.width + "x" + r.height + " @ " + r.x + ":" + r.y;
        }
    }

    private static class InsetsRenderer
    extends JLabel
    implements Renderer<Insets> {
        private InsetsRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Insets value) {
            this.setText("top: " + value.top + " left:" + value.left + " bottom:" + value.bottom + " right:" + value.right);
            return this;
        }
    }

    private static class DimensionRenderer
    extends JLabel
    implements Renderer<Dimension> {
        private DimensionRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Dimension value) {
            this.setText(value.width + "x" + value.height);
            return this;
        }
    }

    private static class PointRenderer
    extends JLabel
    implements Renderer<Point> {
        private PointRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Point value) {
            this.setText(String.valueOf(value.x) + ':' + value.y);
            return this;
        }
    }

    private static interface Renderer<T> {
        public JComponent setValue(@NotNull T var1);
    }

    private static class ValueCellRenderer
    implements TableCellRenderer {
        private static final Map<Class, Renderer> RENDERERS = ContainerUtil.newHashMap();
        private static final Renderer<Object> DEFAULT_RENDERER;
        private static final JLabel NULL_RENDERER;

        private ValueCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
            if (value == null) {
                NULL_RENDERER.setOpaque(isSelected);
                NULL_RENDERER.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                NULL_RENDERER.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return NULL_RENDERER;
            }
            Renderer renderer2 = (Renderer)ObjectUtils.notNull(ValueCellRenderer.getRenderer(value.getClass()), DEFAULT_RENDERER);
            JComponent result2 = renderer2.setValue(value);
            result2.setOpaque(isSelected);
            result2.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            result2.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return result2;
        }

        @Nullable
        private static Renderer<Object> getRenderer(Class clazz) {
            Class<?>[] interfaces;
            if (clazz == null) {
                return null;
            }
            Renderer<Object> renderer2 = RENDERERS.get(clazz);
            if (renderer2 != null) {
                return renderer2;
            }
            for (Class<?> aClass : interfaces = clazz.getInterfaces()) {
                renderer2 = ValueCellRenderer.getRenderer(aClass);
                if (renderer2 == null) continue;
                return renderer2;
            }
            if ((clazz = clazz.getSuperclass()) != null) {
                return ValueCellRenderer.getRenderer(clazz);
            }
            return null;
        }

        static {
            RENDERERS.put(Point.class, new PointRenderer());
            RENDERERS.put(Dimension.class, new DimensionRenderer());
            RENDERERS.put(Insets.class, new InsetsRenderer());
            RENDERERS.put(Rectangle.class, new RectangleRenderer());
            RENDERERS.put(Color.class, new ColorRenderer());
            RENDERERS.put(Font.class, new FontRenderer());
            RENDERERS.put(Boolean.class, new BooleanRenderer());
            RENDERERS.put(Icon.class, new IconRenderer());
            RENDERERS.put(Border.class, new BorderRenderer());
            DEFAULT_RENDERER = new ObjectRenderer();
            NULL_RENDERER = new JLabel("-");
        }
    }

    private static class DimensionsComponent
    extends JComponent {
        Component myComponent;
        int myWidth;
        int myHeight;
        Border myBorder;
        Insets myInsets;

        private DimensionsComponent(@NotNull Component component) {
            this.myComponent = component;
            this.setOpaque(true);
            this.setBackground((Color)JBColor.WHITE);
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
            this.setFont((Font)JBUI.Fonts.label((float)9.0f));
            this.update();
        }

        public void update() {
            this.myWidth = this.myComponent.getWidth();
            this.myHeight = this.myComponent.getHeight();
            if (this.myComponent instanceof JComponent) {
                this.myBorder = ((JComponent)this.myComponent).getBorder();
                this.myInsets = ((JComponent)this.myComponent).getInsets();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            GraphicsConfig config2 = new GraphicsConfig(g).setAntialiasing(UISettings.getShadowInstance().getIdeAAType() != AntialiasingType.OFF);
            Rectangle bounds2 = this.getBounds();
            g2d.setColor(this.getBackground());
            Insets insets = this.getInsets();
            g2d.fillRect(insets.left, insets.top, bounds2.width - insets.left - insets.right, bounds2.height - insets.top - insets.bottom);
            String sizeString = String.format("%d x %d", this.myWidth, this.myHeight);
            FontMetrics fm = g2d.getFontMetrics();
            int sizeWidth = fm.stringWidth(sizeString);
            int fontHeight = fm.getHeight();
            int innerBoxWidthGap = JBUI.scale((int)20);
            int innerBoxHeightGap = JBUI.scale((int)5);
            int boxSize = JBUI.scale((int)15);
            int centerX = bounds2.width / 2;
            int centerY = bounds2.height / 2;
            int innerX = centerX - sizeWidth / 2 - innerBoxWidthGap;
            int innerY = centerY - fontHeight / 2 - innerBoxHeightGap;
            int innerWidth = sizeWidth + innerBoxWidthGap * 2;
            int innerHeight = fontHeight + innerBoxHeightGap * 2;
            g2d.setColor(this.getForeground());
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, sizeString, centerX, centerY);
            g2d.setColor((Color)JBColor.GRAY);
            g2d.drawRect(innerX, innerY, innerWidth, innerHeight);
            Insets borderInsets = null;
            if (this.myBorder != null) {
                borderInsets = this.myBorder.getBorderInsets(this.myComponent);
            }
            UIUtil.drawDottedRectangle((Graphics)g2d, (int)(innerX - boxSize), (int)(innerY - boxSize), (int)(innerX + innerWidth + boxSize), (int)(innerY + innerHeight + boxSize));
            DimensionsComponent.drawInsets(g2d, fm, "border", borderInsets, boxSize, fontHeight, innerX, innerY, innerWidth, innerHeight);
            g2d.drawRect(innerX - boxSize * 2, innerY - boxSize * 2, innerWidth + boxSize * 4, innerHeight + boxSize * 4);
            DimensionsComponent.drawInsets(g2d, fm, "insets", this.myInsets, boxSize * 2, fontHeight, innerX, innerY, innerWidth, innerHeight);
            config2.restore();
        }

        private static void drawInsets(Graphics2D g2d, FontMetrics fm, String name, Insets insets, int offset, int fontHeight, int innerX, int innerY, int innerWidth, int innerHeight) {
            g2d.setColor((Color)JBColor.BLACK);
            g2d.drawString(name, innerX - offset + JBUI.scale((int)5), innerY - offset + fontHeight);
            g2d.setColor((Color)JBColor.GRAY);
            int outerX = innerX - offset;
            int outerWidth = innerWidth + offset * 2;
            int outerY = innerY - offset;
            int outerHeight = innerHeight + offset * 2;
            String top = insets != null ? Integer.toString(insets.top) : "-";
            String bottom = insets != null ? Integer.toString(insets.bottom) : "-";
            String left = insets != null ? Integer.toString(insets.left) : "-";
            String right = insets != null ? Integer.toString(insets.right) : "-";
            int shift = JBUI.scale((int)7);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, top, outerX + outerWidth / 2, outerY + shift);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, bottom, outerX + outerWidth / 2, outerY + outerHeight - shift);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, left, outerX + shift, outerY + outerHeight / 2);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, right, outerX + outerWidth - shift, outerY + outerHeight / 2);
        }

        @Override
        public Dimension getMinimumSize() {
            return JBUI.size((int)120);
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)150);
        }
    }

    private static class InspectorTable
    extends JPanel {
        InspectorTableModel myModel;
        DimensionsComponent myDimensionComponent;

        private InspectorTable(@NotNull List<PropertyBean> clickInfo) {
            this.myModel = new InspectorTableModel(clickInfo);
            this.init(null);
        }

        private InspectorTable(@NotNull Component component) {
            this.myModel = new InspectorTableModel(component);
            this.init(component);
        }

        private void init(final @Nullable Component component) {
            this.setLayout(new BorderLayout());
            final StripeTable table = new StripeTable((TableModel)this.myModel);
            new TableSpeedSearch((JTable)table);
            TableColumnModel columnModel = table.getColumnModel();
            TableColumn propertyColumn = columnModel.getColumn(0);
            propertyColumn.setMinWidth(JBUI.scale((int)200));
            propertyColumn.setMaxWidth(JBUI.scale((int)200));
            propertyColumn.setResizable(false);
            propertyColumn.setCellRenderer(new PropertyNameRenderer());
            TableColumn valueColumn = columnModel.getColumn(1);
            valueColumn.setMinWidth(JBUI.scale((int)200));
            valueColumn.setResizable(false);
            valueColumn.setCellRenderer(new ValueCellRenderer());
            valueColumn.setCellEditor(new DefaultCellEditor((JTextField)new JBTextField()){

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row2, int column) {
                    Component comp = table.getCellRenderer(row2, column).getTableCellRendererComponent(table, value, false, false, row2, column);
                    if (comp instanceof JLabel) {
                        value = ((JLabel)comp).getText();
                    }
                    Component result2 = super.getTableCellEditorComponent(table, value, isSelected, row2, column);
                    ((JComponent)result2).setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY, 1));
                    return result2;
                }
            });
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent event) {
                    Component renderer2;
                    int row2 = table.rowAtPoint(event.getPoint());
                    int column = table.columnAtPoint(event.getPoint());
                    if (row2 >= 0 && row2 < table.getRowCount() && column >= 0 && column < table.getColumnCount() && (renderer2 = table.getCellRenderer(row2, column).getTableCellRendererComponent((JTable)table, myModel.getValueAt(row2, column), false, false, row2, column)) instanceof JLabel) {
                        System.out.println((component != null ? UiInspectorAction.getComponentName(component) + " " : "") + ((JLabel)renderer2).getText().replace("\r", "").replace("\tat", "\n\tat"));
                        return true;
                    }
                    return false;
                }
            }.installOn((Component)table);
            table.setAutoResizeMode(3);
            this.add((Component)new JBScrollPane((Component)table), "Center");
            if (component != null) {
                this.myDimensionComponent = new DimensionsComponent(component);
                this.add((Component)this.myDimensionComponent, "South");
            }
        }

        public void refresh() {
            this.myModel.refresh();
            this.myDimensionComponent.update();
            this.myDimensionComponent.repaint();
        }

        private static class PropertyNameRenderer
        extends DefaultTableCellRenderer {
            private PropertyNameRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row2, column);
                TableModel model = table.getModel();
                boolean changed = false;
                if (model instanceof InspectorTableModel) {
                    changed = ((InspectorTableModel)model).myProperties.get((int)row2).changed;
                }
                Color fg = isSelected ? table.getSelectionForeground() : (changed ? JBUI.CurrentTheme.Link.linkColor() : table.getForeground());
                JBFont font = JBUI.Fonts.label();
                this.setFont((Font)(changed ? font.asBold() : font));
                this.setForeground(fg);
                return this;
            }
        }
    }

    private static class HighlightComponent
    extends JComponent {
        Color myColor;

        private HighlightComponent(@NotNull Color c) {
            this.myColor = c;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            Composite old = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
            Rectangle r = this.getBounds();
            RectanglePainter.paint((Graphics2D)g2d, (int)0, (int)0, (int)r.width, (int)r.height, (int)0, (Paint)this.myColor, (Paint)this.myColor.darker());
            g2d.setComposite(old);
            g2d.setColor(oldColor);
        }
    }

    private static abstract class HierarchyTree
    extends JTree
    implements TreeSelectionListener {
        final Component myComponent;

        private HierarchyTree(Component c) {
            this.myComponent = c;
            this.setModel(UiInspectorAction.buildModel(c));
            this.setCellRenderer((TreeCellRenderer)((Object)new ComponentTreeCellRenderer(c)));
            this.getSelectionModel().addTreeSelectionListener(this);
            new TreeSpeedSearch(this);
            if (c instanceof JComponent && ((JComponent)c).getClientProperty(UiInspectorAction.CLICK_INFO) != null) {
                SwingUtilities.invokeLater(() -> this.getSelectionModel().setSelectionPath(this.getPathForRow(this.getLeadSelectionRow() + 1)));
            }
        }

        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (value instanceof ComponentNode) {
                Pair pair = UiInspectorAction.getClassAndFieldName(((ComponentNode)value).myComponent);
                if (pair != null) {
                    return ((Class)pair.first).getSimpleName() + '.' + (String)pair.second;
                }
                return this.myComponent.getClass().getName();
            }
            return super.convertValueToText(value, selected, expanded, leaf, row2, hasFocus);
        }

        public void expandPath() {
            TreeUtil.expandAll((JTree)this);
            int count = this.getRowCount();
            ComponentNode node = new ComponentNode(this.myComponent);
            for (int i = 0; i < count; ++i) {
                TreePath row2 = this.getPathForRow(i);
                if (!row2.getLastPathComponent().equals(node)) continue;
                this.setSelectionPath(row2);
                this.scrollPathToVisible(this.getSelectionPath());
                break;
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getNewLeadSelectionPath();
            if (path == null) {
                this.onComponentChanged((Component)null);
                return;
            }
            Object component = path.getLastPathComponent();
            if (component instanceof ComponentNode) {
                Component c = ((ComponentNode)component).getComponent();
                this.onComponentChanged(c);
            }
            if (component instanceof ClickInfoNode) {
                this.onComponentChanged(((ClickInfoNode)component).getInfo());
            }
        }

        public abstract void onComponentChanged(List<PropertyBean> var1);

        public abstract void onComponentChanged(Component var1);

        private static class ClickInfoNode
        extends DefaultMutableTreeNode {
            private final List<PropertyBean> myInfo;

            ClickInfoNode(List<PropertyBean> info) {
                this.myInfo = info;
            }

            @Override
            public String toString() {
                return "Clicked Info";
            }

            public List<PropertyBean> getInfo() {
                return this.myInfo;
            }

            @Override
            public boolean isLeaf() {
                return true;
            }
        }

        private static class ComponentNode
        extends DefaultMutableTreeNode {
            private final Component myComponent;
            String myText;

            private ComponentNode(@NotNull Component component) {
                super(component);
                this.myComponent = component;
                this.children = ComponentNode.prepareChildren(this.myComponent);
            }

            Component getComponent() {
                return this.myComponent;
            }

            @Override
            public String toString() {
                return this.myText != null ? this.myText : this.myComponent.getClass().getName();
            }

            public void setText(String value) {
                this.myText = value;
            }

            public boolean equals(Object obj) {
                return obj instanceof ComponentNode && ((ComponentNode)obj).getComponent() == this.getComponent();
            }

            private static Vector prepareChildren(Component parent) {
                Component[] o;
                Vector<DefaultMutableTreeNode> result2 = new Vector<DefaultMutableTreeNode>();
                if (parent instanceof JComponent && (o = ((JComponent)parent).getClientProperty(UiInspectorAction.CLICK_INFO)) instanceof List) {
                    result2.add(new ClickInfoNode((List)o));
                }
                if (parent instanceof Container) {
                    for (Component component : ((Container)parent).getComponents()) {
                        result2.add(new ComponentNode(component));
                    }
                }
                if (parent instanceof Window) {
                    Window[] children2;
                    for (Window child2 : children2 = ((Window)parent).getOwnedWindows()) {
                        if (child2 instanceof InspectorWindow) continue;
                        result2.add(new ComponentNode(child2));
                    }
                }
                return result2;
            }
        }
    }

    private static class ComponentTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Component myInitialSelection;

        ComponentTreeCellRenderer(Component initialSelection) {
            this.myInitialSelection = initialSelection;
            this.setFont((Font)JBUI.Fonts.label((float)11.0f));
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            Color background;
            Color foreground = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
            Color color = background = selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : null;
            if (value instanceof HierarchyTree.ComponentNode) {
                HierarchyTree.ComponentNode componentNode = (HierarchyTree.ComponentNode)value;
                Component component = componentNode.getComponent();
                if (!selected) {
                    if (!component.isVisible()) {
                        foreground = JBColor.GRAY;
                    } else if (component.getWidth() == 0 || component.getHeight() == 0) {
                        foreground = new JBColor(new Color(128, 10, 0), (Color)JBColor.BLUE);
                    } else if (component.getPreferredSize() != null && (component.getSize().width < component.getPreferredSize().width || component.getSize().height < component.getPreferredSize().height)) {
                        foreground = PlatformColors.BLUE;
                    }
                    if (this.myInitialSelection == componentNode.getComponent()) {
                        background = new Color(31, 128, 8, 58);
                    }
                }
                this.append(UiInspectorAction.getComponentName(component));
                Pair class2field = UiInspectorAction.getClassAndFieldName(component);
                if (class2field != null) {
                    this.append("(" + (String)class2field.second + "@" + ((Class)class2field.first).getSimpleName() + ")");
                }
                this.append(": " + RectangleRenderer.toString(component.getBounds()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                if (component.isOpaque()) {
                    this.append(", opaque", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                if (component.isDoubleBuffered()) {
                    this.append(", double-buffered", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                if (DataManagerImpl.getDataProviderEx(component) != null) {
                    this.append(", ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.append("data-provider", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
                componentNode.setText(this.toString());
                this.setIcon(UiInspectorAction.createColorIcon(component.getBackground(), component.getForeground()));
            }
            if (value instanceof HierarchyTree.ClickInfoNode) {
                this.append(value.toString());
                this.setIcon(AllIcons.Ide.Rating);
            }
            this.setForeground(foreground);
            this.setBackground(background);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
        }
    }

    private static class InspectorWindow
    extends JDialog {
        private InspectorTable myInspectorTable;
        private Component myComponent;
        private List<PropertyBean> myInfo;
        private final Component myInitialComponent;
        private HighlightComponent myHighlightComponent;
        private final HierarchyTree myHierarchyTree;
        private final JPanel myWrapperPanel;

        private InspectorWindow(@NotNull Component component) throws HeadlessException {
            super(InspectorWindow.findWindow(component));
            Window window = InspectorWindow.findWindow(component);
            this.setModal(window instanceof JDialog && ((JDialog)window).isModal());
            this.myComponent = component;
            this.myInitialComponent = component;
            this.getRootPane().setBorder(JBUI.Borders.empty((int)5));
            this.setDefaultCloseOperation(2);
            this.setLayout(new BorderLayout());
            this.setTitle(component.getClass().getName());
            Dimension size = DimensionService.getInstance().getSize(InspectorWindow.getDimensionServiceKey());
            Point location = DimensionService.getInstance().getLocation(InspectorWindow.getDimensionServiceKey());
            if (size != null) {
                this.setSize(size);
            }
            if (location != null) {
                this.setLocation(location);
            }
            DefaultActionGroup actions = new DefaultActionGroup();
            actions.addAction((AnAction)new IconWithTextAction("Highlight"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    this.setHighlightingEnabled(myHighlightComponent == null);
                }

                public void update(@NotNull AnActionEvent e) {
                    e.getPresentation().setEnabled(myInfo != null || myComponent != null && myComponent.isVisible());
                }
            });
            actions.addSeparator();
            actions.add((AnAction)new IconWithTextAction("Refresh"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    this.getCurrentTable().refresh();
                }

                public void update(@NotNull AnActionEvent e) {
                    e.getPresentation().setEnabled(myComponent != null && myComponent.isVisible());
                }
            });
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ContextToolbar", (ActionGroup)actions, true);
            this.add((Component)toolbar.getComponent(), "North");
            this.myWrapperPanel = new JPanel(new BorderLayout());
            this.myInspectorTable = new InspectorTable(component);
            this.myHierarchyTree = new HierarchyTree(component){

                @Override
                public void onComponentChanged(Component c) {
                    boolean wasHighlighted = myHighlightComponent != null;
                    this.setHighlightingEnabled(false);
                    this.switchInfo(c);
                    this.setHighlightingEnabled(wasHighlighted);
                }

                @Override
                public void onComponentChanged(List<PropertyBean> info) {
                    boolean wasHighlighted = myHighlightComponent != null;
                    this.setHighlightingEnabled(false);
                    this.switchInfo(info);
                    this.setHighlightingEnabled(wasHighlighted);
                }
            };
            this.myWrapperPanel.add((Component)this.myInspectorTable, "Center");
            JBSplitter splitPane = new JBSplitter(false, "UiInspector.splitter.proportion", 0.5f);
            splitPane.setSecondComponent((JComponent)this.myWrapperPanel);
            splitPane.setFirstComponent((JComponent)new JBScrollPane((Component)this.myHierarchyTree));
            this.add((Component)splitPane, "Center");
            this.myHierarchyTree.expandPath();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    this.close();
                }
            });
            this.getRootPane().getActionMap().put("CLOSE", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.close();
                }
            });
            this.setHighlightingEnabled(true);
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CLOSE");
        }

        private static String getDimensionServiceKey() {
            return "UiInspectorWindow";
        }

        private static Window findWindow(Component component) {
            DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)component);
            if (dialogWrapper != null) {
                return dialogWrapper.getPeer().getWindow();
            }
            return null;
        }

        private InspectorTable getCurrentTable() {
            return this.myInspectorTable;
        }

        private void switchInfo(@Nullable Component c) {
            if (c == null) {
                return;
            }
            this.myComponent = c;
            this.myInfo = null;
            this.setTitle(this.myComponent.getClass().getName());
            this.myWrapperPanel.removeAll();
            this.myInspectorTable = new InspectorTable(c);
            this.myWrapperPanel.add((Component)this.myInspectorTable, "Center");
            this.myWrapperPanel.revalidate();
            this.myWrapperPanel.repaint();
        }

        private void switchInfo(@NotNull List<PropertyBean> clickInfo) {
            this.myComponent = null;
            this.myInfo = clickInfo;
            this.setTitle("Click Info");
            this.myWrapperPanel.removeAll();
            this.myInspectorTable = new InspectorTable(clickInfo);
            this.myWrapperPanel.add((Component)this.myInspectorTable, "Center");
            this.myWrapperPanel.revalidate();
            this.myWrapperPanel.repaint();
        }

        @Override
        public void dispose() {
            DimensionService.getInstance().setSize(InspectorWindow.getDimensionServiceKey(), this.getSize());
            DimensionService.getInstance().setLocation(InspectorWindow.getDimensionServiceKey(), this.getLocation());
            super.dispose();
            DialogWrapper.cleanupRootPane((JRootPane)this.rootPane);
            DialogWrapper.cleanupWindowListeners((Window)this);
        }

        public void close() {
            if (this.myInitialComponent instanceof JComponent) {
                ((JComponent)this.myInitialComponent).putClientProperty(UiInspectorAction.CLICK_INFO, null);
            }
            this.myInfo = null;
            this.setHighlightingEnabled(false);
            if (this.myComponent == null) {
                return;
            }
            this.myComponent = null;
            this.setVisible(false);
            this.dispose();
        }

        private void setHighlightingEnabled(boolean enable) {
            JComponent glassPane;
            if (this.myHighlightComponent != null) {
                glassPane = InspectorWindow.getGlassPane(this.myHighlightComponent);
                if (glassPane != null) {
                    glassPane.remove(this.myHighlightComponent);
                    glassPane.revalidate();
                    glassPane.repaint();
                }
                this.myHighlightComponent = null;
            }
            if (enable && this.myComponent != null && (glassPane = InspectorWindow.getGlassPane(this.myComponent)) != null) {
                this.myHighlightComponent = new HighlightComponent((Color)new JBColor((Color)JBColor.GREEN, (Color)JBColor.RED));
                Point pt = SwingUtilities.convertPoint(this.myComponent, new Point(0, 0), glassPane);
                this.myHighlightComponent.setBounds(pt.x, pt.y, this.myComponent.getWidth(), this.myComponent.getHeight());
                glassPane.add(this.myHighlightComponent);
                glassPane.revalidate();
                glassPane.repaint();
            }
            if (enable & this.myInfo != null && this.myInitialComponent != null) {
                JComponent glassPane2;
                Rectangle bounds2 = null;
                for (PropertyBean bean : this.myInfo) {
                    if (!UiInspectorAction.RENDERER_BOUNDS.equals(bean.propertyName)) continue;
                    bounds2 = (Rectangle)bean.propertyValue;
                    break;
                }
                if (bounds2 != null && (glassPane2 = InspectorWindow.getGlassPane(this.myInitialComponent)) != null) {
                    this.myHighlightComponent = new HighlightComponent((Color)new JBColor((Color)JBColor.GREEN, (Color)JBColor.RED));
                    bounds2 = SwingUtilities.convertRectangle(this.myInitialComponent, bounds2, glassPane2);
                    this.myHighlightComponent.setBounds(bounds2);
                    glassPane2.add(this.myHighlightComponent);
                    glassPane2.revalidate();
                    glassPane2.repaint();
                }
            }
        }

        @Nullable
        private static JComponent getGlassPane(@NotNull Component component) {
            JRootPane rootPane = SwingUtilities.getRootPane(component);
            return rootPane == null ? null : (JComponent)rootPane.getGlassPane();
        }
    }

    private static class UiInspectorNotification
    extends Notification {
        private UiInspectorNotification() {
            super("System Messages", "UI Inspector", "Control-Alt-Click to view component info!", NotificationType.INFORMATION);
        }
    }
}

