/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.internal.psiView.PsiViewerExtension;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiViewerSourceWrapper
implements Comparable<PsiViewerSourceWrapper> {
    final FileType myFileType;
    final PsiViewerExtension myExtension;

    PsiViewerSourceWrapper(@NotNull FileType fileType) {
        this.myFileType = fileType;
        this.myExtension = null;
    }

    PsiViewerSourceWrapper(PsiViewerExtension extension) {
        this.myFileType = null;
        this.myExtension = extension;
    }

    public String getText() {
        return this.myFileType != null ? this.myFileType.getName() + " file" : this.myExtension.getName();
    }

    @Nullable
    public Icon getIcon() {
        return this.myFileType != null ? this.myFileType.getIcon() : this.myExtension.getIcon();
    }

    @Override
    public int compareTo(@NotNull PsiViewerSourceWrapper o) {
        return this.getText().compareToIgnoreCase(o.getText());
    }

    @NotNull
    public static List<PsiViewerSourceWrapper> getExtensionBasedWrappers() {
        return ContainerUtil.map((Collection)PsiViewerExtension.EP_NAME.getExtensionList(), el -> new PsiViewerSourceWrapper((PsiViewerExtension)el));
    }

    @NotNull
    public static List<PsiViewerSourceWrapper> getFileTypeBasedWrappers() {
        HashSet allFileTypes = ContainerUtil.newHashSet();
        ArrayList sourceWrappers = ContainerUtil.newArrayList();
        Collections.addAll(allFileTypes, FileTypeManager.getInstance().getRegisteredFileTypes());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType = language.getAssociatedFileType();
            if (fileType == null) continue;
            allFileTypes.add(fileType);
        }
        for (FileType fileType : allFileTypes) {
            if (!PsiViewerSourceWrapper.isAcceptableFileType(fileType)) continue;
            PsiViewerSourceWrapper wrapper2 = new PsiViewerSourceWrapper(fileType);
            sourceWrappers.add(wrapper2);
        }
        return sourceWrappers;
    }

    private static boolean isAcceptableFileType(FileType fileType) {
        return fileType != StdFileTypes.GUI_DESIGNER_FORM && fileType != StdFileTypes.IDEA_MODULE && fileType != StdFileTypes.IDEA_PROJECT && fileType != StdFileTypes.IDEA_WORKSPACE && fileType != ArchiveFileType.INSTANCE && fileType != FileTypes.UNKNOWN && fileType != FileTypes.PLAIN_TEXT && !(fileType instanceof AbstractFileType) && !fileType.isBinary() && !fileType.isReadOnly();
    }
}

