/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView.formattingblocks;

import com.intellij.application.options.CodeStyle;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.internal.psiView.PsiViewerDialog;
import com.intellij.internal.psiView.ViewerPsiBasedTree;
import com.intellij.internal.psiView.formattingblocks.BlockTreeNode;
import com.intellij.internal.psiView.formattingblocks.BlockTreeStructure;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockViewerPsiBasedTree
implements ViewerPsiBasedTree {
    @NotNull
    private final JPanel myBlockStructurePanel;
    @NotNull
    private final Tree myBlockTree;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ViewerPsiBasedTree.PsiTreeUpdater myUpdater;
    @Nullable
    private volatile HashMap<PsiElement, BlockTreeNode> myPsiToBlockMap;
    private AsyncTreeModel myTreeModel;
    private Disposable myTreeModelDisposable = Disposer.newDisposable();

    public BlockViewerPsiBasedTree(@NotNull Project project, @NotNull ViewerPsiBasedTree.PsiTreeUpdater updater) {
        this.myProject = project;
        this.myUpdater = updater;
        this.myBlockTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myBlockStructurePanel = new JPanel(new BorderLayout());
        this.myBlockStructurePanel.add(ScrollPaneFactory.createScrollPane((Component)this.myBlockTree));
        this.myBlockStructurePanel.setBorder(IdeBorderFactory.createBorder());
        PsiViewerDialog.initTree((JTree)this.myBlockTree);
    }

    @Override
    public void reloadTree(@Nullable PsiElement rootRootElement, @NotNull String text) {
        this.resetBlockTree();
        this.buildBlockTree(rootRootElement);
    }

    @Override
    public void selectNodeFromPsi(@Nullable PsiElement element) {
        BlockTreeNode currentBlockNode;
        if (this.myTreeModel != null && element != null && (currentBlockNode = this.findBlockNode(element)) != null) {
            this.selectBlockNode(currentBlockNode);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myBlockStructurePanel;
    }

    @Override
    public boolean isFocusOwner() {
        return this.myBlockTree.isFocusOwner();
    }

    @Override
    public void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myBlockTree, true);
    }

    public void dispose() {
        this.resetBlockTree();
    }

    private void resetBlockTree() {
        this.myBlockTree.removeAll();
        if (this.myTreeModel != null) {
            Disposer.dispose((Disposable)this.myTreeModelDisposable);
            this.myTreeModel = null;
            this.myTreeModelDisposable = Disposer.newDisposable();
        }
        this.myPsiToBlockMap = null;
        ViewerPsiBasedTree.removeListenerOfClass(this.myBlockTree, BlockTreeSelectionListener.class);
    }

    private void buildBlockTree(@Nullable PsiElement rootElement) {
        Block rootBlock;
        Block block = rootBlock = rootElement == null ? null : BlockViewerPsiBasedTree.buildBlocks(rootElement);
        if (rootBlock == null) {
            this.myTreeModel = null;
            this.myBlockTree.setRootVisible(false);
            this.myBlockTree.setVisible(false);
            return;
        }
        this.myBlockTree.setVisible(true);
        BlockTreeStructure blockTreeStructure = new BlockTreeStructure();
        BlockTreeNode rootNode = new BlockTreeNode(rootBlock, null);
        StructureTreeModel<BlockTreeStructure> treeModel = new StructureTreeModel<BlockTreeStructure>(blockTreeStructure);
        this.initMap(rootNode, rootElement);
        assert (this.myPsiToBlockMap != null);
        PsiElement rootPsi = rootNode.getBlock() instanceof ASTBlock ? ((ASTBlock)rootNode.getBlock()).getNode().getPsi() : rootElement;
        BlockTreeNode blockNode = this.myPsiToBlockMap.get(rootPsi);
        if (blockNode == null) {
            PsiViewerDialog.LOG.error("PsiViewer: rootNode not found\nCurrent language: " + rootElement.getContainingFile().getLanguage(), (Throwable)null, new Attachment[]{AttachmentFactory.createAttachment(rootElement.getContainingFile().getOriginalFile().getVirtualFile())});
            blockNode = this.findBlockNode(rootPsi);
        }
        blockTreeStructure.setRoot(blockNode);
        this.myTreeModel = new AsyncTreeModel((TreeModel)((Object)treeModel), this.myTreeModelDisposable);
        this.myBlockTree.setModel((TreeModel)((Object)this.myTreeModel));
        this.myBlockTree.addTreeSelectionListener((TreeSelectionListener)new BlockTreeSelectionListener(rootElement));
        this.myBlockTree.setRootVisible(true);
        this.myBlockTree.expandRow(0);
        treeModel.invalidate();
    }

    @Nullable
    private BlockTreeNode findBlockNode(PsiElement element) {
        BlockTreeNode result2;
        HashMap<PsiElement, BlockTreeNode> psiToBlockMap = this.myPsiToBlockMap;
        BlockTreeNode blockTreeNode = result2 = psiToBlockMap == null ? null : psiToBlockMap.get(element);
        if (result2 == null) {
            TextRange rangeInHostFile = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost(element, element.getTextRange());
            result2 = this.findBlockNode(rangeInHostFile);
        }
        return result2;
    }

    @NotNull
    private TreeVisitor createVisitor(@NotNull BlockTreeNode currentBlockNode) {
        Function converter = el -> el instanceof DefaultMutableTreeNode ? (BlockTreeNode)((Object)((Object)((DefaultMutableTreeNode)el).getUserObject())) : null;
        final HashSet parents = ContainerUtil.newHashSet();
        for (SimpleNode parent = currentBlockNode.getParent(); parent != null; parent = parent.getParent()) {
            parents.add(parent);
        }
        DefaultMutableTreeNode root = this.getRoot();
        if (root != null) {
            parents.add((SimpleNode)root.getUserObject());
        }
        return new TreeVisitor.ByComponent<BlockTreeNode, BlockTreeNode>(currentBlockNode, converter){

            protected boolean contains(@NotNull BlockTreeNode pathComponent, @NotNull BlockTreeNode thisComponent) {
                return parents.contains((Object)pathComponent);
            }
        };
    }

    private void selectBlockNode(@Nullable BlockTreeNode currentBlockNode) {
        if (this.myTreeModel == null) {
            return;
        }
        if (currentBlockNode != null) {
            TreeUtil.promiseSelect((JTree)this.myBlockTree, (TreeVisitor)this.createVisitor(currentBlockNode));
        } else {
            this.myBlockTree.getSelectionModel().clearSelection();
        }
    }

    @Nullable
    private BlockTreeNode findBlockNode(TextRange range2) {
        if (this.myTreeModel == null || !this.myBlockStructurePanel.isVisible()) {
            return null;
        }
        DefaultMutableTreeNode root = this.getRoot();
        if (root == null) {
            return null;
        }
        BlockTreeNode node = (BlockTreeNode)((Object)root.getUserObject());
        block0: while (true) {
            if (node.getBlock().getTextRange().equals((Object)range2)) {
                return node;
            }
            for (BlockTreeNode child2 : node.getChildren()) {
                if (!child2.getBlock().getTextRange().contains(range2)) continue;
                node = child2;
                continue block0;
            }
            break;
        }
        return node;
    }

    @Nullable
    private static Block buildBlocks(@NotNull PsiElement rootElement) {
        FormattingModelBuilder formattingModelBuilder = LanguageFormatting.INSTANCE.forContext(rootElement);
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)rootElement.getContainingFile());
        if (formattingModelBuilder != null) {
            FormattingModel formattingModel = formattingModelBuilder.createModel(rootElement, settings);
            return formattingModel.getRootBlock();
        }
        return null;
    }

    private void initMap(BlockTreeNode rootBlockNode, PsiElement psiEl) {
        this.myPsiToBlockMap = new HashMap();
        JBTreeTraverser traverser = JBTreeTraverser.of(BlockTreeNode::getChildren);
        for (BlockTreeNode block : (JBTreeTraverser)traverser.withRoot((Object)rootBlockNode)) {
            ASTNode node;
            PsiElement currentElem = null;
            if (block.getBlock() instanceof ASTBlock && (node = ((ASTBlock)block.getBlock()).getNode()) != null) {
                currentElem = node.getPsi();
            }
            if (currentElem == null) {
                currentElem = InjectedLanguageUtil.findElementAtNoCommit(psiEl.getContainingFile(), block.getBlock().getTextRange().getStartOffset());
            }
            this.myPsiToBlockMap.put(currentElem, block);
            TextRange curTextRange = currentElem.getTextRange();
            for (PsiElement parentElem = currentElem.getParent(); parentElem != null && parentElem.getTextRange().equals((Object)curTextRange); parentElem = parentElem.getParent()) {
                this.myPsiToBlockMap.put(parentElem, block);
            }
        }
    }

    @Nullable
    private DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.myBlockTree.getModel().getRoot();
    }

    public class BlockTreeSelectionListener
    implements TreeSelectionListener {
        @NotNull
        private final PsiElement myRootElement;

        public BlockTreeSelectionListener(PsiElement rootElement) {
            this.myRootElement = rootElement;
        }

        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            if (BlockViewerPsiBasedTree.this.myTreeModel == null) {
                return;
            }
            TreePath path = BlockViewerPsiBasedTree.this.myBlockTree.getSelectionModel().getSelectionPath();
            if (path == null) {
                return;
            }
            DefaultMutableTreeNode component = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (component == null) {
                return;
            }
            Object item = component.getUserObject();
            if (!(item instanceof BlockTreeNode)) {
                return;
            }
            BlockTreeNode descriptor = (BlockTreeNode)((Object)item);
            int blockStart = descriptor.getBlock().getTextRange().getStartOffset();
            PsiFile file2 = this.myRootElement.getContainingFile();
            PsiElement currentPsiEl = InjectedLanguageUtil.findElementAtNoCommit(file2, blockStart);
            if (currentPsiEl == null) {
                currentPsiEl = file2;
            }
            int blockLength = descriptor.getBlock().getTextRange().getLength();
            while (currentPsiEl.getParent() != null && currentPsiEl.getTextRange().getStartOffset() == blockStart && currentPsiEl.getTextLength() != blockLength) {
                currentPsiEl = currentPsiEl.getParent();
            }
            BlockTreeNode rootBlockNode = (BlockTreeNode)((Object)BlockViewerPsiBasedTree.this.getRoot().getUserObject());
            int baseOffset = 0;
            if (rootBlockNode != null) {
                baseOffset = rootBlockNode.getBlock().getTextRange().getStartOffset();
            }
            TextRange range2 = descriptor.getBlock().getTextRange();
            range2 = range2.shiftRight(-baseOffset);
            BlockViewerPsiBasedTree.this.myUpdater.updatePsiTree(currentPsiEl, (TextRange)(BlockViewerPsiBasedTree.this.myBlockTree.hasFocus() ? range2 : null));
        }
    }
}

