/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView.stubtree;

import com.intellij.internal.psiView.PsiViewerDialog;
import com.intellij.internal.psiView.ViewerPsiBasedTree;
import com.intellij.internal.psiView.stubtree.StubTreeNode;
import com.intellij.internal.psiView.stubtree.StubTreeStructure;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubViewerPsiBasedTree
implements ViewerPsiBasedTree {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.psiView.PsiViewerDialog");
    @Nullable
    private AbstractTreeModel myTreeModel;
    @NotNull
    private final Tree myStubTree;
    @Nullable
    private JPanel myPanel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ViewerPsiBasedTree.PsiTreeUpdater myUpdater;
    @NotNull
    private volatile Map<ASTNode, StubElement> myNodeToStubs = new BidirectionalMap();
    private Disposable myTreeModelDisposable = Disposer.newDisposable();

    public StubViewerPsiBasedTree(@NotNull Project project, @NotNull ViewerPsiBasedTree.PsiTreeUpdater updater) {
        this.myProject = project;
        this.myUpdater = updater;
        this.myStubTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    @Override
    public void reloadTree(@Nullable PsiElement rootRootElement, @NotNull String text) {
        this.resetStubTree();
        this.buildStubTree(rootRootElement, text);
    }

    private void resetStubTree() {
        this.myStubTree.removeAll();
        if (this.myTreeModel != null) {
            Disposer.dispose((Disposable)this.myTreeModelDisposable);
            this.myTreeModel = null;
            this.myTreeModelDisposable = Disposer.newDisposable();
        }
        this.myNodeToStubs = new BidirectionalMap();
        ViewerPsiBasedTree.removeListenerOfClass(this.myStubTree, StubTreeSelectionListener.class);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        if (this.myPanel != null) {
            return this.myPanel;
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add(ScrollPaneFactory.createScrollPane((Component)this.myStubTree));
        panel2.setBorder(IdeBorderFactory.createBorder());
        PsiViewerDialog.initTree((JTree)this.myStubTree);
        this.myPanel = panel2;
        return panel2;
    }

    @Override
    public boolean isFocusOwner() {
        return this.myStubTree.isFocusOwner();
    }

    @Override
    public void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myStubTree, true);
    }

    private synchronized void buildStubTree(@Nullable PsiElement rootElement, @NotNull String textToParse) {
        if (rootElement == null) {
            this.myStubTree.setRootVisible(false);
            return;
        }
        if (!(rootElement instanceof PsiFileWithStubSupport)) {
            this.myStubTree.setRootVisible(false);
            StatusText text = this.myStubTree.getEmptyText();
            if (rootElement instanceof PsiFile) {
                text.setText("No stubs for " + rootElement.getLanguage().getDisplayName());
            } else {
                text.setText("Cannot build stub tree for code fragments");
            }
            return;
        }
        Stub stub = StubViewerPsiBasedTree.buildStubForElement(this.myProject, rootElement, textToParse);
        if (stub instanceof PsiFileStub) {
            PsiFileWithStubSupport file2 = (PsiFileWithStubSupport)rootElement;
            StubTreeNode rootNode = new StubTreeNode((StubElement)stub, null);
            StructureTreeModel<StubTreeStructure> treeModel = new StructureTreeModel<StubTreeStructure>(new StubTreeStructure(rootNode));
            this.myTreeModel = new AsyncTreeModel((TreeModel)((Object)treeModel), this.myTreeModelDisposable);
            this.myStubTree.setModel((TreeModel)this.myTreeModel);
            this.fillPsiToStubCache(file2, (PsiFileStub)stub);
            this.myStubTree.setRootVisible(true);
            this.myStubTree.expandRow(0);
            this.myStubTree.addTreeSelectionListener((TreeSelectionListener)new StubTreeSelectionListener());
            treeModel.invalidate();
        } else {
            this.myStubTree.setRootVisible(false);
            StatusText text = this.myStubTree.getEmptyText();
            text.setText("Cannot build stubs for " + rootElement.getLanguage().getDisplayName());
        }
    }

    public void dispose() {
        this.resetStubTree();
    }

    @Nullable
    private static Stub buildStubForElement(Project project, PsiElement rootElement, @NotNull String textToParse) {
        PsiFileStub stub = null;
        PsiFileWithStubSupport psiFile = (PsiFileWithStubSupport)rootElement;
        StubTree tree = psiFile.getStubTree();
        if (tree != null) {
            stub = tree.getRoot();
        } else if (rootElement instanceof PsiFileImpl) {
            StubBuilder stubBuilder = StubViewerPsiBasedTree.getStubBuilder((PsiFileImpl)rootElement);
            StubElement stubElement = stub = stubBuilder == null ? null : stubBuilder.buildStubTree((PsiFile)rootElement);
        }
        if (stub == null) {
            LightVirtualFile file2 = new LightVirtualFile("stub", rootElement.getLanguage(), (CharSequence)textToParse);
            try {
                FileContentImpl fc = new FileContentImpl((VirtualFile)file2, file2.contentsToByteArray());
                fc.putUserData(IndexingDataKeys.PROJECT, project);
                fc.putUserData(IndexingDataKeys.PSI_FILE, psiFile);
                stub = StubTreeBuilder.buildStubTree(fc);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return stub;
    }

    @Nullable
    private static StubBuilder getStubBuilder(@NotNull PsiFileImpl rootElement) {
        IStubFileElementType builder2 = rootElement.getElementTypeForStubBuilder();
        return builder2 == null ? null : builder2.getBuilder();
    }

    @Override
    public void selectNodeFromPsi(@Nullable PsiElement element) {
        if (this.myTreeModel == null || element == null) {
            return;
        }
        PsiFile file2 = element.getContainingFile();
        if (!(file2 instanceof PsiFileWithStubSupport)) {
            return;
        }
        DefaultMutableTreeNode rootNode = this.getRoot();
        if (rootNode == null) {
            return;
        }
        StubElement stubElement = this.myNodeToStubs.get(element.getNode());
        if (stubElement != null) {
            this.selectStubElement(stubElement);
        } else {
            this.myStubTree.clearSelection();
        }
    }

    private void selectStubElement(StubElement<?> stubElement) {
        TreeNode node = (TreeNode)TreeUtil.treeNodeTraverser((TreeNode)this.getRoot()).traverse().find(treeNode -> treeNode instanceof DefaultMutableTreeNode && ((StubTreeNode)((Object)((Object)((DefaultMutableTreeNode)treeNode).getUserObject()))).getStub() == stubElement);
        if (node != null) {
            TreePath path = TreePathUtil.pathToTreeNode(node);
            this.myStubTree.getSelectionModel().setSelectionPath(path);
        }
    }

    private DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.myStubTree.getModel().getRoot();
    }

    public PsiElement getPsiElementForStub(StubElement<?> stub) {
        Ref result2 = Ref.create();
        this.myNodeToStubs.forEach((key, value) -> {
            if (value == stub) {
                result2.set((Object)key.getPsi());
            }
        });
        return (PsiElement)result2.get();
    }

    private void fillPsiToStubCache(@NotNull PsiFileWithStubSupport rootElement, @NotNull PsiFileStub rootStub) {
        this.fillTreeForStub(rootElement, new StubTree(rootStub));
    }

    public void fillTreeForStub(@NotNull PsiFileWithStubSupport file2, @NotNull StubTree tree) {
        StubBuilder builder2;
        StubBuilder stubBuilder = builder2 = file2 instanceof PsiFileImpl ? StubViewerPsiBasedTree.getStubBuilder((PsiFileImpl)file2) : null;
        if (builder2 == null) {
            return;
        }
        Iterator<StubElement<?>> stubs = tree.getPlainList().iterator();
        StubElement root = (StubElement)stubs.next();
        FileASTNode ast = file2.getNode();
        this.myNodeToStubs.put((ASTNode)ast, root);
        this.findTreeForStub(builder2, (ASTNode)ast, stubs);
        if (stubs.hasNext()) {
            LOG.error("Stub mismatch, unprocessed stubs " + stubs.next());
        }
    }

    private void findTreeForStub(StubBuilder builder2, ASTNode tree, Iterator<StubElement<?>> stubs) {
        IElementType type = tree.getElementType();
        if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(tree)) {
            if (!stubs.hasNext()) {
                LOG.error("Stub mismatch, " + type);
            }
            StubElement<?> curStub = stubs.next();
            this.myNodeToStubs.put(tree, curStub);
        }
        for (ASTNode node : tree.getChildren(null)) {
            if (builder2.skipChildProcessingWhenBuildingStubs(tree, node)) continue;
            this.findTreeForStub(builder2, node, stubs);
        }
    }

    private class StubTreeSelectionListener
    implements TreeSelectionListener {
        StubTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            StubElement<?> topLevelStub;
            if (StubViewerPsiBasedTree.this.myTreeModel == null) {
                return;
            }
            StubTreeNode rootNode = (StubTreeNode)((Object)StubViewerPsiBasedTree.this.getRoot().getUserObject());
            StubElement<?> stubElement = topLevelStub = rootNode == null ? null : rootNode.getStub();
            if (!(topLevelStub instanceof PsiFileStub)) {
                return;
            }
            TreePath selectionPath = StubViewerPsiBasedTree.this.myStubTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            StubElement<?> stub = ((StubTreeNode)((Object)((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject())).getStub();
            PsiElement result2 = StubViewerPsiBasedTree.this.getPsiElementForStub(stub);
            if (result2 != null) {
                StubViewerPsiBasedTree.this.myUpdater.updatePsiTree(result2, StubViewerPsiBasedTree.this.myStubTree.hasFocus() ? result2.getTextRange() : null);
            }
        }
    }
}

