/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.retype;

import com.intellij.internal.retype.RetypeSessionKt;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\t0\fj\b\u0012\u0004\u0012\u00020\t`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/internal/retype/RetypeLog;", "", "()V", "<set-?>", "", "completedChars", "getCompletedChars", "()I", "currentCompletion", "", "currentTyping", "log", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "typedChars", "getTypedChars", "flush", "", "flushCompletion", "flushTyping", "printToStdout", "recordCompletion", "c", "", "recordDesync", "message", "recordTyping", "intellij.platform.lang.impl"})
public final class RetypeLog {
    private final ArrayList<String> log;
    private String currentTyping;
    private String currentCompletion;
    private int typedChars;
    private int completedChars;

    public final int getTypedChars() {
        return this.typedChars;
    }

    public final int getCompletedChars() {
        return this.completedChars;
    }

    public final void recordTyping(char c) {
        if (this.currentTyping == null) {
            this.flushCompletion();
            this.currentTyping = "";
        }
        this.currentTyping = Intrinsics.stringPlus((String)this.currentTyping, (Object)RetypeSessionKt.toReadable(String.valueOf(c)));
        int n = this.typedChars;
        this.typedChars = n + 1;
    }

    public final void recordCompletion(char c) {
        if (this.currentCompletion == null) {
            this.flushTyping();
            this.currentCompletion = "";
        }
        this.currentCompletion = Intrinsics.stringPlus((String)this.currentCompletion, (Object)RetypeSessionKt.toReadable(String.valueOf(c)));
        int n = this.completedChars;
        this.completedChars = n + 1;
    }

    public final void recordDesync(@NotNull String message) {
        this.flush();
        this.log.add("Desync: " + message);
    }

    public final void flush() {
        this.flushTyping();
        this.flushCompletion();
    }

    private final void flushTyping() {
        if (this.currentTyping != null) {
            this.log.add("Type: " + this.currentTyping);
            this.currentTyping = null;
        }
    }

    private final void flushCompletion() {
        if (this.currentCompletion != null) {
            this.log.add("Complete: " + this.currentCompletion);
            this.currentCompletion = null;
        }
    }

    public final void printToStdout() {
        for (String s : this.log) {
            System.out.println((Object)s);
        }
    }

    public RetypeLog() {
        RetypeLog retypeLog = this;
        ArrayList arrayList = new ArrayList();
        retypeLog.log = arrayList;
    }
}

